/**
 * Copyright &copy; 2015-2020 
 */
package com.crawler.waqf.modules.sys.dao;

import java.util.List;

import com.crawler.waqf.common.persistence.CrudDao;
import com.crawler.waqf.common.persistence.annotation.MyBatisDao;
import com.crawler.waqf.modules.sys.entity.SysUser;

/**
 * 用户DAO接口
 * 
 * @version 2014-05-16
 */
@MyBatisDao
public interface SysUserDao extends CrudDao<SysUser> {
	
	/**
	 * 根据登录名称查询用户
	 * @param user
	 * @return
	 */
	public SysUser getByLoginName(SysUser user);
	
	/**
	 * 查询全部用户数目
	 * @return
	 */
	public long findAllCount(SysUser user);
	
	/**
	 * 更新用户密码
	 * @param user
	 * @return
	 */
	public int updatePasswordById(SysUser user);
	
	/**
	 * 更新登录信息，如：登录IP、登录时间
	 * @param user
	 * @return
	 */
	public int updateLoginInfo(SysUser user);

	/**
	 * 删除用户角色关联数据
	 * @param user
	 * @return
	 */
	public int deleteUserRole(SysUser user);
	
	/**
	 * 插入用户角色关联数据
	 * @param user
	 * @return
	 */
	public int insertUserRole(SysUser user);
	
	/**
	 * 更新用户信息
	 * @param user
	 * @return
	 */
	public int updateUserInfo(SysUser user);
	
	/**
	 * 
	 * 查询用户-->用来添加到常用联系人
	 * 
	 */
	public List<SysUser> searchUsers(SysUser user);
	
	
}
