/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.waf.exceptions.handlers;

import com.crawler.waf.exceptions.messages.ErrorMessage;
import com.crawler.waf.exceptions.support.ArrayQueue;

public class ErrorMessageQueueHandler {
    private static int capacity = 100;
    private static ArrayQueue<ErrorMessage> errorMessagesQueue = new ArrayQueue(capacity, true);

    public static void setCapacity(int capacity) {
        errorMessagesQueue.copyArray(capacity);
    }

    public static void add(ErrorMessage errorMessage) {
        ErrorMessage errorMessageInfo = new ErrorMessage();
        errorMessageInfo.setCode(errorMessage.getCode());
        errorMessageInfo.setHostId(errorMessage.getHostId());
        errorMessageInfo.setServerTime(errorMessage.getServerTime());
        errorMessageInfo.setType(errorMessage.getType());
        errorMessageInfo.setRequestId(errorMessage.getRequestId());
        errorMessageInfo.setMessage(errorMessage.getMessage());
        errorMessageInfo.setStackTrace(errorMessage.getStackTrace());
        errorMessagesQueue.add(errorMessageInfo);
    }

    public static ErrorMessage[] getReleasedExceptionQueue() {
        ErrorMessage[] errorMessages = errorMessagesQueue.toArray(ErrorMessage.class);
        return errorMessages;
    }

    public static ErrorMessage getReleasedException(String requestId) {
        ErrorMessage resErrorMessage = null;
        ErrorMessage[] errorMessages = ErrorMessageQueueHandler.getReleasedExceptionQueue();
        if (errorMessages != null && errorMessages.length > 0) {
            for (int i = 0; i < errorMessages.length; ++i) {
                ErrorMessage errorMessage = errorMessages[i];
                if (!errorMessage.getRequestId().equals(requestId)) continue;
                resErrorMessage = errorMessage;
                break;
            }
        }
        return resErrorMessage;
    }
}

