/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.waf.exceptions.support;

import com.crawler.waf.exceptions.extendExceptions.WafSimpleException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractQueue;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.locks.ReentrantLock;
import org.springframework.http.HttpStatus;

public class ArrayQueue<E>
extends AbstractQueue<E>
implements Queue<E>,
Serializable {
    private static final long serialVersionUID = -123590092353622781L;
    Object[] items;
    int takeIndex;
    int putIndex;
    int count;
    final ReentrantLock lock;

    public ArrayQueue(int capacity) {
        this(capacity, false);
    }

    public ArrayQueue(int capacity, boolean fair) {
        if (capacity <= 0) {
            throw new IllegalArgumentException();
        }
        this.items = new Object[capacity];
        this.lock = new ReentrantLock(fair);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(E e) {
        ArrayQueue.checkNotNull(e);
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            if (this.count == this.items.length) {
                this.poll();
                this.drainTo();
                this.takeIndex = 0;
                this.items[this.putIndex] = e;
            } else {
                this.items[this.putIndex] = e;
                this.putIndex = this.inc(this.putIndex);
            }
            ++this.count;
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drainTo() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object[] items = this.items;
            for (int i = 0; i < items.length - 1; ++i) {
                items[i] = items[i + 1];
            }
            this.putIndex = items.length - 1;
            items[this.putIndex] = null;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public E poll() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            E e = this.count == 0 ? null : (E)this.extract();
            return e;
        }
        finally {
            lock.unlock();
        }
    }

    private E extract() {
        Object[] items = this.items;
        E x = ArrayQueue.cast(items[this.takeIndex]);
        items[this.takeIndex] = null;
        this.takeIndex = this.inc(this.takeIndex);
        --this.count;
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object[] items = this.items;
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int i = this.takeIndex;
            for (int k = this.count; k > 0; --k) {
                items[i] = null;
                i = this.inc(i);
            }
            this.count = 0;
            this.putIndex = 0;
            this.takeIndex = 0;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public int size() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int n = this.count;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    public <T> T[] toArray(Class<T> componentType) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int size = this.count > 0 ? this.count : 0;
            Class<?> classType = Class.forName(componentType.getName());
            Object[] a = (Object[])Array.newInstance(classType, size);
            int k = 0;
            for (int i = 0; i < this.count; ++i) {
                a[k++] = ArrayQueue.cast(this.items[i]);
            }
            Object[] objectArray = a;
            return objectArray;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new WafSimpleException(HttpStatus.INTERNAL_SERVER_ERROR, "WAF/CLASS_NOT_FOUND_ERROR", "WafArrayBlockingQueue " + componentType + " not found");
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyArray(int maxEntries) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            if (maxEntries > 0) {
                Object[] defaultItems = this.items;
                Object[] tempItems = new Object[maxEntries];
                int j = 0;
                if (this.count > 0) {
                    for (int i = defaultItems.length - 1; i >= 0 && j < tempItems.length; --i) {
                        if (defaultItems[i] == null) continue;
                        tempItems[j++] = ArrayQueue.cast(defaultItems[i]);
                    }
                }
                this.count = j;
                this.putIndex = j < maxEntries ? j : (j - 1 > 0 ? j - 1 : 0);
                this.takeIndex = 0;
                this.items = new Object[maxEntries];
                if (this.count > 0) {
                    int k = 0;
                    for (int i = tempItems.length - 1; i >= 0; --i) {
                        if (tempItems[i] == null) continue;
                        this.items[k++] = tempItems[i];
                    }
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    final int inc(int i) {
        return ++i == this.items.length ? 0 : i;
    }

    final int dec(int i) {
        return (i == 0 ? this.items.length : i) - 1;
    }

    static <E> E cast(Object item) {
        return (E)item;
    }

    @Override
    public boolean offer(E e) {
        return false;
    }

    @Override
    public E peek() {
        return null;
    }

    @Override
    public Iterator<E> iterator() {
        return null;
    }

    private static void checkNotNull(Object v) {
        if (v == null) {
            throw new NullPointerException();
        }
    }
}

