/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.waqf.common.json;

import com.crawler.waqf.common.mapper.JsonMapper;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class AjaxJson {
    private boolean success = true;
    private String errorCode = "-1";
    private String msg = "\u64cd\u4f5c\u6210\u529f";
    private LinkedHashMap<String, Object> body = new LinkedHashMap();

    public LinkedHashMap<String, Object> getBody() {
        return this.body;
    }

    public static AjaxJson returnError(String msg) {
        AjaxJson ajaxJson = new AjaxJson();
        ajaxJson.setMsg(msg);
        ajaxJson.setSuccess(false);
        return ajaxJson;
    }

    public static AjaxJson returnSucccess(String msg, Object body) {
        AjaxJson ajaxJson = new AjaxJson();
        if (msg != null) {
            ajaxJson.setMsg(msg);
        }
        if (body != null) {
            ajaxJson.setBody(body);
        }
        ajaxJson.setSuccess(true);
        return ajaxJson;
    }

    public static AjaxJson returnSucccess(Object body) {
        return AjaxJson.returnSucccess("", body);
    }

    public static AjaxJson returnSucccess(String msg) {
        return AjaxJson.returnSucccess(msg, null);
    }

    public static AjaxJson returnSucccess() {
        return AjaxJson.returnSucccess(null);
    }

    public void setBody(Object body) {
        this.body = this.toMap(body);
    }

    public void put(String key, Object value) {
        this.body.put(key, value);
    }

    public void remove(String key) {
        this.body.remove(key);
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public LinkedHashMap<String, Object> toMap(Object object) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        Map objMap = new HashMap();
        if (object instanceof Map) {
            objMap = (Map)object;
        } else if (!(object instanceof String)) {
            try {
                Field[] declaredFields;
                for (Field field : declaredFields = object.getClass().getDeclaredFields()) {
                    field.setAccessible(true);
                    map.put(field.getName(), field.get(object));
                }
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                throw new IllegalArgumentException(ex);
            }
        } else {
            throw new IllegalArgumentException("\u53c2\u6570\u7c7b\u578b\u9519\u8bef");
        }
        for (Map.Entry entity : objMap.entrySet()) {
            map.put(String.valueOf(entity.getKey()), entity.getValue());
        }
        return map;
    }

    @JsonIgnore
    public String getJsonStr() {
        String json = JsonMapper.getInstance().toJson(this);
        return json;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorCode() {
        return this.errorCode;
    }
}

