/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.waqf.common.persistence;

import com.crawler.waqf.common.config.Global;
import com.crawler.waqf.common.persistence.Page;
import com.crawler.waqf.common.utils.StringUtils;
import com.crawler.waqf.modules.sys.entity.SysUser;
import com.crawler.waqf.modules.sys.utils.UserUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Map;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public abstract class BaseEntity<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected SysUser currentUser;
    protected Page<T> page;
    protected Map<String, String> sqlMap;
    protected boolean isNewRecord = false;
    public static final String DEL_FLAG_NORMAL = "0";
    public static final String DEL_FLAG_DELETE = "1";
    public static final String DEL_FLAG_AUDIT = "2";

    public BaseEntity() {
    }

    public BaseEntity(String id) {
        this();
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @JsonIgnore
    public Integer getIntId() {
        if (this.id != null && !"".equals(this.id)) {
            return Integer.parseInt(this.id);
        }
        return 0;
    }

    @JsonIgnore
    public Long getLongId() {
        if (this.id != null && !"".equals(this.id)) {
            return Long.parseLong(this.id);
        }
        return 0L;
    }

    @JsonIgnore
    public String getIdString() {
        if (this.id == null) {
            return null;
        }
        return String.valueOf(this.id);
    }

    @JsonIgnore
    @XmlTransient
    public SysUser getCurrentUser() {
        if (this.currentUser == null) {
            this.currentUser = UserUtils.getSysUser();
        }
        return this.currentUser;
    }

    public void setCurrentUser(SysUser currentUser) {
        this.currentUser = currentUser;
    }

    @JsonIgnore
    @XmlTransient
    public Page<T> getPage() {
        if (this.page == null) {
            this.page = new Page();
        }
        return this.page;
    }

    public Page<T> setPage(Page<T> page) {
        this.page = page;
        return page;
    }

    @JsonIgnore
    @XmlTransient
    public Map<String, String> getSqlMap() {
        if (this.sqlMap == null) {
            this.sqlMap = Maps.newHashMap();
        }
        return this.sqlMap;
    }

    public void setSqlMap(Map<String, String> sqlMap) {
        this.sqlMap = sqlMap;
    }

    public abstract void preInsert();

    public abstract void preUpdate();

    @JsonIgnore
    public boolean getIsNewRecord() {
        return this.isNewRecord || StringUtils.isBlank((CharSequence)this.getIdString());
    }

    public void setIsNewRecord(boolean isNewRecord) {
        this.isNewRecord = isNewRecord;
    }

    @JsonIgnore
    public Global getGlobal() {
        return Global.getInstance();
    }

    @JsonIgnore
    public String getDbName() {
        return Global.getConfig("jdbc.type");
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        BaseEntity that = (BaseEntity)obj;
        return null == this.getId() ? false : this.getId().equals(that.getId());
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this);
    }
}

