/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.waqf.common.persistence;

import com.crawler.waqf.common.persistence.BaseEntity;
import com.crawler.waqf.common.utils.IdGen;
import com.crawler.waqf.common.utils.StringUtils;
import com.crawler.waqf.modules.sys.entity.SysUser;
import com.crawler.waqf.modules.sys.utils.UserUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Date;
import org.hibernate.validator.constraints.Length;

public abstract class DataEntity<T>
extends BaseEntity<T> {
    private static final long serialVersionUID = 1L;
    protected String remarks;
    protected String searchKeywords;
    protected SysUser createBy;
    protected SysUser updateBy;
    @Deprecated
    protected Date createDate;
    @Deprecated
    protected Date updateDate;
    protected Date createTime;
    protected Date updateTime;
    protected String delFlag;

    public DataEntity() {
        this.delFlag = "0";
    }

    public DataEntity(String id) {
        super(id);
    }

    @Override
    public void preInsert() {
        SysUser user;
        if (!this.isNewRecord) {
            this.setId(IdGen.uuid());
        }
        if (StringUtils.isNotBlank((CharSequence)(user = UserUtils.getSysUser()).getId())) {
            this.updateBy = user;
            this.createBy = user;
        }
        this.createDate = this.updateDate = new Date();
        this.createTime = new Date();
        this.updateTime = new Date();
    }

    @Override
    public void preUpdate() {
        SysUser user = UserUtils.getSysUser();
        if (StringUtils.isNotBlank((CharSequence)user.getId())) {
            this.updateBy = user;
        }
        this.updateDate = new Date();
        this.updateTime = new Date();
    }

    @Length(min=0, max=255)
    @JsonIgnore
    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @JsonIgnore
    public SysUser getCreateBy() {
        return this.createBy;
    }

    public void setCreateBy(SysUser createBy) {
        this.createBy = createBy;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @JsonIgnore
    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    @JsonIgnore
    public SysUser getUpdateBy() {
        return this.updateBy;
    }

    public void setUpdateBy(SysUser updateBy) {
        this.updateBy = updateBy;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @JsonIgnore
    public Date getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @JsonIgnore
    public Date getCreateTime() {
        return this.createTime;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @JsonIgnore
    public Date getUpdateTime() {
        return this.updateTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    @JsonIgnore
    @Length(min=1, max=1)
    public String getDelFlag() {
        return this.delFlag;
    }

    public void setDelFlag(String delFlag) {
        this.delFlag = delFlag;
    }

    @JsonIgnore
    public String getSearchKeywords() {
        return this.searchKeywords;
    }

    public void setSearchKeywords(String searchKeywords) {
        this.searchKeywords = searchKeywords;
    }
}

