/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.waqf.common.persistence.interceptor;

import com.crawler.waqf.common.persistence.Page;
import com.crawler.waqf.common.persistence.interceptor.BaseInterceptor;
import com.crawler.waqf.common.persistence.interceptor.SQLHelper;
import com.crawler.waqf.common.utils.Reflections;
import java.sql.Connection;
import java.util.Properties;
import org.apache.ibatis.executor.statement.BaseStatementHandler;
import org.apache.ibatis.executor.statement.RoutingStatementHandler;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class})})
public class PreparePaginationInterceptor
extends BaseInterceptor {
    private static final long serialVersionUID = 1L;

    public Object intercept(Invocation ivk) throws Throwable {
        if (ivk.getTarget().getClass().isAssignableFrom(RoutingStatementHandler.class)) {
            RoutingStatementHandler statementHandler = (RoutingStatementHandler)ivk.getTarget();
            BaseStatementHandler delegate = (BaseStatementHandler)Reflections.getFieldValue(statementHandler, "delegate");
            MappedStatement mappedStatement = (MappedStatement)Reflections.getFieldValue(delegate, "mappedStatement");
            BoundSql boundSql = delegate.getBoundSql();
            Object parameterObject = boundSql.getParameterObject();
            if (parameterObject == null) {
                this.log.error("\u53c2\u6570\u672a\u5b9e\u4f8b\u5316");
                throw new NullPointerException("parameterObject\u5c1a\u672a\u5b9e\u4f8b\u5316\uff01");
            }
            Connection connection = (Connection)ivk.getArgs()[0];
            String sql = boundSql.getSql();
            int count = SQLHelper.getCount(sql, connection, mappedStatement, parameterObject, boundSql, this.log);
            Page<Object> page = null;
            page = PreparePaginationInterceptor.convertParameter(parameterObject, page);
            page.setCount(count);
            String pagingSql = SQLHelper.generatePageSql(sql, page, this.DIALECT);
            if (this.log.isDebugEnabled()) {
                this.log.debug("PAGE SQL:" + pagingSql);
            }
            Reflections.setFieldValue(boundSql, "sql", pagingSql);
            if (boundSql.getSql() == null || "".equals(boundSql.getSql())) {
                return null;
            }
        }
        return ivk.proceed();
    }

    public Object plugin(Object o) {
        return Plugin.wrap((Object)o, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
        this.initProperties(properties);
    }
}

