/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.waqf.common.persistence.proxy;

import com.crawler.waqf.common.persistence.Page;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.binding.BindingException;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.session.SqlSession;

public class PaginationMapperMethod {
    private final SqlSession sqlSession;
    private final Configuration config;
    private SqlCommandType type;
    private String commandName;
    private String commandCountName;
    private final Class<?> declaringInterface;
    private final Method method;
    private Integer rowBoundsIndex;
    private Integer paginationIndex;
    private final List<String> paramNames = new ArrayList<String>();
    private final List<Integer> paramPositions = new ArrayList<Integer>();
    private boolean hasNamedParameters;

    public PaginationMapperMethod(Class<?> declaringInterface, Method method, SqlSession sqlSession) {
        this.sqlSession = sqlSession;
        this.method = method;
        this.config = sqlSession.getConfiguration();
        this.declaringInterface = declaringInterface;
        this.hasNamedParameters = false;
        this.setupFields();
        this.setupMethodSignature();
        this.setupCommandType();
        this.validateStatement();
    }

    public Object execute(Object[] args) {
        RowBounds rowBounds;
        Page<Object> page;
        Object param = this.getParam(args);
        if (this.paginationIndex != null) {
            page = (Page<Object>)args[this.paginationIndex];
            rowBounds = new RowBounds(page.getFirstResult(), page.getMaxResults());
        } else if (this.rowBoundsIndex != null) {
            rowBounds = (RowBounds)args[this.rowBoundsIndex];
            page = new Page<Object>();
        } else {
            throw new BindingException("Invalid bound statement (not found rowBounds or pagination in paramenters)");
        }
        page.setCount(this.executeForCount(param));
        page.setList(this.executeForList(param, rowBounds));
        return page;
    }

    private long executeForCount(Object param) {
        Number result = (Number)this.sqlSession.selectOne(this.commandCountName, param);
        return result.longValue();
    }

    private List<Object> executeForList(Object param, RowBounds rowBounds) {
        return this.sqlSession.selectList(this.commandName, param, rowBounds);
    }

    private Object getParam(Object[] args) {
        int paramCount = this.paramPositions.size();
        if (args == null || paramCount == 0) {
            return null;
        }
        if (!this.hasNamedParameters && paramCount == 1) {
            return args[this.paramPositions.get(0)];
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        for (int i = 0; i < paramCount; ++i) {
            param.put(this.paramNames.get(i), args[this.paramPositions.get(i)]);
        }
        return param;
    }

    private void setupMethodSignature() {
        Class<?>[] argTypes = this.method.getParameterTypes();
        for (int i = 0; i < argTypes.length; ++i) {
            if (Page.class.isAssignableFrom(argTypes[i])) {
                this.paginationIndex = i;
                continue;
            }
            if (RowBounds.class.isAssignableFrom(argTypes[i])) {
                this.rowBoundsIndex = i;
                continue;
            }
            String paramName = String.valueOf(this.paramPositions.size());
            paramName = this.getParamNameFromAnnotation(i, paramName);
            this.paramNames.add(paramName);
            this.paramPositions.add(i);
        }
    }

    private String getParamNameFromAnnotation(int i, String paramName) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = this.method.getParameterAnnotations()[i]) {
            if (!(annotation instanceof Param)) continue;
            this.hasNamedParameters = true;
            paramName = ((Param)annotation).value();
        }
        return paramName;
    }

    private void setupFields() {
        this.commandName = this.declaringInterface.getName() + "." + this.method.getName();
        this.commandCountName = this.commandName + "Count";
    }

    private void setupCommandType() {
        MappedStatement ms = this.config.getMappedStatement(this.commandName);
        this.type = ms.getSqlCommandType();
        if (this.type != SqlCommandType.SELECT) {
            throw new BindingException("Unsupport execution method for: " + this.commandName);
        }
    }

    private void validateStatement() {
        if (!this.config.hasStatement(this.commandName)) {
            throw new BindingException("Invalid bound statement (not found): " + this.commandName);
        }
        if (!this.config.hasStatement(this.commandCountName)) {
            throw new BindingException("Invalid bound statement (not found): " + this.commandCountName);
        }
    }
}

