/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.waqf.common.utils;

import com.crawler.waqf.common.utils.SpringContextHolder;
import java.io.Serializable;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;

public class EhCacheUtils {
    private static CacheManager cacheManager = (CacheManager)SpringContextHolder.getBean("cacheManager");
    private static final String SYS_CACHE = "sysCache";

    public static Object get(String key) {
        return EhCacheUtils.get(SYS_CACHE, key);
    }

    public static void put(String key, Object value) {
        EhCacheUtils.put(SYS_CACHE, key, value);
    }

    public static void remove(String key) {
        EhCacheUtils.remove(SYS_CACHE, key);
    }

    public static Object get(String cacheName, String key) {
        Element element = EhCacheUtils.getCache(cacheName).get((Serializable)((Object)key));
        return element == null ? null : element.getObjectValue();
    }

    public static void put(String cacheName, String key, Object value) {
        Element element = new Element((Object)key, value);
        EhCacheUtils.getCache(cacheName).put(element);
    }

    public static void remove(String cacheName, String key) {
        EhCacheUtils.getCache(cacheName).remove((Serializable)((Object)key));
    }

    private static Cache getCache(String cacheName) {
        Cache cache = cacheManager.getCache(cacheName);
        if (cache == null) {
            cacheManager.addCache(cacheName);
            cache = cacheManager.getCache(cacheName);
            cache.getCacheConfiguration().setEternal(true);
        }
        return cache;
    }

    public static CacheManager getCacheManager() {
        return cacheManager;
    }
}

