/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.waqf.common.utils;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.beanutils.PropertyUtilsBean;

public class MyBeanUtils
extends PropertyUtilsBean {
    private static void convert(Object dest, Object orig) throws IllegalAccessException, InvocationTargetException {
        if (dest == null) {
            throw new IllegalArgumentException("No destination bean specified");
        }
        if (orig == null) {
            throw new IllegalArgumentException("No origin bean specified");
        }
        if (orig instanceof DynaBean) {
            DynaProperty[] origDescriptors = ((DynaBean)orig).getDynaClass().getDynaProperties();
            for (int i = 0; i < origDescriptors.length; ++i) {
                String name = origDescriptors[i].getName();
                if (!PropertyUtils.isWriteable((Object)dest, (String)name)) continue;
                Object value2 = ((DynaBean)orig).get(name);
                try {
                    MyBeanUtils.getInstance().setSimpleProperty(dest, name, value2);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        } else if (orig instanceof Map) {
            for (String name : ((Map)orig).keySet()) {
                if (!PropertyUtils.isWriteable((Object)dest, (String)name)) continue;
                Object value = ((Map)orig).get(name);
                try {
                    MyBeanUtils.getInstance().setSimpleProperty(dest, name, value);
                }
                catch (Exception value2) {}
            }
        } else {
            PropertyDescriptor[] origDescriptors = PropertyUtils.getPropertyDescriptors((Object)orig);
            for (int i = 0; i < origDescriptors.length; ++i) {
                String name = origDescriptors[i].getName();
                if ("class".equals(name) || !PropertyUtils.isReadable((Object)orig, (String)name) || !PropertyUtils.isWriteable((Object)dest, (String)name)) continue;
                try {
                    Object value = PropertyUtils.getSimpleProperty((Object)orig, (String)name);
                    MyBeanUtils.getInstance().setSimpleProperty(dest, name, value);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static void copyBeanNotNull2Bean(Object databean, Object tobean) throws Exception {
        PropertyDescriptor[] origDescriptors = PropertyUtils.getPropertyDescriptors((Object)databean);
        for (int i = 0; i < origDescriptors.length; ++i) {
            String name = origDescriptors[i].getName();
            if ("class".equals(name) || !PropertyUtils.isReadable((Object)databean, (String)name) || !PropertyUtils.isWriteable((Object)tobean, (String)name)) continue;
            try {
                Object value = PropertyUtils.getSimpleProperty((Object)databean, (String)name);
                if (value == null) continue;
                MyBeanUtils.getInstance().setSimpleProperty(tobean, name, value);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void copyBean2Bean(Object dest, Object orig) throws Exception {
        MyBeanUtils.convert(dest, orig);
    }

    public static void copyBean2Map(Map map, Object bean) {
        PropertyDescriptor[] pds = PropertyUtils.getPropertyDescriptors((Object)bean);
        for (int i = 0; i < pds.length; ++i) {
            PropertyDescriptor pd = pds[i];
            String propname = pd.getName();
            try {
                Object propvalue = PropertyUtils.getSimpleProperty((Object)bean, (String)propname);
                map.put(propname, propvalue);
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                continue;
            }
            catch (InvocationTargetException invocationTargetException) {
                continue;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
    }

    public static void copyMap2Bean(Object bean, Map properties) throws IllegalAccessException, InvocationTargetException {
        if (bean == null || properties == null) {
            return;
        }
        for (String name : properties.keySet()) {
            if (name == null) continue;
            Object value = properties.get(name);
            try {
                String className;
                Class clazz = PropertyUtils.getPropertyType((Object)bean, (String)name);
                if (null == clazz || (className = clazz.getName()).equalsIgnoreCase("java.sql.Timestamp") && (value == null || value.equals(""))) continue;
                MyBeanUtils.getInstance().setSimpleProperty(bean, name, value);
            }
            catch (NoSuchMethodException e) {}
        }
    }

    public static void copyMap2Bean_Nobig(Object bean, Map properties) throws IllegalAccessException, InvocationTargetException {
        if (bean == null || properties == null) {
            return;
        }
        for (String name : properties.keySet()) {
            if (name == null) continue;
            Object value = properties.get(name);
            try {
                Class clazz;
                if (value == null || null == (clazz = PropertyUtils.getPropertyType((Object)bean, (String)name))) continue;
                String className = clazz.getName();
                if (className.equalsIgnoreCase("java.util.Date")) {
                    value = new Date(((Timestamp)value).getTime());
                }
                MyBeanUtils.getInstance().setSimpleProperty(bean, name, value);
            }
            catch (NoSuchMethodException e) {}
        }
    }

    public static void copyMap2Bean(Object bean, Map properties, String defaultValue) throws IllegalAccessException, InvocationTargetException {
        if (bean == null || properties == null) {
            return;
        }
        for (String name : properties.keySet()) {
            if (name == null) continue;
            Object value = properties.get(name);
            try {
                String className;
                Class clazz = PropertyUtils.getPropertyType((Object)bean, (String)name);
                if (null == clazz || (className = clazz.getName()).equalsIgnoreCase("java.sql.Timestamp") && (value == null || value.equals(""))) continue;
                if (className.equalsIgnoreCase("java.lang.String") && value == null) {
                    value = defaultValue;
                }
                MyBeanUtils.getInstance().setSimpleProperty(bean, name, value);
            }
            catch (NoSuchMethodException e) {}
        }
    }
}

