/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.waqf.common.utils;

import com.alibaba.fastjson.JSONObject;
import com.crawler.waqf.common.utils.BeanUtils;
import eu.bitwalker.useragentutils.DeviceType;
import eu.bitwalker.useragentutils.OperatingSystem;
import eu.bitwalker.useragentutils.UserAgent;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class RequestUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestUtils.class);

    public static SortedMap<String, String> getFormData(HttpServletRequest request) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = request.getParameter(name);
            map.put(name, value);
        }
        return map;
    }

    public static SortedMap<String, String> getBody(HttpServletRequest request) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        try {
            String str;
            BufferedReader br = request.getReader();
            String content = "";
            while ((str = br.readLine()) != null) {
                content = content + str;
            }
            System.out.println("\u8bf7\u6c42\u4f53\u5185\u5bb9\uff1a" + content);
            if (content != null && content.startsWith("{") && content.endsWith("}")) {
                JSONObject jsonObject = JSONObject.parseObject((String)content);
                for (Map.Entry entry : jsonObject.entrySet()) {
                    Object obj = entry.getValue();
                    map.put((String)entry.getKey(), obj == null ? null : String.valueOf(obj));
                }
            }
        }
        catch (IOException ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
        }
        return map;
    }

    public static SortedMap<String, String> getData(HttpServletRequest request) {
        SortedMap<String, String> map = RequestUtils.getFormData(request);
        if (map.size() == 0) {
            map = RequestUtils.getBody(request);
            System.out.println("BODY:" + BeanUtils.toJSONString(map));
        }
        return map;
    }

    public static HttpServletRequest getRequest() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes == null) {
            return null;
        }
        return ((ServletRequestAttributes)requestAttributes).getRequest();
    }

    public static ServletRequestAttributes requestAttributes() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes == null) {
            return null;
        }
        return (ServletRequestAttributes)requestAttributes;
    }

    public static boolean isMobile(HttpServletRequest request) {
        UserAgent ua = UserAgent.parseUserAgentString((String)request.getHeader("User-Agent"));
        OperatingSystem os = ua.getOperatingSystem();
        return DeviceType.MOBILE.equals((Object)os.getDeviceType());
    }
}

