/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.waqf.common.utils.excel;

import com.crawler.waqf.common.utils.Encodes;
import com.crawler.waqf.common.utils.Reflections;
import com.crawler.waqf.common.utils.excel.annotation.ExcelField;
import com.crawler.waqf.modules.sys.utils.DictUtils;
import com.google.common.collect.Lists;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportExcel {
    private static Logger log = LoggerFactory.getLogger(ExportExcel.class);
    private SXSSFWorkbook wb;
    private SXSSFSheet sheet;
    private Map<String, CellStyle> styles;
    private int rownum;
    List<Object[]> annotationList = Lists.newArrayList();

    public ExportExcel(String title, Class<?> cls) {
        this(title, cls, 1, new int[0]);
    }

    public ExportExcel(String title, Class<?> cls, int type, int ... groups) {
        Method[] ms;
        Field[] fs;
        block0: for (Field f : fs = cls.getDeclaredFields()) {
            ExcelField ef = f.getAnnotation(ExcelField.class);
            if (ef == null || ef.type() != 0 && ef.type() != type) continue;
            if (groups != null && groups.length > 0) {
                boolean inGroup = false;
                block1: for (int g : groups) {
                    if (inGroup) continue block0;
                    for (int efg : ef.groups()) {
                        if (g != efg) continue;
                        inGroup = true;
                        this.annotationList.add(new Object[]{ef, f});
                        continue block1;
                    }
                }
                continue;
            }
            this.annotationList.add(new Object[]{ef, f});
        }
        block3: for (Method m : ms = cls.getDeclaredMethods()) {
            ExcelField ef = m.getAnnotation(ExcelField.class);
            if (ef == null || ef.type() != 0 && ef.type() != type) continue;
            if (groups != null && groups.length > 0) {
                boolean inGroup = false;
                block4: for (int g : groups) {
                    if (inGroup) continue block3;
                    for (int efg : ef.groups()) {
                        if (g != efg) continue;
                        inGroup = true;
                        this.annotationList.add(new Object[]{ef, m});
                        continue block4;
                    }
                }
                continue;
            }
            this.annotationList.add(new Object[]{ef, m});
        }
        Collections.sort(this.annotationList, new Comparator<Object[]>(){

            @Override
            public int compare(Object[] o1, Object[] o2) {
                return new Integer(((ExcelField)o1[0]).sort()).compareTo(new Integer(((ExcelField)o2[0]).sort()));
            }
        });
        ArrayList headerList = Lists.newArrayList();
        for (Object[] os : this.annotationList) {
            String[] ss;
            String t = ((ExcelField)os[0]).title();
            if (type == 1 && (ss = StringUtils.split((String)t, (String)"**", (int)2)).length == 2) {
                t = ss[0];
            }
            headerList.add(t);
        }
        this.initialize(title, headerList);
    }

    public ExportExcel(String title, String[] headers) {
        this.initialize(title, Lists.newArrayList((Object[])headers));
    }

    public ExportExcel(String title, List<String> headerList) {
        this.initialize(title, headerList);
    }

    private void initialize(String title, List<String> headerList) {
        int i;
        this.wb = new SXSSFWorkbook(500);
        this.sheet = this.wb.createSheet("Export");
        this.styles = this.createStyles((Workbook)this.wb);
        if (StringUtils.isNotBlank((CharSequence)title)) {
            SXSSFRow titleRow = this.sheet.createRow(this.rownum++);
            titleRow.setHeightInPoints(30.0f);
            Cell titleCell = titleRow.createCell(0);
            titleCell.setCellStyle(this.styles.get("title"));
            titleCell.setCellValue(title);
            this.sheet.addMergedRegion(new CellRangeAddress(titleRow.getRowNum(), titleRow.getRowNum(), titleRow.getRowNum(), headerList.size() - 1));
        }
        if (headerList == null) {
            throw new RuntimeException("headerList not null!");
        }
        SXSSFRow headerRow = this.sheet.createRow(this.rownum++);
        headerRow.setHeightInPoints(16.0f);
        for (i = 0; i < headerList.size(); ++i) {
            Cell cell = headerRow.createCell(i);
            cell.setCellStyle(this.styles.get("header"));
            String[] ss = StringUtils.split((String)headerList.get(i), (String)"**", (int)2);
            if (ss.length == 2) {
                cell.setCellValue(ss[0]);
                Comment comment = this.sheet.createDrawingPatriarch().createCellComment((ClientAnchor)new XSSFClientAnchor(0, 0, 0, 0, 3, 3, 5, 6));
                comment.setString((RichTextString)new XSSFRichTextString(ss[1]));
                cell.setCellComment(comment);
            } else {
                cell.setCellValue(headerList.get(i));
            }
            this.sheet.trackAllColumnsForAutoSizing();
            this.sheet.autoSizeColumn(i);
        }
        for (i = 0; i < headerList.size(); ++i) {
            int colWidth = this.sheet.getColumnWidth(i) * 2;
            this.sheet.setColumnWidth(i, colWidth < 3000 ? 3000 : colWidth);
        }
        log.debug("Initialize success.");
    }

    private Map<String, CellStyle> createStyles(Workbook wb) {
        HashMap<String, CellStyle> styles = new HashMap<String, CellStyle>();
        CellStyle style = wb.createCellStyle();
        style.setAlignment((short)2);
        style.setVerticalAlignment((short)1);
        Font titleFont = wb.createFont();
        titleFont.setFontName("Arial");
        titleFont.setFontHeightInPoints((short)16);
        titleFont.setBoldweight((short)700);
        style.setFont(titleFont);
        styles.put("title", style);
        style = wb.createCellStyle();
        style.setVerticalAlignment((short)1);
        style.setBorderRight((short)1);
        style.setRightBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        style.setBorderLeft((short)1);
        style.setLeftBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        style.setBorderTop((short)1);
        style.setTopBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        style.setBorderBottom((short)1);
        style.setBottomBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        Font dataFont = wb.createFont();
        dataFont.setFontName("Arial");
        dataFont.setFontHeightInPoints((short)10);
        style.setFont(dataFont);
        styles.put("data", style);
        style = wb.createCellStyle();
        style.cloneStyleFrom((CellStyle)styles.get("data"));
        style.setAlignment((short)1);
        styles.put("data1", style);
        style = wb.createCellStyle();
        style.cloneStyleFrom((CellStyle)styles.get("data"));
        style.setAlignment((short)2);
        styles.put("data2", style);
        style = wb.createCellStyle();
        style.cloneStyleFrom((CellStyle)styles.get("data"));
        style.setAlignment((short)3);
        styles.put("data3", style);
        style = wb.createCellStyle();
        style.cloneStyleFrom((CellStyle)styles.get("data"));
        style.setAlignment((short)2);
        style.setFillForegroundColor(IndexedColors.GREY_50_PERCENT.getIndex());
        style.setFillPattern((short)1);
        Font headerFont = wb.createFont();
        headerFont.setFontName("Arial");
        headerFont.setFontHeightInPoints((short)10);
        headerFont.setBoldweight((short)700);
        headerFont.setColor(IndexedColors.WHITE.getIndex());
        style.setFont(headerFont);
        styles.put("header", style);
        return styles;
    }

    public Row addRow() {
        return this.sheet.createRow(this.rownum++);
    }

    public Cell addCell(Row row, int column, Object val) {
        return this.addCell(row, column, val, 0, Class.class);
    }

    public Cell addCell(Row row, int column, Object val, int align, Class<?> fieldType) {
        Cell cell = row.createCell(column);
        CellStyle style = this.styles.get("data" + (align >= 1 && align <= 3 ? Integer.valueOf(align) : ""));
        try {
            if (val == null) {
                cell.setCellValue("");
            } else if (val instanceof String) {
                cell.setCellValue((String)val);
            } else if (val instanceof Integer) {
                cell.setCellValue((double)((Integer)val).intValue());
            } else if (val instanceof Long) {
                cell.setCellValue((double)((Long)val).longValue());
            } else if (val instanceof Double) {
                cell.setCellValue(((Double)val).doubleValue());
            } else if (val instanceof Float) {
                cell.setCellValue((double)((Float)val).floatValue());
            } else if (val instanceof Date) {
                DataFormat format = this.wb.createDataFormat();
                style.setDataFormat(format.getFormat("yyyy-MM-dd HH:mm:ss"));
                cell.setCellValue((Date)val);
            } else if (fieldType != Class.class) {
                cell.setCellValue((String)fieldType.getMethod("setValue", Object.class).invoke(null, val));
            } else {
                cell.setCellValue((String)Class.forName(this.getClass().getName().replaceAll(this.getClass().getSimpleName(), "fieldtype." + val.getClass().getSimpleName() + "Type")).getMethod("setValue", Object.class).invoke(null, val));
            }
        }
        catch (Exception ex) {
            log.info("Set cell value [" + row.getRowNum() + "," + column + "] error: " + ex.toString());
            cell.setCellValue(val.toString());
        }
        cell.setCellStyle(style);
        return cell;
    }

    public <E> ExportExcel setDataList(List<E> list) {
        for (E e : list) {
            int colunm = 0;
            Row row = this.addRow();
            StringBuilder sb = new StringBuilder();
            for (Object[] os : this.annotationList) {
                ExcelField ef = (ExcelField)os[0];
                Object val = null;
                try {
                    if (StringUtils.isNotBlank((CharSequence)ef.value())) {
                        val = Reflections.invokeGetter(e, ef.value());
                    } else if (os[1] instanceof Field) {
                        val = Reflections.invokeGetter(e, ((Field)os[1]).getName());
                    } else if (os[1] instanceof Method) {
                        val = Reflections.invokeMethod(e, ((Method)os[1]).getName(), new Class[0], new Object[0]);
                    }
                    if (StringUtils.isNotBlank((CharSequence)ef.dictType())) {
                        val = DictUtils.getDictLabel(val == null ? "" : val.toString(), ef.dictType(), "");
                    }
                    if (StringUtils.isNotBlank((CharSequence)ef.format()) && val instanceof Date) {
                        val = DateFormatUtils.format((Date)((Date)val), (String)ef.format());
                    }
                }
                catch (Exception ex) {
                    log.info(ex.toString());
                    val = "";
                }
                this.addCell(row, colunm++, val, ef.align(), ef.fieldType());
                sb.append(val + ", ");
            }
            log.debug("Write success: [" + row.getRowNum() + "] " + sb.toString());
        }
        return this;
    }

    public ExportExcel write(OutputStream os) throws IOException {
        this.wb.write(os);
        return this;
    }

    public ExportExcel write(HttpServletResponse response, String fileName) throws IOException {
        response.reset();
        response.setContentType("application/octet-stream; charset=utf-8");
        response.setHeader("Content-Disposition", "attachment; filename=" + Encodes.urlEncode(fileName));
        this.write((OutputStream)response.getOutputStream());
        return this;
    }

    public ExportExcel writeFile(String name) throws FileNotFoundException, IOException {
        FileOutputStream os = new FileOutputStream(name);
        this.write(os);
        return this;
    }

    public ExportExcel dispose() {
        this.wb.dispose();
        return this;
    }
}

