/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.waqf.common.web;

import com.crawler.res.common.ResConstant;
import com.crawler.res.utils.FileUtils;
import com.crawler.waqf.common.beanvalidator.BeanValidators;
import com.crawler.waqf.common.mapper.JsonMapper;
import com.crawler.waqf.common.utils.DateUtils;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletResponse;
import javax.validation.ConstraintViolationException;
import javax.validation.ValidationException;
import javax.validation.Validator;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.ui.Model;
import org.springframework.validation.BindException;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

public abstract class BaseController {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${adminPath}")
    protected String adminPath;
    @Value(value="${frontPath}")
    protected String frontPath;
    @Value(value="${urlSuffix}")
    protected String urlSuffix;
    @Autowired
    protected Validator validator;

    protected boolean beanValidator(Model model, Object object, Class<?> ... groups) {
        try {
            BeanValidators.validateWithException(this.validator, object, groups);
        }
        catch (ConstraintViolationException ex) {
            List<String> list = BeanValidators.extractPropertyAndMessageAsList(ex, ": ");
            list.add(0, "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff1a");
            this.addMessage(model, list.toArray(new String[0]));
            return false;
        }
        return true;
    }

    protected boolean beanValidator(RedirectAttributes redirectAttributes, Object object, Class<?> ... groups) {
        try {
            BeanValidators.validateWithException(this.validator, object, groups);
        }
        catch (ConstraintViolationException ex) {
            List<String> list = BeanValidators.extractPropertyAndMessageAsList(ex, ": ");
            list.add(0, "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff1a");
            this.addMessage(redirectAttributes, list.toArray(new String[0]));
            return false;
        }
        return true;
    }

    protected void beanValidator(Object object, Class<?> ... groups) {
        BeanValidators.validateWithException(this.validator, object, groups);
    }

    protected void addMessage(Model model, String ... messages) {
        StringBuilder sb = new StringBuilder();
        for (String message : messages) {
            sb.append(message).append(messages.length > 1 ? "<br/>" : "");
        }
        model.addAttribute("message", (Object)sb.toString());
    }

    protected void addMessage(RedirectAttributes redirectAttributes, String ... messages) {
        StringBuilder sb = new StringBuilder();
        for (String message : messages) {
            sb.append(message).append(messages.length > 1 ? "<br/>" : "");
        }
        redirectAttributes.addFlashAttribute("message", (Object)sb.toString());
    }

    protected String renderString(HttpServletResponse response, Object object) {
        return this.renderString(response, JsonMapper.toJsonString(object));
    }

    protected String renderString(HttpServletResponse response, String string) {
        try {
            response.reset();
            response.setContentType("application/json");
            response.setCharacterEncoding("utf-8");
            response.getWriter().print(string);
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    @ExceptionHandler(value={BindException.class, ConstraintViolationException.class, ValidationException.class})
    public String bindException() {
        return "error/400";
    }

    @ExceptionHandler(value={AuthenticationException.class})
    public String authenticationException() {
        return "error/403";
    }

    @InitBinder
    protected void initBinder(WebDataBinder binder) {
        binder.registerCustomEditor(String.class, (PropertyEditor)new PropertyEditorSupport(){

            @Override
            public void setAsText(String text) {
                String tempFileStart;
                String value = null;
                if (text != null) {
                    value = StringEscapeUtils.escapeHtml4((String)text.trim());
                }
                if (!(tempFileStart = ResConstant.FILE_SERVER_DOMAIN + "/" + ResConstant.FILE_SERVER_TEMP_DIR).matches("^.+/$")) {
                    tempFileStart = tempFileStart + "/";
                }
                if (value.contains(tempFileStart)) {
                    Pattern pattern = Pattern.compile(tempFileStart + "[^,;\uff0c\uff1b'\\s\"\\n]+");
                    Matcher matcher = pattern.matcher(value);
                    while (matcher.find()) {
                        String tempUrl = matcher.group();
                        if (!FileUtils.isTemp((String)tempUrl)) continue;
                        String url = FileUtils.save((String)tempUrl);
                        BaseController.this.logger.info("\u4e34\u65f6\u5730\u5740\uff1a{} \n\u6b63\u5f0f\u5730\u5740\uff1a{}", (Object)tempUrl, (Object)url);
                        value = value.replace(tempUrl, url);
                    }
                }
                this.setValue(value);
            }

            @Override
            public String getAsText() {
                Object value = this.getValue();
                return value != null ? value.toString() : "";
            }
        });
        binder.registerCustomEditor(Date.class, (PropertyEditor)new PropertyEditorSupport(){

            @Override
            public void setAsText(String text) {
                this.setValue(DateUtils.parseDate(text));
            }
        });
    }
}

