/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.waqf.modules.sys.entity;

import com.crawler.waqf.common.persistence.DataEntity;
import com.crawler.waqf.modules.sys.entity.Menu;
import com.crawler.waqf.modules.sys.entity.SysUser;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.constraints.Length;

public class Role
extends DataEntity<Role> {
    private static final long serialVersionUID = 1L;
    private String name;
    private String enname;
    private String roleType;
    private String oldName;
    private String oldEnname;
    private String sysData;
    private String useable;
    private SysUser user;
    private List<Menu> menuList = Lists.newArrayList();

    public Role() {
        this.useable = "1";
    }

    public Role(String id) {
        super(id);
    }

    public Role(SysUser user) {
        this();
        this.user = user;
    }

    public String getUseable() {
        return this.useable;
    }

    public void setUseable(String useable) {
        this.useable = useable;
    }

    public String getSysData() {
        return this.sysData;
    }

    public void setSysData(String sysData) {
        this.sysData = sysData;
    }

    @Length(min=1, max=100)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Length(min=1, max=100)
    public String getEnname() {
        return this.enname;
    }

    public void setEnname(String enname) {
        this.enname = enname;
    }

    @Length(min=1, max=100)
    public String getRoleType() {
        return this.roleType;
    }

    public void setRoleType(String roleType) {
        this.roleType = roleType;
    }

    public String getOldName() {
        return this.oldName;
    }

    public void setOldName(String oldName) {
        this.oldName = oldName;
    }

    public String getOldEnname() {
        return this.oldEnname;
    }

    public void setOldEnname(String oldEnname) {
        this.oldEnname = oldEnname;
    }

    public List<Menu> getMenuList() {
        return this.menuList;
    }

    public void setMenuList(List<Menu> menuList) {
        this.menuList = menuList;
    }

    public List<String> getMenuIdList() {
        ArrayList menuIdList = Lists.newArrayList();
        for (Menu menu : this.menuList) {
            menuIdList.add(menu.getId());
        }
        return menuIdList;
    }

    public void setMenuIdList(List<String> menuIdList) {
        this.menuList = Lists.newArrayList();
        for (String menuId : menuIdList) {
            Menu menu = new Menu();
            menu.setId(menuId);
            this.menuList.add(menu);
        }
    }

    public String getMenuIds() {
        return StringUtils.join(this.getMenuIdList(), (String)",");
    }

    public void setMenuIds(String menuIds) {
        this.menuList = Lists.newArrayList();
        if (menuIds != null) {
            Object[] ids = StringUtils.split((String)menuIds, (String)",");
            this.setMenuIdList(Lists.newArrayList((Object[])ids));
        }
    }

    public List<String> getPermissions() {
        ArrayList permissions = Lists.newArrayList();
        for (Menu menu : this.menuList) {
            if (menu.getPermission() == null || "".equals(menu.getPermission())) continue;
            permissions.add(menu.getPermission());
        }
        return permissions;
    }

    public SysUser getUser() {
        return this.user;
    }

    public void setUser(SysUser user) {
        this.user = user;
    }
}

