/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.waqf.modules.sys.security;

import com.crawler.waqf.common.config.Global;
import com.crawler.waqf.common.utils.Encodes;
import com.crawler.waqf.common.utils.SpringContextHolder;
import com.crawler.waqf.common.web.Servlets;
import com.crawler.waqf.modules.sys.entity.Menu;
import com.crawler.waqf.modules.sys.entity.Role;
import com.crawler.waqf.modules.sys.entity.SysUser;
import com.crawler.waqf.modules.sys.security.UsernamePasswordToken;
import com.crawler.waqf.modules.sys.service.SystemService;
import com.crawler.waqf.modules.sys.utils.LogUtils;
import com.crawler.waqf.modules.sys.utils.UserUtils;
import com.crawler.waqf.modules.sys.web.LoginController;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.authc.credential.HashedCredentialsMatcher;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.cache.Cache;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.apache.shiro.util.ByteSource;
import org.apache.shiro.web.util.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SystemAuthorizingRealm
extends AuthorizingRealm {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private SystemService systemService;
    @Autowired
    HttpServletRequest request;

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authcToken) {
        SysUser user;
        boolean mobile;
        UsernamePasswordToken token = (UsernamePasswordToken)authcToken;
        int activeSessionSize = this.getSystemService().getSessionDao().getActiveSessions(false).size();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("login submit, active session size: {}, username: {}", (Object)activeSessionSize, (Object)token.getUsername());
        }
        if (!(mobile = WebUtils.isTrue((ServletRequest)this.request, (String)"mobileLogin")) && LoginController.isValidateCodeLogin(token.getUsername(), false, false)) {
            Session session = UserUtils.getSession();
            String code = (String)session.getAttribute((Object)"validateCode");
            if (token.getCaptcha() == null || !token.getCaptcha().toUpperCase().equals(code)) {
                throw new AuthenticationException("msg:\u9a8c\u8bc1\u7801\u9519\u8bef, \u8bf7\u91cd\u8bd5.");
            }
        }
        if ((user = this.getSystemService().getUserByLoginName(token.getUsername())) != null) {
            if (user.getLocked() == Global.ENABLE) {
                throw new AuthenticationException("msg:\u8be5\u5df2\u5e10\u53f7\u7981\u6b62\u767b\u5f55.");
            }
            byte[] salt = Encodes.decodeHex(user.getPassword().substring(0, 16));
            return new SimpleAuthenticationInfo((Object)new Principal(user, token.isMobileLogin()), (Object)user.getPassword().substring(16), ByteSource.Util.bytes((byte[])salt), this.getName());
        }
        return null;
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        SysUser user;
        Collection<Session> sessions;
        Principal principal = (Principal)this.getAvailablePrincipal(principals);
        if (!"true".equals(Global.getConfig("user.multiAccountLogin")) && (sessions = this.getSystemService().getSessionDao().getActiveSessions(true, principal, UserUtils.getSession())).size() > 0) {
            if (UserUtils.getSubject().isAuthenticated()) {
                for (Session session : sessions) {
                    this.getSystemService().getSessionDao().delete(session);
                }
            } else {
                UserUtils.getSubject().logout();
                throw new AuthenticationException("msg:\u8d26\u53f7\u5df2\u5728\u5176\u5b83\u5730\u65b9\u767b\u5f55\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55\u3002");
            }
        }
        if ((user = this.getSystemService().getUserByLoginName(principal.getLoginName())) != null) {
            SimpleAuthorizationInfo info = new SimpleAuthorizationInfo();
            List<Menu> list = UserUtils.getMenuList();
            for (Menu menu : list) {
                if (!StringUtils.isNotBlank((CharSequence)menu.getPermission())) continue;
                for (String permission : StringUtils.split((String)menu.getPermission(), (String)",")) {
                    info.addStringPermission(permission);
                }
            }
            info.addStringPermission("user");
            for (Role role : user.getRoleList()) {
                info.addRole(role.getEnname());
            }
            this.getSystemService().updateUserLoginInfo(user);
            LogUtils.saveLog(Servlets.getRequest(), "\u7cfb\u7edf\u767b\u5f55");
            return info;
        }
        return null;
    }

    protected void checkPermission(Permission permission, AuthorizationInfo info) {
        this.authorizationValidate(permission);
        super.checkPermission(permission, info);
    }

    protected boolean[] isPermitted(List<Permission> permissions, AuthorizationInfo info) {
        if (permissions != null && !permissions.isEmpty()) {
            for (Permission permission : permissions) {
                this.authorizationValidate(permission);
            }
        }
        return super.isPermitted(permissions, info);
    }

    public boolean isPermitted(PrincipalCollection principals, Permission permission) {
        this.authorizationValidate(permission);
        return super.isPermitted(principals, permission);
    }

    protected boolean isPermittedAll(Collection<Permission> permissions, AuthorizationInfo info) {
        if (permissions != null && !permissions.isEmpty()) {
            for (Permission permission : permissions) {
                this.authorizationValidate(permission);
            }
        }
        return super.isPermittedAll(permissions, info);
    }

    private void authorizationValidate(Permission permission) {
    }

    @PostConstruct
    public void initCredentialsMatcher() {
        HashedCredentialsMatcher matcher = new HashedCredentialsMatcher("SHA-1");
        matcher.setHashIterations(1024);
        this.setCredentialsMatcher((CredentialsMatcher)matcher);
    }

    public void clearCachedAuthorizationInfo(Principal principal) {
        SimplePrincipalCollection principals = new SimplePrincipalCollection((Object)principal, this.getName());
        this.clearCachedAuthorizationInfo((PrincipalCollection)principals);
    }

    @Deprecated
    public void clearAllCachedAuthorizationInfo() {
        Cache cache = this.getAuthorizationCache();
        if (cache != null) {
            for (Object key : cache.keys()) {
                cache.remove(key);
            }
        }
    }

    public SystemService getSystemService() {
        if (this.systemService == null) {
            this.systemService = SpringContextHolder.getBean(SystemService.class);
        }
        return this.systemService;
    }

    public static class Principal
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String id;
        private String loginName;
        private String name;
        private boolean mobileLogin;

        public Principal(SysUser user, boolean mobileLogin) {
            this.id = user.getId();
            this.loginName = user.getLoginName();
            this.name = user.getName();
            this.mobileLogin = mobileLogin;
        }

        public String getId() {
            return this.id;
        }

        public String getLoginName() {
            return this.loginName;
        }

        public String getName() {
            return this.name;
        }

        public boolean isMobileLogin() {
            return this.mobileLogin;
        }

        public String getSessionid() {
            try {
                return (String)((Object)UserUtils.getSession().getId());
            }
            catch (Exception e) {
                return "";
            }
        }

        public String toString() {
            return this.id;
        }
    }
}

