/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.waqf.modules.sys.utils;

import com.crawler.waqf.common.utils.CacheUtils;
import com.crawler.waqf.common.utils.SpringContextHolder;
import com.crawler.waqf.modules.sys.dao.AreaDao;
import com.crawler.waqf.modules.sys.dao.MenuDao;
import com.crawler.waqf.modules.sys.dao.RoleDao;
import com.crawler.waqf.modules.sys.dao.SysUserDao;
import com.crawler.waqf.modules.sys.entity.Area;
import com.crawler.waqf.modules.sys.entity.Menu;
import com.crawler.waqf.modules.sys.entity.Role;
import com.crawler.waqf.modules.sys.entity.SysUser;
import com.crawler.waqf.modules.sys.entity.User;
import com.crawler.waqf.modules.sys.security.SystemAuthorizingRealm;
import java.util.Date;
import java.util.List;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.UnavailableSecurityManagerException;
import org.apache.shiro.session.InvalidSessionException;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.springframework.beans.BeanUtils;

public class UserUtils {
    private static SysUserDao userDao = SpringContextHolder.getBean(SysUserDao.class);
    private static RoleDao roleDao = SpringContextHolder.getBean(RoleDao.class);
    private static MenuDao menuDao = SpringContextHolder.getBean(MenuDao.class);
    private static AreaDao areaDao = SpringContextHolder.getBean(AreaDao.class);
    public static final String USER_CACHE = "userCache";
    public static final String USER_CACHE_ID_ = "id_";
    public static final String USER_CACHE_LOGIN_NAME_ = "ln";
    public static final String USER_CACHE_LIST_BY_OFFICE_ID_ = "oid_";
    public static final String CACHE_ROLE_LIST = "roleList";
    public static final String CACHE_MENU_LIST = "menuList";
    public static final String CACHE_AREA_LIST = "areaList";

    public static SysUser get(String id) {
        SysUser user = (SysUser)CacheUtils.get(USER_CACHE, USER_CACHE_ID_ + id);
        if (user == null) {
            user = (SysUser)((Object)userDao.get(id));
            if (user == null) {
                return null;
            }
            user.setRoleList(roleDao.findList(new Role(user)));
            CacheUtils.put(USER_CACHE, USER_CACHE_ID_ + user.getId(), user);
            CacheUtils.put(USER_CACHE, USER_CACHE_LOGIN_NAME_ + user.getLoginName(), user);
        }
        return user;
    }

    public static SysUser get(Number id) {
        return UserUtils.get(String.valueOf(id));
    }

    public static SysUser getByLoginName(String loginName) {
        SysUser user = (SysUser)CacheUtils.get(USER_CACHE, USER_CACHE_LOGIN_NAME_ + loginName);
        if (user == null) {
            user = userDao.getByLoginName(new SysUser(null, loginName));
            if (user == null) {
                return null;
            }
            user.setRoleList(roleDao.findList(new Role(user)));
            CacheUtils.put(USER_CACHE, USER_CACHE_ID_ + user.getId(), user);
            CacheUtils.put(USER_CACHE, USER_CACHE_LOGIN_NAME_ + user.getLoginName(), user);
        }
        return user;
    }

    public static void clearCache() {
        UserUtils.removeCache(CACHE_ROLE_LIST);
        UserUtils.removeCache(CACHE_MENU_LIST);
        UserUtils.removeCache(CACHE_AREA_LIST);
        UserUtils.clearCache(UserUtils.getSysUser());
    }

    public static void clearCache(SysUser user) {
        CacheUtils.remove(USER_CACHE, USER_CACHE_ID_ + user.getId());
        CacheUtils.remove(USER_CACHE, USER_CACHE_LOGIN_NAME_ + user.getLoginName());
        CacheUtils.remove(USER_CACHE, USER_CACHE_LOGIN_NAME_ + user.getOldLoginName());
    }

    @Deprecated
    public static User getUser() {
        User user = new User();
        BeanUtils.copyProperties((Object)UserUtils.getSysUser(), (Object)user, (String[])new String[]{"currentUser", "page", "sqlMap"});
        return user;
    }

    public static SysUser getSysUser() {
        SystemAuthorizingRealm.Principal principal = UserUtils.getPrincipal();
        if (principal != null) {
            SysUser user = UserUtils.get(principal.getId());
            if (user != null) {
                return user;
            }
            return new SysUser();
        }
        return new SysUser();
    }

    public static List<Role> getRoleList() {
        List<Role> roleList = (List<Role>)UserUtils.getCache(CACHE_ROLE_LIST);
        if (roleList == null) {
            SysUser user = UserUtils.getSysUser();
            if (user.isAdmin()) {
                roleList = roleDao.findAllList(new Role());
            } else {
                Role role = new Role();
                roleList = roleDao.findList(role);
            }
            UserUtils.putCache(CACHE_ROLE_LIST, roleList);
        }
        return roleList;
    }

    public static List<Menu> getMenuList() {
        List<Menu> menuList = (List<Menu>)UserUtils.getCache(CACHE_MENU_LIST);
        if (menuList == null || menuList.size() == 0) {
            SysUser user = UserUtils.getSysUser();
            if (user.isDeveloper()) {
                menuList = menuDao.findAllList(new Menu());
            } else {
                Menu m = new Menu();
                m.setUserId(user.getId());
                menuList = menuDao.findByUserId(m);
            }
            UserUtils.putCache(CACHE_MENU_LIST, menuList);
        }
        return menuList;
    }

    public static Menu getTopMenu() {
        List<Menu> list = UserUtils.getMenuList();
        if (list.size() > 0) {
            return UserUtils.getMenuList().get(0);
        }
        return null;
    }

    public static List<Area> getAreaList() {
        List<Area> areaList = (List<Area>)UserUtils.getCache(CACHE_AREA_LIST);
        if (areaList == null) {
            areaList = areaDao.findAllList(new Area());
            UserUtils.putCache(CACHE_AREA_LIST, areaList);
        }
        return areaList;
    }

    public static Subject getSubject() {
        return SecurityUtils.getSubject();
    }

    public static SystemAuthorizingRealm.Principal getPrincipal() {
        try {
            Subject subject = SecurityUtils.getSubject();
            SystemAuthorizingRealm.Principal principal = (SystemAuthorizingRealm.Principal)subject.getPrincipal();
            if (principal != null) {
                return principal;
            }
        }
        catch (UnavailableSecurityManagerException unavailableSecurityManagerException) {
        }
        catch (InvalidSessionException invalidSessionException) {
            // empty catch block
        }
        return null;
    }

    public static Session getSession() {
        try {
            Subject subject = SecurityUtils.getSubject();
            Session session = subject.getSession(false);
            if (session == null) {
                session = subject.getSession();
            }
            if (session != null) {
                return session;
            }
        }
        catch (InvalidSessionException invalidSessionException) {
            // empty catch block
        }
        return null;
    }

    public static Object getCache(String key) {
        return UserUtils.getCache(key, null);
    }

    public static Object getCache(String key, Object defaultValue) {
        Object obj = UserUtils.getSession().getAttribute((Object)key);
        return obj == null ? defaultValue : obj;
    }

    public static void putCache(String key, Object value) {
        UserUtils.getSession().setAttribute((Object)key, value);
    }

    public static void removeCache(String key) {
        UserUtils.getSession().removeAttribute((Object)key);
    }

    public static String getTime(Date date) {
        StringBuffer time = new StringBuffer();
        Date date2 = new Date();
        long temp = date2.getTime() - date.getTime();
        long days = temp / 1000L / 3600L / 24L;
        if (days > 0L) {
            time.append(days + "\u5929");
        }
        long temp1 = temp % 86400000L;
        long hours = temp1 / 1000L / 3600L;
        if (days > 0L || hours > 0L) {
            time.append(hours + "\u5c0f\u65f6");
        }
        long temp2 = temp1 % 3600000L;
        long mins = temp2 / 1000L / 60L;
        time.append(mins + "\u5206\u949f");
        return time.toString();
    }

    public static SysUser getByUserName(String name) {
        SysUser u = new SysUser();
        u.setName(name);
        List<SysUser> list = userDao.findList(u);
        if (list.size() > 0) {
            return list.get(0);
        }
        return new SysUser();
    }

    public static Area getByAreaName(String name) {
        Area a = new Area();
        a.setName(name);
        List<Area> list = areaDao.findList(a);
        if (list.size() > 0) {
            return list.get(0);
        }
        return new Area();
    }
}

