/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.waqf.modules.sys.web;

import com.crawler.waqf.common.persistence.Page;
import com.crawler.waqf.common.utils.Collections3;
import com.crawler.waqf.common.utils.StringUtils;
import com.crawler.waqf.common.web.BaseController;
import com.crawler.waqf.modules.sys.entity.Role;
import com.crawler.waqf.modules.sys.entity.SysUser;
import com.crawler.waqf.modules.sys.service.SystemService;
import com.crawler.waqf.modules.sys.utils.UserUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"${adminPath}/sys/role"})
public class RoleController
extends BaseController {
    @Autowired
    private SystemService systemService;

    @ModelAttribute(value="role")
    public Role get(@RequestParam(required=false) String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            return this.systemService.getRole(id);
        }
        return new Role();
    }

    @RequiresPermissions(value={"sys:role:list"})
    @RequestMapping(value={"list", ""})
    public String list(Role role, Model model) {
        List<Role> list = this.systemService.findRole(role);
        model.addAttribute("list", list);
        return "modules/sys/roleList";
    }

    @RequiresPermissions(value={"sys:role:view", "sys:role:add", "sys:role:edit"}, logical=Logical.OR)
    @RequestMapping(value={"form"})
    public String form(Role role, Model model) {
        model.addAttribute("role", (Object)role);
        model.addAttribute("menuList", this.systemService.findAllMenu());
        return "modules/sys/roleForm";
    }

    @RequiresPermissions(value={"sys:role:auth"})
    @RequestMapping(value={"auth"})
    public String auth(Role role, Model model) {
        model.addAttribute("role", (Object)role);
        model.addAttribute("menuList", this.systemService.findAllMenu());
        return "modules/sys/roleAuth";
    }

    @RequiresPermissions(value={"sys:role:assign", "sys:role:auth", "sys:role:add", "sys:role:edit"}, logical=Logical.OR)
    @RequestMapping(value={"save"})
    public String save(Role role, Model model, RedirectAttributes redirectAttributes) {
        if (!UserUtils.getSysUser().isAdmin() && role.getSysData().equals("1")) {
            this.addMessage(redirectAttributes, "\u8d8a\u6743\u64cd\u4f5c\uff0c\u53ea\u6709\u8d85\u7ea7\u7ba1\u7406\u5458\u624d\u80fd\u4fee\u6539\u6b64\u6570\u636e\uff01");
            return "redirect:" + this.adminPath + "/sys/role/?repage";
        }
        if (!this.beanValidator(model, (Object)role, new Class[0])) {
            return this.list(role, model);
        }
        if (!"true".equals(this.checkName(role.getOldName(), role.getName()))) {
            this.addMessage(model, "\u4fdd\u5b58\u89d2\u8272'" + role.getName() + "'\u5931\u8d25, \u89d2\u8272\u540d\u5df2\u5b58\u5728");
            return this.list(role, model);
        }
        if (!"true".equals(this.checkEnname(role.getOldEnname(), role.getEnname()))) {
            this.addMessage(model, "\u4fdd\u5b58\u89d2\u8272'" + role.getName() + "'\u5931\u8d25, \u82f1\u6587\u540d\u5df2\u5b58\u5728");
            return this.list(role, model);
        }
        this.systemService.saveRole(role);
        this.addMessage(redirectAttributes, "\u4fdd\u5b58\u89d2\u8272'" + role.getName() + "'\u6210\u529f");
        return "redirect:" + this.adminPath + "/sys/role/?repage";
    }

    @RequiresPermissions(value={"sys:role:del"})
    @RequestMapping(value={"delete"})
    public String delete(Role role, RedirectAttributes redirectAttributes) {
        if (!UserUtils.getSysUser().isAdmin() && role.getSysData().equals("1")) {
            this.addMessage(redirectAttributes, "\u8d8a\u6743\u64cd\u4f5c\uff0c\u53ea\u6709\u8d85\u7ea7\u7ba1\u7406\u5458\u624d\u80fd\u4fee\u6539\u6b64\u6570\u636e\uff01");
            return "redirect:" + this.adminPath + "/sys/role/?repage";
        }
        this.systemService.deleteRole(role);
        this.addMessage(redirectAttributes, "\u5220\u9664\u89d2\u8272\u6210\u529f");
        return "redirect:" + this.adminPath + "/sys/role/?repage";
    }

    @RequiresPermissions(value={"sys:role:del"})
    @RequestMapping(value={"deleteAll"})
    public String deleteAll(String ids, RedirectAttributes redirectAttributes) {
        String[] idArray = ids.split(",");
        StringBuffer msg = new StringBuffer();
        for (String id : idArray) {
            Role role = this.systemService.getRole(id);
            if (!UserUtils.getSysUser().isAdmin() && role.getSysData().equals("1")) {
                msg.append("\u8d8a\u6743\u64cd\u4f5c\uff0c\u53ea\u6709\u8d85\u7ea7\u7ba1\u7406\u5458\u624d\u80fd\u4fee\u6539[" + role.getName() + "]\u6570\u636e\uff01<br/>");
                continue;
            }
            this.systemService.deleteRole(role);
            msg.append("\u5220\u9664\u89d2\u8272[" + role.getName() + "]\u6210\u529f<br/>");
        }
        this.addMessage(redirectAttributes, msg.toString());
        return "redirect:" + this.adminPath + "/sys/role/?repage";
    }

    @RequiresPermissions(value={"sys:role:assign"})
    @RequestMapping(value={"assign"})
    public String assign(Role role, Model model) {
        List<SysUser> userList = this.systemService.findUser(new SysUser(new Role(role.getId())));
        model.addAttribute("userList", userList);
        return "modules/sys/roleAssign";
    }

    @RequiresPermissions(value={"sys:role:assign"})
    @RequestMapping(value={"usertorole"})
    public String selectUserToRole(Role role, Model model) {
        List<SysUser> userList = this.systemService.findUser(new SysUser(new Role(role.getId())));
        model.addAttribute("role", (Object)role);
        model.addAttribute("userList", userList);
        model.addAttribute("selectIds", (Object)Collections3.extractToString(userList, "name", ","));
        return "modules/sys/selectUserToRole";
    }

    @RequiresPermissions(value={"sys:role:assign"})
    @ResponseBody
    @RequestMapping(value={"users"})
    public List<Map<String, Object>> users(String officeId, HttpServletResponse response) {
        ArrayList mapList = Lists.newArrayList();
        SysUser user = new SysUser();
        Page<SysUser> page = this.systemService.findUser(new Page<SysUser>(1, -1), user);
        for (SysUser e : page.getList()) {
            HashMap map = Maps.newHashMap();
            map.put("id", e.getId());
            map.put("pId", 0);
            map.put("name", e.getName());
            mapList.add(map);
        }
        return mapList;
    }

    @RequiresPermissions(value={"sys:role:assign"})
    @RequestMapping(value={"outrole"})
    public String outrole(String userId, String roleId, RedirectAttributes redirectAttributes) {
        Role role = this.systemService.getRole(roleId);
        SysUser user = this.systemService.getUser(userId);
        if (UserUtils.getSysUser().getId().equals(userId)) {
            this.addMessage(redirectAttributes, "\u65e0\u6cd5\u4ece\u89d2\u8272\u3010" + role.getName() + "\u3011\u4e2d\u79fb\u9664\u7528\u6237\u3010" + user.getName() + "\u3011\u81ea\u5df1\uff01");
        } else if (user.getRoleList().size() <= 1) {
            this.addMessage(redirectAttributes, "\u7528\u6237\u3010" + user.getName() + "\u3011\u4ece\u89d2\u8272\u3010" + role.getName() + "\u3011\u4e2d\u79fb\u9664\u5931\u8d25\uff01\u8fd9\u5df2\u7ecf\u662f\u8be5\u7528\u6237\u7684\u552f\u4e00\u89d2\u8272\uff0c\u4e0d\u80fd\u79fb\u9664\u3002");
        } else {
            Boolean flag = this.systemService.outUserInRole(role, user);
            if (!flag.booleanValue()) {
                this.addMessage(redirectAttributes, "\u7528\u6237\u3010" + user.getName() + "\u3011\u4ece\u89d2\u8272\u3010" + role.getName() + "\u3011\u4e2d\u79fb\u9664\u5931\u8d25\uff01");
            } else {
                this.addMessage(redirectAttributes, "\u7528\u6237\u3010" + user.getName() + "\u3011\u4ece\u89d2\u8272\u3010" + role.getName() + "\u3011\u4e2d\u79fb\u9664\u6210\u529f\uff01");
            }
        }
        return "redirect:" + this.adminPath + "/sys/role/assign?id=" + role.getId();
    }

    @RequiresPermissions(value={"sys:role:assign"})
    @RequestMapping(value={"assignrole"})
    public String assignRole(Role role, String[] idsArr, RedirectAttributes redirectAttributes) {
        StringBuilder msg = new StringBuilder();
        int newNum = 0;
        for (int i = 0; i < idsArr.length; ++i) {
            SysUser user = this.systemService.assignUserToRole(role, this.systemService.getUser(idsArr[i]));
            if (null == user) continue;
            msg.append("<br/>\u65b0\u589e\u7528\u6237\u3010" + user.getName() + "\u3011\u5230\u89d2\u8272\u3010" + role.getName() + "\u3011\uff01");
            ++newNum;
        }
        this.addMessage(redirectAttributes, "\u5df2\u6210\u529f\u5206\u914d " + newNum + " \u4e2a\u7528\u6237" + msg);
        return "redirect:" + this.adminPath + "/sys/role/assign?id=" + role.getId();
    }

    @RequiresPermissions(value={"user"})
    @ResponseBody
    @RequestMapping(value={"checkName"})
    public String checkName(String oldName, String name) {
        if (name != null && name.equals(oldName)) {
            return "true";
        }
        if (name != null && this.systemService.getRoleByName(name) == null) {
            return "true";
        }
        return "false";
    }

    @RequiresPermissions(value={"user"})
    @ResponseBody
    @RequestMapping(value={"checkEnname"})
    public String checkEnname(String oldEnname, String enname) {
        if (enname != null && enname.equals(oldEnname)) {
            return "true";
        }
        if (enname != null && this.systemService.getRoleByEnname(enname) == null) {
            return "true";
        }
        return "false";
    }
}

