/*
 * Decompiled with CFR 0.152.
 */
package com.youtu;

import com.youtu.common.YoutuConstant;
import com.youtu.sign.Base64Util;
import com.youtu.sign.YoutuSign;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Youtu {
    public static final String API_YOUTU_END_POINT = "https://api.youtu.qq.com/youtu/";
    public static final String API_YOUTU_CHARGE_END_POINT = "https://vip-api.youtu.qq.com/youtu/";
    private static int EXPIRED_SECONDS = 2592000;
    private String m_appid;
    private String m_secret_id;
    private String m_secret_key;
    private String m_end_point;
    private String m_user_id;
    private boolean m_not_use_https;

    public Youtu() {
        this.m_appid = YoutuConstant.APP_ID;
        this.m_secret_id = YoutuConstant.SECRET_ID;
        this.m_secret_key = YoutuConstant.SECRET_KEY;
        this.m_end_point = API_YOUTU_END_POINT;
        this.m_user_id = YoutuConstant.USER_ID;
        this.m_not_use_https = !API_YOUTU_END_POINT.startsWith("https");
    }

    public Youtu(String appid, String secret_id, String secret_key, String end_point, String user_id) {
        this.m_appid = appid;
        this.m_secret_id = secret_id;
        this.m_secret_key = secret_key;
        this.m_end_point = end_point;
        this.m_user_id = user_id;
        this.m_not_use_https = !end_point.startsWith("https");
    }

    public String StatusText(int status) {
        String statusText = "UNKOWN";
        switch (status) {
            case 0: {
                statusText = "CONNECT_FAIL";
                break;
            }
            case 200: {
                statusText = "HTTP OK";
                break;
            }
            case 400: {
                statusText = "BAD_REQUEST";
                break;
            }
            case 401: {
                statusText = "UNAUTHORIZED";
                break;
            }
            case 403: {
                statusText = "FORBIDDEN";
                break;
            }
            case 404: {
                statusText = "NOTFOUND";
                break;
            }
            case 411: {
                statusText = "REQ_NOLENGTH";
                break;
            }
            case 423: {
                statusText = "SERVER_NOTFOUND";
                break;
            }
            case 424: {
                statusText = "METHOD_NOTFOUND";
                break;
            }
            case 425: {
                statusText = "REQUEST_OVERFLOW";
                break;
            }
            case 500: {
                statusText = "INTERNAL_SERVER_ERROR";
                break;
            }
            case 503: {
                statusText = "SERVICE_UNAVAILABLE";
                break;
            }
            case 504: {
                statusText = "GATEWAY_TIME_OUT";
            }
        }
        return statusText;
    }

    private void GetBase64FromFile(String filePath, StringBuffer base64) throws IOException {
        File imageFile = new File(filePath);
        if (!imageFile.exists()) {
            throw new FileNotFoundException(String.valueOf(filePath) + " not exist");
        }
        FileInputStream in = new FileInputStream(imageFile);
        byte[] data = new byte[(int)imageFile.length()];
        ((InputStream)in).read(data);
        ((InputStream)in).close();
        base64.append(Base64Util.encode(data));
    }

    private JSONObject SendHttpRequest(JSONObject postData, String mothod) throws IOException, JSONException, KeyManagementException, NoSuchAlgorithmException {
        String lines;
        StringBuffer mySign = new StringBuffer("");
        YoutuSign.appSign(this.m_appid, this.m_secret_id, this.m_secret_key, System.currentTimeMillis() / 1000L + (long)EXPIRED_SECONDS, this.m_user_id, mySign);
        System.setProperty("sun.net.client.defaultConnectTimeout", "30000");
        System.setProperty("sun.net.client.defaultReadTimeout", "30000");
        URL url = new URL(String.valueOf(this.m_end_point) + mothod);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("accept", "*/*");
        connection.setRequestProperty("user-agent", "youtu-java-sdk");
        connection.setRequestProperty("Authorization", mySign.toString());
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setUseCaches(false);
        connection.setInstanceFollowRedirects(true);
        connection.setRequestProperty("Content-Type", "text/json");
        connection.connect();
        DataOutputStream out = new DataOutputStream(connection.getOutputStream());
        postData.put("app_id", (Object)this.m_appid);
        out.write(postData.toString().getBytes("utf-8"));
        out.flush();
        out.close();
        BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        StringBuffer resposeBuffer = new StringBuffer("");
        while ((lines = reader.readLine()) != null) {
            lines = new String(lines.getBytes(), "utf-8");
            resposeBuffer.append(lines);
        }
        reader.close();
        connection.disconnect();
        JSONObject respose = new JSONObject(resposeBuffer.toString());
        return respose;
    }

    private JSONObject SendHttpsRequest(JSONObject postData, String mothod) throws NoSuchAlgorithmException, KeyManagementException, IOException, JSONException {
        String lines;
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, new TrustManager[]{new TrustAnyTrustManager()}, new SecureRandom());
        StringBuffer mySign = new StringBuffer("");
        YoutuSign.appSign(this.m_appid, this.m_secret_id, this.m_secret_key, System.currentTimeMillis() / 1000L + (long)EXPIRED_SECONDS, this.m_user_id, mySign);
        System.setProperty("sun.net.client.defaultConnectTimeout", "30000");
        System.setProperty("sun.net.client.defaultReadTimeout", "30000");
        URL url = new URL(String.valueOf(this.m_end_point) + mothod);
        HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
        connection.setSSLSocketFactory(sc.getSocketFactory());
        connection.setHostnameVerifier(new TrustAnyHostnameVerifier());
        connection.setRequestMethod("POST");
        connection.setRequestProperty("accept", "*/*");
        connection.setRequestProperty("user-agent", "youtu-java-sdk");
        connection.setRequestProperty("Authorization", mySign.toString());
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setUseCaches(false);
        connection.setInstanceFollowRedirects(true);
        connection.setRequestProperty("Content-Type", "text/json");
        connection.connect();
        DataOutputStream out = new DataOutputStream(connection.getOutputStream());
        postData.put("app_id", (Object)this.m_appid);
        out.write(postData.toString().getBytes("utf-8"));
        out.flush();
        out.close();
        BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        StringBuffer resposeBuffer = new StringBuffer("");
        while ((lines = reader.readLine()) != null) {
            lines = new String(lines.getBytes(), "utf-8");
            resposeBuffer.append(lines);
        }
        reader.close();
        connection.disconnect();
        JSONObject respose = new JSONObject(resposeBuffer.toString());
        return respose;
    }

    public JSONObject DetectFace(String image_path, int mode) throws IOException, JSONException, KeyManagementException, NoSuchAlgorithmException {
        StringBuffer image_data = new StringBuffer("");
        JSONObject data = new JSONObject();
        this.GetBase64FromFile(image_path, image_data);
        data.put("image", (Object)image_data.toString());
        data.put("mode", mode);
        JSONObject respose = this.m_not_use_https ? this.SendHttpRequest(data, "api/detectface") : this.SendHttpsRequest(data, "api/detectface");
        return respose;
    }

    public JSONObject DetectFaceUrl(String url, int mode) throws IOException, JSONException, KeyManagementException, NoSuchAlgorithmException {
        JSONObject data = new JSONObject();
        data.put("url", (Object)url);
        data.put("mode", mode);
        JSONObject respose = this.m_not_use_https ? this.SendHttpRequest(data, "api/detectface") : this.SendHttpsRequest(data, "api/detectface");
        return respose;
    }

    public JSONObject FaceShape(String image_path, int mode) throws IOException, JSONException, KeyManagementException, NoSuchAlgorithmException {
        StringBuffer image_data = new StringBuffer("");
        JSONObject data = new JSONObject();
        this.GetBase64FromFile(image_path, image_data);
        data.put("image", (Object)image_data.toString());
        data.put("mode", mode);
        JSONObject respose = this.m_not_use_https ? this.SendHttpRequest(data, "api/faceshape") : this.SendHttpsRequest(data, "api/faceshape");
        return respose;
    }

    public JSONObject FaceShapeUrl(String url, int mode) throws IOException, JSONException, KeyManagementException, NoSuchAlgorithmException {
        JSONObject data = new JSONObject();
        data.put("url", (Object)url);
        data.put("mode", mode);
        JSONObject respose = this.m_not_use_https ? this.SendHttpRequest(data, "api/faceshape") : this.SendHttpsRequest(data, "api/faceshape");
        return respose;
    }

    public JSONObject FaceCompare(String image_path_a, String image_path_b) throws IOException, JSONException, KeyManagementException, NoSuchAlgorithmException {
        StringBuffer image_data = new StringBuffer("");
        JSONObject data = new JSONObject();
        this.GetBase64FromFile(image_path_a, image_data);
        data.put("imageA", (Object)image_data.toString());
        image_data.setLength(0);
        this.GetBase64FromFile(image_path_b, image_data);
        data.put("imageB", (Object)image_data.toString());
        JSONObject respose = this.m_not_use_https ? this.SendHttpRequest(data, "api/facecompare") : this.SendHttpsRequest(data, "api/facecompare");
        return respose;
    }

    public JSONObject FaceCompareUrl(String urlA, String urlB) throws IOException, JSONException, KeyManagementException, NoSuchAlgorithmException {
        JSONObject data = new JSONObject();
        data.put("urlA", (Object)urlA);
        data.put("urlB", (Object)urlB);
        JSONObject respose = this.m_not_use_https ? this.SendHttpRequest(data, "api/facecompare") : this.SendHttpsRequest(data, "api/facecompare");
        return respose;
    }

    public JSONObject FaceVerify(String image_path, String person_id) throws IOException, JSONException, KeyManagementException, NoSuchAlgorithmException {
        StringBuffer image_data = new StringBuffer("");
        JSONObject data = new JSONObject();
        this.GetBase64FromFile(image_path, image_data);
        data.put("image", (Object)image_data.toString());
        image_data.setLength(0);
        data.put("person_id", (Object)person_id);
        JSONObject respose = this.m_not_use_https ? this.SendHttpRequest(data, "api/faceverify") : this.SendHttpsRequest(data, "api/faceverify");
        return respose;
    }

    public JSONObject FaceVerifyUrl(String url, String person_id) throws IOException, JSONException, KeyManagementException, NoSuchAlgorithmException {
        JSONObject data = new JSONObject();
        data.put("url", (Object)url);
        data.put("person_id", (Object)person_id);
        JSONObject respose = this.m_not_use_https ? this.SendHttpRequest(data, "api/faceverify") : this.SendHttpsRequest(data, "api/faceverify");
        return respose;
    }

    public JSONObject FaceIdentify(String image_path, String group_id) throws IOException, JSONException, KeyManagementException, NoSuchAlgorithmException {
        StringBuffer image_data = new StringBuffer("");
        JSONObject data = new JSONObject();
        this.GetBase64FromFile(image_path, image_data);
        data.put("image", (Object)image_data.toString());
        image_data.setLength(0);
        data.put("group_id", (Object)group_id);
        JSONObject respose = this.m_not_use_https ? this.SendHttpRequest(data, "api/faceidentify") : this.SendHttpsRequest(data, "api/faceidentify");
        return respose;
    }

    public JSONObject FaceIdentifyUrl(String url, String group_id) throws IOException, JSONException, KeyManagementException, NoSuchAlgorithmException {
        JSONObject data = new JSONObject();
        data.put("url", (Object)url);
        data.put("group_id", (Object)group_id);
        JSONObject respose = this.m_not_use_https ? this.SendHttpRequest(data, "api/faceidentify") : this.SendHttpsRequest(data, "api/faceidentify");
        return respose;
    }

    public JSONObject MultiFaceIdentify(String image_path, String group_id, List<String> group_ids) throws IOException, JSONException, KeyManagementException, NoSuchAlgorithmException {
        StringBuffer image_data = new StringBuffer("");
        JSONObject data = new JSONObject();
        this.GetBase64FromFile(image_path, image_data);
        data.put("image", (Object)image_data.toString());
        image_data.setLength(0);
        if (!group_id.isEmpty()) {
            data.put("group_id", (Object)group_id);
        } else {
            data.put("group_ids", group_ids);
        }
        JSONObject respose = this.m_not_use_https ? this.SendHttpRequest(data, "api/multifaceidentify") : this.SendHttpsRequest(data, "api/multifaceidentify");
        return respose;
    }

    public JSONObject MultiFaceIdentifyUrl(String url, String group_id, List<String> group_ids) throws IOException, JSONException, KeyManagementException, NoSuchAlgorithmException {
        JSONObject data = new JSONObject();
        data.put("url", (Object)url);
        if (!group_id.isEmpty()) {
            data.put("group_id", (Object)group_id);
        } else {
            data.put("group_ids", group_ids);
        }
        JSONObject respose = this.m_not_use_https ? this.SendHttpRequest(data, "api/multifaceidentify") : this.SendHttpsRequest(data, "api/multifaceidentify");
        return respose;
    }

    public JSONObject MultiFaceIdentify(String image_path, String group_id, List<String> group_ids, int topn, int min_size) throws IOException, JSONException, KeyManagementException, NoSuchAlgorithmException {
        StringBuffer image_data = new StringBuffer("");
        JSONObject data = new JSONObject();
        this.GetBase64FromFile(image_path, image_data);
        data.put("image", (Object)image_data.toString());
        image_data.setLength(0);
        if (!group_id.isEmpty()) {
            data.put("group_id", (Object)group_id);
        } else {
            data.put("group_ids", group_ids);
        }
        data.put("topn", topn);
        data.put("min_size", min_size);
        JSONObject respose = this.m_not_use_https ? this.SendHttpRequest(data, "api/multifaceidentify") : this.SendHttpsRequest(data, "api/multifaceidentify");
        return respose;
    }

    public JSONObject MultiFaceIdentifyUrl(String url, String group_id, List<String> group_ids, int topn, int min_size) throws IOException, JSONException, KeyManagementException, NoSuchAlgorithmException {
        JSONObject data = new JSONObject();
        data.put("url", (Object)url);
        if (!group_id.isEmpty()) {
            data.put("group_id", (Object)group_id);
        } else {
            data.put("group_ids", group_ids);
        }
        data.put("topn", topn);
        data.put("min_size", min_size);
        JSONObject respose = this.m_not_use_https ? this.SendHttpRequest(data, "api/multifaceidentify") : this.SendHttpsRequest(data, "api/multifaceidentify");
        return respose;
    }

    public JSONObject NewPerson(String image_path, String person_id, List<String> group_ids) throws IOException, JSONException, KeyManagementException, NoSuchAlgorithmException {
        StringBuffer image_data = new StringBuffer("");
        JSONObject data = new JSONObject();
        this.GetBase64FromFile(image_path, image_data);
        data.put("image", (Object)image_data.toString());
        image_data.setLength(0);
        data.put("person_id", (Object)person_id);
        data.put("group_ids", group_ids);
        JSONObject respose = this.m_not_use_https ? this.SendHttpRequest(data, "api/newperson") : this.SendHttpsRequest(data, "api/newperson");
        return respose;
    }

    public JSONObject NewPersonUrl(String url, String person_id, List<String> group_ids) throws IOException, JSONException, KeyManagementException, NoSuchAlgorithmException {
        JSONObject data = new JSONObject();
        data.put("url", (Object)url);
        data.put("person_id", (Object)person_id);
        data.put("group_ids", group_ids);
        JSONObject respose = this.m_not_use_https ? this.SendHttpRequest(data, "api/newperson") : this.SendHttpsRequest(data, "api/newperson");
        return respose;
    }

    public JSONObject DelPerson(String person_id) throws IOException, JSONException, KeyManagementException, NoSuchAlgorithmException {
        JSONObject data = new JSONObject();
        data.put("person_id", (Object)person_id);
        JSONObject respose = this.m_not_use_https ? this.SendHttpRequest(data, "api/delperson") : this.SendHttpsRequest(data, "api/delperson");
        return respose;
    }

    public JSONObject AddFace(String person_id, List<String> image_path_arr) throws IOException, JSONException, KeyManagementException, NoSuchAlgorithmException {
        StringBuffer image_data = new StringBuffer("");
        JSONObject data = new JSONObject();
        ArrayList<String> images = new ArrayList<String>();
        for (String image_path : image_path_arr) {
            image_data.setLength(0);
            this.GetBase64FromFile(image_path, image_data);
            images.add(image_data.toString());
        }
        data.put("images", images);
        image_data.setLength(0);
        data.put("person_id", (Object)person_id);
        JSONObject respose = this.m_not_use_https ? this.SendHttpRequest(data, "api/addface") : this.SendHttpsRequest(data, "api/addface");
        return respose;
    }

    public JSONObject AddFaceUrl(String person_id, List<String> url_arr) throws IOException, JSONException, KeyManagementException, NoSuchAlgorithmException {
        JSONObject data = new JSONObject();
        data.put("urls", url_arr);
        data.put("person_id", (Object)person_id);
        JSONObject respose = this.m_not_use_https ? this.SendHttpRequest(data, "api/addface") : this.SendHttpsRequest(data, "api/addface");
        return respose;
    }

    public JSONObject DelFace(String person_id, List<String> face_id_arr) throws IOException, JSONException, KeyManagementException, NoSuchAlgorithmException {
        JSONObject data = new JSONObject();
        data.put("face_ids", face_id_arr);
        data.put("person_id", (Object)person_id);
        JSONObject respose = this.m_not_use_https ? this.SendHttpRequest(data, "api/delface") : this.SendHttpsRequest(data, "api/delface");
        return respose;
    }

    public JSONObject SetInfo(String person_name, String person_id) throws IOException, JSONException, KeyManagementException, NoSuchAlgorithmException {
        JSONObject data = new JSONObject();
        data.put("person_name", (Object)person_name);
        data.put("person_id", (Object)person_id);
        JSONObject respose = this.m_not_use_https ? this.SendHttpRequest(data, "api/setinfo") : this.SendHttpsRequest(data, "api/setinfo");
        return respose;
    }

    public JSONObject GetInfo(String person_id) throws IOException, JSONException, KeyManagementException, NoSuchAlgorithmException {
        JSONObject data = new JSONObject();
        data.put("person_id", (Object)person_id);
        JSONObject respose = this.m_not_use_https ? this.SendHttpRequest(data, "api/getinfo") : this.SendHttpsRequest(data, "api/getinfo");
        return respose;
    }

    public JSONObject GetGroupIds() throws IOException, JSONException, KeyManagementException, NoSuchAlgorithmException {
        JSONObject data = new JSONObject();
        JSONObject respose = this.m_not_use_https ? this.SendHttpRequest(data, "api/getgroupids") : this.SendHttpsRequest(data, "api/getgroupids");
        return respose;
    }

    public JSONObject GetPersonIds(String group_id) throws IOException, JSONException, KeyManagementException, NoSuchAlgorithmException {
        JSONObject data = new JSONObject();
        data.put("group_id", (Object)group_id);
        JSONObject respose = this.m_not_use_https ? this.SendHttpRequest(data, "api/getpersonids") : this.SendHttpsRequest(data, "api/getpersonids");
        return respose;
    }

    public JSONObject GetFaceIds(String person_id) throws IOException, JSONException, KeyManagementException, NoSuchAlgorithmException {
        JSONObject data = new JSONObject();
        data.put("person_id", (Object)person_id);
        JSONObject respose = this.m_not_use_https ? this.SendHttpRequest(data, "api/getfaceids") : this.SendHttpsRequest(data, "api/getfaceids");
        return respose;
    }

    public JSONObject GetFaceInfo(String face_id) throws IOException, JSONException, KeyManagementException, NoSuchAlgorithmException {
        JSONObject data = new JSONObject();
        data.put("face_id", (Object)face_id);
        JSONObject respose = this.m_not_use_https ? this.SendHttpRequest(data, "api/getfaceinfo") : this.SendHttpsRequest(data, "api/getfaceinfo");
        return respose;
    }

    public JSONObject FuzzyDetect(String image_path) throws IOException, JSONException, KeyManagementException, NoSuchAlgorithmException {
        StringBuffer image_data = new StringBuffer("");
        JSONObject data = new JSONObject();
        this.GetBase64FromFile(image_path, image_data);
        data.put("image", (Object)image_data.toString());
        JSONObject respose = this.m_not_use_https ? this.SendHttpRequest(data, "imageapi/fuzzydetect") : this.SendHttpsRequest(data, "imageapi/fuzzydetect");
        return respose;
    }

    public JSONObject FuzzyDetectUrl(String url) throws IOException, JSONException, KeyManagementException, NoSuchAlgorithmException {
        JSONObject data = new JSONObject();
        data.put("url", (Object)url);
        JSONObject respose = this.m_not_use_https ? this.SendHttpRequest(data, "imageapi/fuzzydetect") : this.SendHttpsRequest(data, "imageapi/fuzzydetect");
        return respose;
    }

    public JSONObject FoodDetect(String image_path) throws IOException, JSONException, KeyManagementException, NoSuchAlgorithmException {
        StringBuffer image_data = new StringBuffer("");
        JSONObject data = new JSONObject();
        this.GetBase64FromFile(image_path, image_data);
        data.put("image", (Object)image_data.toString());
        JSONObject respose = this.m_not_use_https ? this.SendHttpRequest(data, "imageapi/fooddetect") : this.SendHttpsRequest(data, "imageapi/fooddetect");
        return respose;
    }

    public JSONObject FoodDetectUrl(String url) throws IOException, JSONException, KeyManagementException, NoSuchAlgorithmException {
        JSONObject data = new JSONObject();
        data.put("url", (Object)url);
        JSONObject respose = this.m_not_use_https ? this.SendHttpRequest(data, "imageapi/fooddetect") : this.SendHttpsRequest(data, "imageapi/fooddetect");
        return respose;
    }

    public JSONObject ImageTag(String image_path) throws IOException, JSONException, KeyManagementException, NoSuchAlgorithmException {
        StringBuffer image_data = new StringBuffer("");
        JSONObject data = new JSONObject();
        this.GetBase64FromFile(image_path, image_data);
        data.put("image", (Object)image_data.toString());
        JSONObject respose = this.m_not_use_https ? this.SendHttpRequest(data, "imageapi/imagetag") : this.SendHttpsRequest(data, "imageapi/imagetag");
        return respose;
    }

    public JSONObject ImageTagUrl(String url) throws IOException, JSONException, KeyManagementException, NoSuchAlgorithmException {
        JSONObject data = new JSONObject();
        data.put("url", (Object)url);
        JSONObject respose = this.m_not_use_https ? this.SendHttpRequest(data, "imageapi/imagetag") : this.SendHttpsRequest(data, "imageapi/imagetag");
        return respose;
    }

    public JSONObject ImagePorn(String image_path) throws IOException, JSONException, KeyManagementException, NoSuchAlgorithmException {
        StringBuffer image_data = new StringBuffer("");
        JSONObject data = new JSONObject();
        this.GetBase64FromFile(image_path, image_data);
        data.put("image", (Object)image_data.toString());
        JSONObject respose = this.m_not_use_https ? this.SendHttpRequest(data, "imageapi/imageporn") : this.SendHttpsRequest(data, "imageapi/imageporn");
        return respose;
    }

    public JSONObject ImagePornUrl(String url) throws IOException, JSONException, KeyManagementException, NoSuchAlgorithmException {
        JSONObject data = new JSONObject();
        data.put("url", (Object)url);
        JSONObject respose = this.m_not_use_https ? this.SendHttpRequest(data, "imageapi/imageporn") : this.SendHttpsRequest(data, "imageapi/imageporn");
        return respose;
    }

    public JSONObject ImageTerrorism(String image_path) throws IOException, JSONException, KeyManagementException, NoSuchAlgorithmException {
        StringBuffer image_data = new StringBuffer("");
        JSONObject data = new JSONObject();
        this.GetBase64FromFile(image_path, image_data);
        data.put("image", (Object)image_data.toString());
        JSONObject respose = this.m_not_use_https ? this.SendHttpRequest(data, "imageapi/imageterrorism") : this.SendHttpsRequest(data, "imageapi/imageterrorism");
        return respose;
    }

    public JSONObject ImageTerrorismUrl(String url) throws IOException, JSONException, KeyManagementException, NoSuchAlgorithmException {
        JSONObject data = new JSONObject();
        data.put("url", (Object)url);
        JSONObject respose = this.m_not_use_https ? this.SendHttpRequest(data, "imageapi/imageterrorism") : this.SendHttpsRequest(data, "imageapi/imageterrorism");
        return respose;
    }

    public JSONObject CarClassify(String image_path) throws IOException, JSONException, KeyManagementException, NoSuchAlgorithmException {
        StringBuffer image_data = new StringBuffer("");
        JSONObject data = new JSONObject();
        this.GetBase64FromFile(image_path, image_data);
        data.put("image", (Object)image_data.toString());
        JSONObject respose = this.m_not_use_https ? this.SendHttpRequest(data, "carapi/carclassify") : this.SendHttpsRequest(data, "carapi/carclassify");
        return respose;
    }

    public JSONObject CarClassifyUrl(String url) throws IOException, JSONException, KeyManagementException, NoSuchAlgorithmException {
        JSONObject data = new JSONObject();
        data.put("url", (Object)url);
        JSONObject respose = this.m_not_use_https ? this.SendHttpRequest(data, "carapi/carclassify") : this.SendHttpsRequest(data, "carapi/carclassify");
        return respose;
    }

    public JSONObject IdCardOcr(String image_path, int card_type) throws IOException, JSONException, KeyManagementException, NoSuchAlgorithmException {
        StringBuffer image_data = new StringBuffer("");
        JSONObject data = new JSONObject();
        this.GetBase64FromFile(image_path, image_data);
        data.put("image", (Object)image_data.toString());
        data.put("card_type", card_type);
        JSONObject respose = this.m_not_use_https ? this.SendHttpRequest(data, "ocrapi/idcardocr") : this.SendHttpsRequest(data, "ocrapi/idcardocr");
        return respose;
    }

    public JSONObject IdCardOcrUrl(String url, int card_type) throws IOException, JSONException, KeyManagementException, NoSuchAlgorithmException {
        JSONObject data = new JSONObject();
        data.put("url", (Object)url);
        data.put("card_type", card_type);
        JSONObject respose = this.m_not_use_https ? this.SendHttpRequest(data, "ocrapi/idcardocr") : this.SendHttpsRequest(data, "ocrapi/idcardocr");
        return respose;
    }

    public JSONObject LiveGetFour() throws IOException, JSONException, KeyManagementException, NoSuchAlgorithmException {
        JSONObject data = new JSONObject();
        JSONObject respose = this.m_not_use_https ? this.SendHttpRequest(data, "openliveapi/livegetfour") : this.SendHttpsRequest(data, "openliveapi/livegetfour");
        return respose;
    }

    public JSONObject LiveDetectFour(String validate_data, String video_path, String card_path, boolean compare_card) throws IOException, JSONException, KeyManagementException, NoSuchAlgorithmException {
        JSONObject data = new JSONObject();
        data.put("validate_data", (Object)validate_data);
        StringBuffer video_data = new StringBuffer("");
        this.GetBase64FromFile(video_path, video_data);
        data.put("video", (Object)video_data.toString());
        if (compare_card) {
            StringBuffer card_data = new StringBuffer("");
            this.GetBase64FromFile(card_path, card_data);
            data.put("card", (Object)card_data.toString());
            data.put("compare_flag", true);
        } else {
            data.put("compare_flag", false);
        }
        JSONObject respose = this.m_not_use_https ? this.SendHttpRequest(data, "openliveapi/livedetectfour") : this.SendHttpsRequest(data, "openliveapi/livedetectfour");
        return respose;
    }

    public JSONObject IdcardLiveDetectfour(String idcard_number, String idcard_name, String validate_data, String video_path) throws IOException, JSONException, KeyManagementException, NoSuchAlgorithmException {
        JSONObject data = new JSONObject();
        data.put("idcard_number", (Object)idcard_number);
        data.put("idcard_name", (Object)idcard_name);
        data.put("validate_data", (Object)validate_data);
        StringBuffer video_data = new StringBuffer("");
        this.GetBase64FromFile(video_path, video_data);
        data.put("video", (Object)video_data.toString());
        JSONObject respose = this.m_not_use_https ? this.SendHttpRequest(data, "openliveapi/idcardlivedetectfour") : this.SendHttpsRequest(data, "openliveapi/idcardlivedetectfour");
        return respose;
    }

    public JSONObject IdcardFaceCompare(String idcard_number, String idcard_name, String image_path) throws IOException, JSONException, KeyManagementException, NoSuchAlgorithmException {
        JSONObject data = new JSONObject();
        data.put("idcard_number", (Object)idcard_number);
        data.put("idcard_name", (Object)idcard_name);
        StringBuffer image_data = new StringBuffer("");
        this.GetBase64FromFile(image_path, image_data);
        data.put("image", (Object)image_data.toString());
        JSONObject respose = this.m_not_use_https ? this.SendHttpRequest(data, "openliveapi/idcardfacecompare") : this.SendHttpsRequest(data, "openliveapi/idcardfacecompare");
        return respose;
    }

    public JSONObject ValidateIdcard(String idcard_number, String idcard_name) throws IOException, JSONException, KeyManagementException, NoSuchAlgorithmException {
        JSONObject data = new JSONObject();
        data.put("idcard_number", (Object)idcard_number);
        data.put("idcard_name", (Object)idcard_name);
        JSONObject respose = this.m_not_use_https ? this.SendHttpRequest(data, "openliveapi/validateidcard ") : this.SendHttpsRequest(data, "openliveapi/validateidcard ");
        return respose;
    }

    public JSONObject GeneralOcr(String image_path) throws IOException, JSONException, KeyManagementException, NoSuchAlgorithmException {
        JSONObject data = new JSONObject();
        StringBuffer image_data = new StringBuffer("");
        this.GetBase64FromFile(image_path, image_data);
        data.put("image", (Object)image_data);
        JSONObject response = this.m_not_use_https ? this.SendHttpRequest(data, "ocrapi/generalocr") : this.SendHttpsRequest(data, "ocrapi/generalocr");
        return response;
    }

    public JSONObject GeneralOcrUrl(String image_url) throws IOException, JSONException, KeyManagementException, NoSuchAlgorithmException {
        JSONObject data = new JSONObject();
        data.put("url", (Object)image_url);
        JSONObject response = this.m_not_use_https ? this.SendHttpRequest(data, "ocrapi/generalocr") : this.SendHttpsRequest(data, "ocrapi/generalocr");
        return response;
    }

    public JSONObject BcOcr(String image_path) throws IOException, JSONException, KeyManagementException, NoSuchAlgorithmException {
        JSONObject data = new JSONObject();
        StringBuffer image_data = new StringBuffer("");
        this.GetBase64FromFile(image_path, image_data);
        data.put("image", (Object)image_data);
        JSONObject response = this.m_not_use_https ? this.SendHttpRequest(data, "ocrapi/bcocr") : this.SendHttpsRequest(data, "ocrapi/bcocr");
        return response;
    }

    public JSONObject BcOcrUrl(String image_url) throws IOException, JSONException, KeyManagementException, NoSuchAlgorithmException {
        JSONObject data = new JSONObject();
        data.put("url", (Object)image_url);
        JSONObject response = this.m_not_use_https ? this.SendHttpRequest(data, "ocrapi/bcocr") : this.SendHttpsRequest(data, "ocrapi/bcocr");
        return response;
    }

    public JSONObject DriverLicenseOcr(String image_path, int card_type) throws IOException, JSONException, KeyManagementException, NoSuchAlgorithmException {
        JSONObject data = new JSONObject();
        StringBuffer image_data = new StringBuffer("");
        this.GetBase64FromFile(image_path, image_data);
        data.put("image", (Object)image_data);
        data.put("type", card_type);
        JSONObject response = this.m_not_use_https ? this.SendHttpRequest(data, "ocrapi/driverlicenseocr") : this.SendHttpsRequest(data, "ocrapi/driverlicenseocr");
        return response;
    }

    public JSONObject DriverLicenseOcrUrl(String image_url, int card_type) throws IOException, JSONException, KeyManagementException, NoSuchAlgorithmException {
        JSONObject data = new JSONObject();
        data.put("url", (Object)image_url);
        data.put("type", card_type);
        JSONObject response = this.m_not_use_https ? this.SendHttpRequest(data, "ocrapi/driverlicenseocr") : this.SendHttpsRequest(data, "ocrapi/driverlicenseocr");
        return response;
    }

    public JSONObject CreditCardOcr(String image_path) throws IOException, JSONException, KeyManagementException, NoSuchAlgorithmException {
        JSONObject data = new JSONObject();
        StringBuffer image_data = new StringBuffer("");
        this.GetBase64FromFile(image_path, image_data);
        data.put("image", (Object)image_data);
        JSONObject response = this.m_not_use_https ? this.SendHttpRequest(data, "ocrapi/creditcardocr") : this.SendHttpsRequest(data, "ocrapi/creditcardocr");
        return response;
    }

    public JSONObject CreditCardOcrUrl(String image_url) throws IOException, JSONException, KeyManagementException, NoSuchAlgorithmException {
        JSONObject data = new JSONObject();
        data.put("url", (Object)image_url);
        JSONObject response = this.m_not_use_https ? this.SendHttpRequest(data, "ocrapi/creditcardocr") : this.SendHttpsRequest(data, "ocrapi/creditcardocr");
        return response;
    }

    public JSONObject BizLicenseOcr(String image_path) throws IOException, JSONException, KeyManagementException, NoSuchAlgorithmException {
        JSONObject data = new JSONObject();
        StringBuffer image_data = new StringBuffer("");
        this.GetBase64FromFile(image_path, image_data);
        data.put("image", (Object)image_data);
        JSONObject response = this.m_not_use_https ? this.SendHttpRequest(data, "ocrapi/bizlicenseocr") : this.SendHttpsRequest(data, "ocrapi/bizlicenseocr");
        return response;
    }

    public JSONObject BizLicenseOcrUrl(String image_url) throws IOException, JSONException, KeyManagementException, NoSuchAlgorithmException {
        JSONObject data = new JSONObject();
        data.put("url", (Object)image_url);
        JSONObject response = this.m_not_use_https ? this.SendHttpRequest(data, "ocrapi/bizlicenseocr") : this.SendHttpsRequest(data, "ocrapi/bizlicenseocr");
        return response;
    }

    public JSONObject PlateOcr(String image_path) throws IOException, JSONException, KeyManagementException, NoSuchAlgorithmException {
        JSONObject data = new JSONObject();
        StringBuffer image_data = new StringBuffer("");
        this.GetBase64FromFile(image_path, image_data);
        data.put("image", (Object)image_data);
        JSONObject response = this.m_not_use_https ? this.SendHttpRequest(data, "ocrapi/plateocr") : this.SendHttpsRequest(data, "ocrapi/plateocr");
        return response;
    }

    public JSONObject PlateOcrUrl(String image_url) throws IOException, JSONException, KeyManagementException, NoSuchAlgorithmException {
        JSONObject data = new JSONObject();
        data.put("url", (Object)image_url);
        JSONObject response = this.m_not_use_https ? this.SendHttpRequest(data, "ocrapi/plateocr") : this.SendHttpsRequest(data, "ocrapi/plateocr");
        return response;
    }

    private static class TrustAnyHostnameVerifier
    implements HostnameVerifier {
        private TrustAnyHostnameVerifier() {
        }

        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }

    private static class TrustAnyTrustManager
    implements X509TrustManager {
        private TrustAnyTrustManager() {
        }

        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

