/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.DadaApiResponse;
import config.AppConfig;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import service.BaseService;
import utils.HttpClientUtil;
import utils.JSONUtil;

public class DadaRequestClient {
    private BaseService apiService;
    private AppConfig appConfig;

    public DadaRequestClient(BaseService baseService, AppConfig appConfig) {
        this.apiService = baseService;
        this.appConfig = appConfig;
    }

    public DadaApiResponse callRpc() {
        String requestUrl = this.appConfig.getHost().concat(this.apiService.getUrl());
        String requestParams = this.getRequestParams();
        try {
            String resp = HttpClientUtil.postRequest(requestUrl, requestParams);
            return JSONUtil.fromJson(resp, DadaApiResponse.class);
        }
        catch (Exception e) {
            return DadaApiResponse.except();
        }
    }

    private String getRequestParams() {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put("source_id", this.appConfig.getSourceId());
        requestParams.put("app_key", this.appConfig.getAppKey());
        requestParams.put("timestamp", String.valueOf(System.currentTimeMillis()));
        requestParams.put("format", "json");
        requestParams.put("v", "1.0");
        requestParams.put("body", this.apiService.getParams());
        requestParams.put("signature", this.getSign(requestParams));
        return JSONUtil.toJson(requestParams);
    }

    private String getSign(Map<String, String> requestParams) {
        TreeMap<String, String> sortedParams = new TreeMap<String, String>(requestParams);
        Set entrySets = sortedParams.entrySet();
        StringBuilder signStr = new StringBuilder();
        for (Map.Entry entry : entrySets) {
            signStr.append((String)entry.getKey()).append((String)entry.getValue());
        }
        String toSign = this.appConfig.getAppSecret() + signStr.toString() + this.appConfig.getAppSecret();
        String sign = this.encrypt(toSign);
        return sign.toUpperCase();
    }

    private String encrypt(String inbuf) {
        String s = null;
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(inbuf.getBytes("UTF-8"));
            byte[] tmp = md.digest();
            char[] str = new char[32];
            int k = 0;
            for (int i = 0; i < 16; ++i) {
                byte byte0 = tmp[i];
                str[k++] = hexDigits[byte0 >>> 4 & 0xF];
                str[k++] = hexDigits[byte0 & 0xF];
            }
            s = new String(str);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return s;
    }
}

