/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.connection;

import cn.topca.connection.ConnectionProvider;
import cn.topca.connection.ConnectionSession;
import cn.topca.connection.ConnectionSpi;
import cn.topca.connection.InvalidCodecParameterException;
import cn.topca.connection.protocol.CodecParameter;
import cn.topca.connection.protocol.CodecParameterFactory;
import cn.topca.connection.protocol.CodecProtocol;
import cn.topca.connection.protocol.StringCodecParameterSpec;
import cn.topca.core.AbstractService;
import cn.topca.core.NoSuchProvider;
import cn.topca.core.NoSuchServiceAlgorithm;
import java.io.IOException;

public final class Connection
extends AbstractService {
    public static final String SERVICE_TYPE = Connection.class.getSimpleName();
    private final ConnectionSpi spi = (ConnectionSpi)this.getSpi();
    private CodecProtocol protocol;

    protected Connection(AbstractService.ServiceEngine engine) {
        super(engine);
    }

    public void setCodecProtocol(String protocol, String parameter) throws NoSuchServiceAlgorithm {
        this.protocol = CodecProtocol.getInstance(protocol);
        CodecParameterFactory.getInstance(protocol).generate(new StringCodecParameterSpec(parameter));
    }

    public void setCodecProtocol(CodecProtocol protocol, CodecParameter parameter) throws InvalidCodecParameterException {
        this.protocol = protocol;
        protocol.setParameter(parameter);
    }

    public void connect(String url) throws IOException {
        this.spi.engineConnect(url);
    }

    public void connect(String url, int timeout) throws IOException {
        this.spi.engineConnect(url, timeout);
    }

    public void setConnectTimeout(int timeout) throws IOException {
        this.spi.engineSetConnectTimeout(timeout);
    }

    public int getConnectTimeout() {
        return this.spi.engineGetConnectTimeout();
    }

    public ConnectionSession getSession() throws IOException {
        return new ConnectionSession(this.spi.engineGetSession(), this.protocol);
    }

    public void close(boolean immediately) throws IOException {
        this.spi.engineClose(immediately);
    }

    public CodecProtocol getProtocol() {
        return this.protocol;
    }

    public static Connection getInstance(String algorithm) throws NoSuchServiceAlgorithm {
        return new Connection(Connection.getServiceEngine(SERVICE_TYPE, algorithm));
    }

    public static Connection getInstance(String algorithm, String provider) throws NoSuchProvider, NoSuchServiceAlgorithm {
        return new Connection(Connection.getServiceEngine(SERVICE_TYPE, algorithm, provider));
    }

    public static Connection getInstance(String algorithm, ConnectionProvider provider) throws NoSuchServiceAlgorithm {
        return new Connection(Connection.getServiceEngine(SERVICE_TYPE, algorithm, provider));
    }
}

