/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.connection;

import cn.topca.connection.ConnectionSessionSpi;
import cn.topca.connection.RequestMessage;
import cn.topca.connection.ResponseException;
import cn.topca.connection.ResponseMessage;
import cn.topca.connection.protocol.CodecProtocol;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class ConnectionSession {
    private final ConnectionSessionSpi spi;
    private CodecProtocol protocol;

    protected ConnectionSession(ConnectionSessionSpi spi, CodecProtocol protocol) {
        this.spi = spi;
        this.protocol = protocol;
    }

    public void setSessionTimeout(int timeout) throws IOException {
        this.spi.engineSetSessionTimeout(timeout);
    }

    public int getSessionTimeout() {
        return this.spi.engineGetSessionTimeout();
    }

    public ResponseMessage doRequest(RequestMessage message) throws IOException, ResponseException {
        return this.spi.engineDoRequest(message, this.protocol);
    }

    public OutputStream getOutputStream() throws IOException {
        return this.spi.engineGetOutputStream();
    }

    public InputStream getInputStream() throws IOException {
        return this.spi.engineGetInputStream();
    }

    public void close(boolean immediately) throws IOException {
        this.spi.engineClose(immediately);
    }

    public CodecProtocol getProtocol() {
        return this.protocol;
    }
}

