/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.connection.examples;

import cn.topca.connection.ConnectionSessionSpi;
import cn.topca.connection.ConnectionSpi;
import cn.topca.connection.examples.SampleConnectionSession;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;

public class SampleConnection
extends ConnectionSpi {
    private HttpURLConnection conn;
    private static final long ONE_SECOND = 1000L;

    public void engineConnect(String url) throws IOException {
        this.conn = (HttpURLConnection)new URL(url).openConnection();
        this.conn.setDoOutput(true);
        this.conn.setRequestMethod("POST");
        this.conn.setRequestProperty("Content-Type", "application/octet-stream");
    }

    public void engineConnect(String url, int timeout) throws IOException {
        this.engineConnect(url);
        this.conn.setConnectTimeout(timeout);
    }

    public void engineSetConnectTimeout(int timeout) throws IOException {
        this.conn.setConnectTimeout(timeout);
    }

    public void engineSetReadTimeout(int timeout) throws IOException {
        this.conn.setReadTimeout(timeout);
    }

    protected ConnectionSessionSpi engineGetSession() throws IOException {
        return new SampleConnectionSession(this.conn);
    }

    public void engineClose(boolean immediately) throws IOException {
        if (!immediately) {
            while (this.conn.getInputStream().available() > 0) {
                this.sleep(1000L);
            }
        }
        this.conn.getInputStream().close();
        this.conn.getOutputStream().close();
    }

    void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public int engineGetConnectTimeout() {
        return this.conn.getConnectTimeout();
    }
}

