/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.connection.examples;

import cn.topca.connection.Connection;
import cn.topca.connection.examples.SampleConnectionProvider;
import cn.topca.core.NoSuchServiceAlgorithm;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class SampleConnectionExample {
    public static void main(String[] args) throws IOException, NoSuchServiceAlgorithm {
        SampleConnectionExample.registerProvider();
        SampleConnectionExample.connectTest1();
        SampleConnectionExample.connectTest2();
    }

    static void registerProvider() {
        SampleConnectionProvider connectionProvider = SampleConnectionProvider.getInstance();
        connectionProvider.register();
    }

    static void connectTest1() throws IOException, NoSuchServiceAlgorithm {
        Connection connection = SampleConnectionExample.getConnectionWithName();
        System.out.println(SampleConnectionExample.connect(connection, "http://www.google.com/"));
    }

    static void connectTest2() throws IOException, NoSuchServiceAlgorithm {
        Connection connection = SampleConnectionExample.getConnectionWithAlias();
        System.out.println(SampleConnectionExample.connect(connection, "https://www.google.com/"));
    }

    static String connect(Connection connection, String url) throws IOException {
        connection.connect(url);
        InputStream in = connection.getSession().getInputStream();
        byte[] response = SampleConnectionExample.readResponse(in);
        if (response != null) {
            return new String(response, "UTF-8");
        }
        return null;
    }

    static byte[] readResponse(InputStream in) throws IOException {
        int l;
        byte[] buf = new byte[1024];
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while ((l = in.read(buf)) >= 1) {
            out.write(buf, 0, l);
        }
        if (out.size() > 0) {
            return out.toByteArray();
        }
        return null;
    }

    static Connection getConnectionWithName() throws NoSuchServiceAlgorithm {
        return Connection.getInstance("SampleHttp");
    }

    static Connection getConnectionWithAlias() throws NoSuchServiceAlgorithm {
        return Connection.getInstance("HTTP");
    }
}

