/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.connection.protocol;

import cn.topca.connection.InvalidCodecParameterException;
import cn.topca.connection.Message;
import cn.topca.connection.protocol.CodecParameter;
import cn.topca.connection.protocol.CodecProtocolProvider;
import cn.topca.connection.protocol.CodecProtocolSpi;
import cn.topca.core.AbstractService;
import cn.topca.core.NoSuchProvider;
import cn.topca.core.NoSuchServiceAlgorithm;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CodecProtocol
extends AbstractService {
    public static final String SERVICE_TYPE = CodecProtocol.class.getSimpleName();
    private final CodecProtocolSpi spi;

    private CodecProtocol(AbstractService.ServiceEngine engine) {
        super(engine);
        this.spi = (CodecProtocolSpi)engine.getSpi();
    }

    public void setParameter(CodecParameter parameter) throws InvalidCodecParameterException {
        this.spi.engineSetParameter(parameter);
    }

    public CodecParameter getParameter() {
        return this.spi.engineGetParameter();
    }

    public void encode(Message message, OutputStream out) throws IOException {
        this.spi.engineEncode(message, out);
    }

    public byte[] encode(Message message) throws IOException {
        return this.spi.engineEncode(message);
    }

    public Message decode(InputStream in) throws IOException {
        return this.spi.engineDecode(in);
    }

    public Message decode(byte[] encoded) throws IOException {
        return this.spi.engineDecode(encoded);
    }

    public static CodecProtocol getInstance(String algorithm) throws NoSuchServiceAlgorithm {
        return new CodecProtocol(CodecProtocol.getServiceEngine(SERVICE_TYPE, algorithm));
    }

    public static CodecProtocol getInstance(String algorithm, String provider) throws NoSuchServiceAlgorithm, NoSuchProvider {
        return new CodecProtocol(CodecProtocol.getServiceEngine(SERVICE_TYPE, algorithm, provider));
    }

    public static CodecProtocol getInstance(String algorithm, CodecProtocolProvider provider) throws NoSuchServiceAlgorithm {
        return new CodecProtocol(CodecProtocol.getServiceEngine(SERVICE_TYPE, algorithm, provider));
    }
}

