/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.core;

import java.security.Provider;
import java.security.Security;

public abstract class ServiceProvider {
    private final Provider p;
    private transient boolean changed = false;

    protected ServiceProvider(String name, double version, String info) {
        this.p = new Delegate(name, version, info);
    }

    protected void addServiceEngine(String serviceName, String engineClass, String algorithm, String[] aliases) {
        this.p.put(serviceName + "." + algorithm, engineClass);
        if (aliases != null) {
            for (String alias : aliases) {
                this.p.put("Alg.Alias." + serviceName + "." + alias, algorithm);
            }
        }
        this.changed = true;
    }

    public synchronized ServiceProvider register() {
        if (this.changed) {
            Security.removeProvider(this.p.getName());
        }
        if (Security.getProvider(this.p.getName()) == null) {
            Security.addProvider(this.p);
            this.changed = false;
        }
        return this;
    }

    protected Provider getProvider() {
        return this.p;
    }

    protected static class Delegate
    extends Provider {
        protected Delegate(String name, double version, String info) {
            super(name, version, info);
        }
    }
}

