/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.core.ext.bc.asn1.cms;

import cn.tca.TopBasicCrypto.asn1.ASN1Encodable;
import cn.tca.TopBasicCrypto.asn1.ASN1EncodableVector;
import cn.tca.TopBasicCrypto.asn1.ASN1OctetString;
import cn.tca.TopBasicCrypto.asn1.ASN1Sequence;
import cn.tca.TopBasicCrypto.asn1.ASN1TaggedObject;
import cn.tca.TopBasicCrypto.asn1.BERSequence;
import cn.tca.TopBasicCrypto.asn1.BERTaggedObject;
import cn.tca.TopBasicCrypto.asn1.DEREncodable;
import cn.tca.TopBasicCrypto.asn1.DERObject;
import cn.tca.TopBasicCrypto.asn1.DERObjectIdentifier;
import cn.tca.TopBasicCrypto.asn1.x509.AlgorithmIdentifier;

public class EncryptedContentInfo
extends ASN1Encodable {
    private DERObjectIdentifier contentType;
    private AlgorithmIdentifier contentEncryptionAlgorithm;
    private ASN1OctetString encryptedContent;
    private ASN1OctetString sharedInfo1;
    private ASN1OctetString sharedInfo2;

    public EncryptedContentInfo(DERObjectIdentifier contentType, AlgorithmIdentifier contentEncryptionAlgorithm, ASN1OctetString encryptedContent) {
        this.contentType = contentType;
        this.contentEncryptionAlgorithm = contentEncryptionAlgorithm;
        this.encryptedContent = encryptedContent;
    }

    public EncryptedContentInfo(DERObjectIdentifier contentType, AlgorithmIdentifier contentEncryptionAlgorithm, ASN1OctetString encryptedContent, ASN1OctetString sharedInfo1, ASN1OctetString sharedInfo2) {
        this.contentType = contentType;
        this.contentEncryptionAlgorithm = contentEncryptionAlgorithm;
        this.encryptedContent = encryptedContent;
        this.sharedInfo1 = sharedInfo1;
        this.sharedInfo2 = sharedInfo2;
    }

    public EncryptedContentInfo(ASN1Sequence seq) {
        this.contentType = (DERObjectIdentifier)seq.getObjectAt(0);
        this.contentEncryptionAlgorithm = AlgorithmIdentifier.getInstance((Object)seq.getObjectAt(1));
        if (seq.size() > 2) {
            this.encryptedContent = ASN1OctetString.getInstance((ASN1TaggedObject)((ASN1TaggedObject)seq.getObjectAt(2)), (boolean)false);
        }
        if (seq.size() > 3) {
            this.sharedInfo1 = ASN1OctetString.getInstance((ASN1TaggedObject)((ASN1TaggedObject)seq.getObjectAt(3)), (boolean)false);
        }
        if (seq.size() > 4) {
            this.sharedInfo2 = ASN1OctetString.getInstance((ASN1TaggedObject)((ASN1TaggedObject)seq.getObjectAt(4)), (boolean)false);
        }
    }

    public static EncryptedContentInfo getInstance(Object obj) {
        if (obj == null || obj instanceof EncryptedContentInfo) {
            return (EncryptedContentInfo)((Object)obj);
        }
        if (obj instanceof ASN1Sequence) {
            return new EncryptedContentInfo((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("Invalid EncryptedContentInfo: " + obj.getClass().getName());
    }

    public DERObjectIdentifier getContentType() {
        return this.contentType;
    }

    public AlgorithmIdentifier getContentEncryptionAlgorithm() {
        return this.contentEncryptionAlgorithm;
    }

    public ASN1OctetString getEncryptedContent() {
        return this.encryptedContent;
    }

    public ASN1OctetString getSharedInfo1() {
        return this.sharedInfo1;
    }

    public ASN1OctetString getSharedInfo2() {
        return this.sharedInfo2;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((DEREncodable)this.contentType);
        v.add((DEREncodable)this.contentEncryptionAlgorithm);
        if (this.encryptedContent != null) {
            v.add((DEREncodable)new BERTaggedObject(false, 0, (DEREncodable)this.encryptedContent));
        }
        if (this.sharedInfo1 != null) {
            v.add((DEREncodable)new BERTaggedObject(false, 1, (DEREncodable)this.sharedInfo1));
        }
        if (this.sharedInfo2 != null) {
            v.add((DEREncodable)new BERTaggedObject(false, 2, (DEREncodable)this.sharedInfo2));
        }
        return new BERSequence(v);
    }
}

