/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.core.ext.bc.asn1.x509;

import cn.tca.TopBasicCrypto.asn1.ASN1Sequence;
import cn.tca.TopBasicCrypto.asn1.DEREncodable;
import cn.tca.TopBasicCrypto.asn1.x509.AlgorithmIdentifier;
import java.io.IOException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;

public class SubjectPublicKeyInfo
extends cn.tca.TopBasicCrypto.asn1.x509.SubjectPublicKeyInfo {
    public SubjectPublicKeyInfo(AlgorithmIdentifier algId, DEREncodable publicKey) {
        super(algId, publicKey);
    }

    public SubjectPublicKeyInfo(AlgorithmIdentifier algId, byte[] publicKey) {
        super(algId, publicKey);
    }

    public SubjectPublicKeyInfo(ASN1Sequence seq) {
        super(seq);
    }

    public SubjectPublicKeyInfo(PublicKey publicKey) {
        super(ASN1Sequence.getInstance((Object)publicKey));
    }

    public SubjectPublicKeyInfo(cn.tca.TopBasicCrypto.asn1.x509.SubjectPublicKeyInfo subjectPublicKeyInfo) {
        super(subjectPublicKeyInfo.getAlgorithmId(), (DEREncodable)subjectPublicKeyInfo.getPublicKeyData());
    }

    public static SubjectPublicKeyInfo getInstance(Object obj) {
        if (obj instanceof SubjectPublicKeyInfo) {
            return (SubjectPublicKeyInfo)((Object)obj);
        }
        if (obj instanceof cn.tca.TopBasicCrypto.asn1.x509.SubjectPublicKeyInfo) {
            cn.tca.TopBasicCrypto.asn1.x509.SubjectPublicKeyInfo info = (cn.tca.TopBasicCrypto.asn1.x509.SubjectPublicKeyInfo)obj;
            return new SubjectPublicKeyInfo(info.getAlgorithmId(), (DEREncodable)info.getPublicKeyData());
        }
        if (obj != null) {
            if (obj instanceof PublicKey) {
                obj = ((PublicKey)obj).getEncoded();
            }
            return new SubjectPublicKeyInfo(ASN1Sequence.getInstance((Object)obj));
        }
        return null;
    }

    public PublicKey getJcaPublicKey() throws NoSuchAlgorithmException, IOException, InvalidKeySpecException {
        KeyFactory keyFactory = KeyFactory.getInstance(this.getAlgorithmId().getAlgorithm().getId());
        return keyFactory.generatePublic(new X509EncodedKeySpec(this.getEncoded()));
    }
}

