/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.core.ext.bc.cms;

import cn.tca.TopBasicCrypto.asn1.ASN1EncodableVector;
import cn.tca.TopBasicCrypto.asn1.ASN1ObjectIdentifier;
import cn.tca.TopBasicCrypto.asn1.ASN1OctetString;
import cn.tca.TopBasicCrypto.asn1.ASN1Set;
import cn.tca.TopBasicCrypto.asn1.BERConstructedOctetString;
import cn.tca.TopBasicCrypto.asn1.DEREncodable;
import cn.tca.TopBasicCrypto.asn1.DERNull;
import cn.tca.TopBasicCrypto.asn1.DERObjectIdentifier;
import cn.tca.TopBasicCrypto.asn1.DEROctetString;
import cn.tca.TopBasicCrypto.asn1.DEROutputStream;
import cn.tca.TopBasicCrypto.asn1.DERSet;
import cn.tca.TopBasicCrypto.asn1.cms.AttributeTable;
import cn.tca.TopBasicCrypto.asn1.cms.CMSAttributes;
import cn.tca.TopBasicCrypto.asn1.cms.CMSObjectIdentifiers;
import cn.tca.TopBasicCrypto.asn1.cms.ContentInfo;
import cn.tca.TopBasicCrypto.asn1.cms.SignedData;
import cn.tca.TopBasicCrypto.asn1.cms.SignerIdentifier;
import cn.tca.TopBasicCrypto.asn1.cms.SignerInfo;
import cn.tca.TopBasicCrypto.asn1.x509.AlgorithmIdentifier;
import cn.tca.TopBasicCrypto.cms.CMSAttributeTableGenerator;
import cn.tca.TopBasicCrypto.cms.CMSException;
import cn.tca.TopBasicCrypto.cms.CMSProcessable;
import cn.tca.TopBasicCrypto.cms.CMSTypedData;
import cn.topca.core.ext.bc.cms.CMSProcessableByteArray;
import cn.topca.core.ext.bc.cms.CMSSignedData;
import cn.topca.core.ext.bc.cms.CMSSignedGenerator;
import cn.topca.core.ext.bc.cms.CMSSignedHelper;
import cn.topca.core.ext.bc.cms.CMSUtils;
import cn.topca.core.ext.bc.cms.DigOutputStream;
import cn.topca.core.ext.bc.cms.SignerInfoGenerator;
import cn.topca.core.ext.bc.cms.SignerInformation;
import cn.topca.core.ext.bc.cms.SignerInformationStore;
import cn.topca.security.SignatureOutputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class CMSSignedDataGenerator
extends CMSSignedGenerator {
    private List signerInfs = new ArrayList();

    public CMSSignedDataGenerator() {
    }

    public CMSSignedDataGenerator(SecureRandom rand) {
        super(rand);
    }

    private void doAddSigner(PrivateKey key, SignerIdentifier signerIdentifier, String encryptionOID, String digestOID, CMSAttributeTableGenerator signedAttrGen, CMSAttributeTableGenerator unsignedAttrGen, AttributeTable baseSignedTable) throws IllegalArgumentException {
        this.signerInfs.add(new SignerInf(key, signerIdentifier, digestOID, encryptionOID, signedAttrGen, unsignedAttrGen, baseSignedTable));
    }

    public CMSSignedData generate(CMSProcessable content, String sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.generate(content, CMSUtils.getProvider(sigProvider));
    }

    public CMSSignedData generate(CMSProcessable content, Provider sigProvider) throws NoSuchAlgorithmException, CMSException {
        if (content instanceof CMSTypedData) {
            return this.generate(((CMSTypedData)content).getContentType().getId(), content, false, sigProvider, true);
        }
        return this.generate(DATA, content, false, sigProvider, true);
    }

    public CMSSignedData generate(String eContentType, CMSProcessable content, boolean encapsulate, Provider sigProvider, boolean addDefaultAttributes) throws NoSuchAlgorithmException, CMSException {
        ASN1EncodableVector digestAlgs = new ASN1EncodableVector();
        ASN1EncodableVector signerInfos = new ASN1EncodableVector();
        this.digests.clear();
        for (SignerInformation signer : this._signers) {
            digestAlgs.add((DEREncodable)CMSSignedHelper.INSTANCE.fixAlgID(signer.getDigestAlgorithmID()));
            signerInfos.add((DEREncodable)signer.toASN1Structure());
        }
        boolean isCounterSignature = eContentType == null;
        ASN1ObjectIdentifier contentTypeOID = isCounterSignature ? null : new ASN1ObjectIdentifier(eContentType);
        for (SignerInfoGenerator sGen : this.signerGens) {
            if (content != null) {
                OutputStream cOut = sGen.getCalculatingOutputStream();
                try {
                    content.write(cOut);
                    cOut.close();
                }
                catch (IOException e) {
                    throw new CMSException("data processing exception: " + e.getMessage(), (Exception)e);
                }
            }
            SignerInfo inf = sGen.generate(contentTypeOID);
            digestAlgs.add((DEREncodable)inf.getDigestAlgorithm());
            signerInfos.add((DEREncodable)inf);
        }
        for (SignerInf signer : this.signerInfs) {
            try {
                digestAlgs.add((DEREncodable)signer.getDigestAlgorithmID());
                signerInfos.add((DEREncodable)signer.toSignerInfo((DERObjectIdentifier)contentTypeOID, content, this.rand, sigProvider, addDefaultAttributes));
            }
            catch (IOException e) {
                throw new CMSException("encoding error.", (Exception)e);
            }
            catch (InvalidKeyException e) {
                throw new CMSException("key inappropriate for signature.", (Exception)e);
            }
            catch (SignatureException e) {
                throw new CMSException("error creating signature.", (Exception)e);
            }
            catch (CertificateEncodingException e) {
                throw new CMSException("error creating sid.", (Exception)e);
            }
        }
        ASN1Set certificates = null;
        if (this.certs.size() != 0) {
            certificates = CMSUtils.createBerSetFromList(this.certs);
        }
        ASN1Set certrevlist = null;
        if (this.crls.size() != 0) {
            certrevlist = CMSUtils.createBerSetFromList(this.crls);
        }
        BERConstructedOctetString octs = null;
        if (encapsulate) {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            if (content != null) {
                try {
                    content.write((OutputStream)bOut);
                }
                catch (IOException e) {
                    throw new CMSException("encapsulation error.", (Exception)e);
                }
            }
            octs = new BERConstructedOctetString(bOut.toByteArray());
        }
        ContentInfo encInfo = new ContentInfo(contentTypeOID, octs);
        SignedData sd = new SignedData((ASN1Set)new DERSet(digestAlgs), encInfo, certificates, certrevlist, (ASN1Set)new DERSet(signerInfos));
        ContentInfo contentInfo = new ContentInfo(CMSObjectIdentifiers.signedData, (DEREncodable)sd);
        return new CMSSignedData(content, contentInfo);
    }

    public CMSSignedData generate(CMSTypedData content) throws CMSException {
        return this.generate(content, false);
    }

    public CMSSignedData generate(CMSTypedData content, boolean encapsulate) throws CMSException {
        ByteArrayOutputStream bOut;
        if (!this.signerInfs.isEmpty()) {
            throw new IllegalStateException("this method can only be used with SignerInfoGenerator");
        }
        ASN1EncodableVector digestAlgs = new ASN1EncodableVector();
        ASN1EncodableVector signerInfos = new ASN1EncodableVector();
        this.digests.clear();
        for (SignerInformation signer : this._signers) {
            digestAlgs.add((DEREncodable)CMSSignedHelper.INSTANCE.fixAlgID(signer.getDigestAlgorithmID()));
            signerInfos.add((DEREncodable)signer.toASN1Structure());
        }
        ASN1ObjectIdentifier contentTypeOID = content.getContentType();
        BERConstructedOctetString octs = null;
        if (encapsulate) {
            bOut = new ByteArrayOutputStream();
            if (content != null) {
                try {
                    content.write((OutputStream)bOut);
                }
                catch (IOException e) {
                    throw new CMSException("encapsulation error.", (Exception)e);
                }
            }
            octs = new BERConstructedOctetString(bOut.toByteArray());
        }
        if (content != null) {
            bOut = null;
            if (encapsulate) {
                bOut = new ByteArrayOutputStream();
            }
            OutputStream cOut = CMSUtils.attachSignersToOutputStream(this.signerGens, bOut);
            cOut = CMSUtils.getSafeOutputStream(cOut);
            try {
                content.write(cOut);
                cOut.close();
            }
            catch (IOException e) {
                throw new CMSException("data processing exception: " + e.getMessage(), (Exception)e);
            }
            if (encapsulate) {
                octs = new BERConstructedOctetString(bOut.toByteArray());
            }
        }
        for (SignerInfoGenerator sGen : this.signerGens) {
            SignerInfo inf = sGen.generate(contentTypeOID);
            digestAlgs.add((DEREncodable)inf.getDigestAlgorithm());
            signerInfos.add((DEREncodable)inf);
            byte[] calcDigest = sGen.getCalculatedDigest();
            if (calcDigest == null) continue;
            this.digests.put(inf.getDigestAlgorithm().getAlgorithm().getId(), calcDigest);
        }
        ASN1Set certificates = null;
        if (this.certs.size() != 0) {
            certificates = CMSUtils.createBerSetFromList(this.certs);
        }
        ASN1Set certrevlist = null;
        if (this.crls.size() != 0) {
            certrevlist = CMSUtils.createBerSetFromList(this.crls);
        }
        ContentInfo encInfo = new ContentInfo(contentTypeOID, (DEREncodable)octs);
        SignedData sd = new SignedData((ASN1Set)new DERSet(digestAlgs), encInfo, certificates, certrevlist, (ASN1Set)new DERSet(signerInfos));
        ContentInfo contentInfo = new ContentInfo(CMSObjectIdentifiers.signedData, (DEREncodable)sd);
        return new CMSSignedData((CMSProcessable)content, contentInfo);
    }

    public SignerInformationStore generateCounterSigners(SignerInformation signer) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.generate(new CMSProcessableByteArray(null, signer.getSignature()), false).getSignerInfos();
    }

    private class SignerInf {
        final PrivateKey key;
        final SignerIdentifier signerIdentifier;
        final String digestOID;
        final String encOID;
        final CMSAttributeTableGenerator sAttr;
        final CMSAttributeTableGenerator unsAttr;
        final AttributeTable baseSignedTable;

        SignerInf(PrivateKey key, SignerIdentifier signerIdentifier, String digestOID, String encOID, CMSAttributeTableGenerator sAttr, CMSAttributeTableGenerator unsAttr, AttributeTable baseSignedTable) {
            this.key = key;
            this.signerIdentifier = signerIdentifier;
            this.digestOID = digestOID;
            this.encOID = encOID;
            this.sAttr = sAttr;
            this.unsAttr = unsAttr;
            this.baseSignedTable = baseSignedTable;
        }

        AlgorithmIdentifier getDigestAlgorithmID() {
            return new AlgorithmIdentifier(new DERObjectIdentifier(this.digestOID), (DEREncodable)new DERNull());
        }

        SignerInfo toSignerInfo(DERObjectIdentifier contentType, CMSProcessable content, SecureRandom random, Provider sigProvider, boolean addDefaultAttributes) throws IOException, SignatureException, InvalidKeyException, NoSuchAlgorithmException, CertificateEncodingException, CMSException {
            AttributeTable signed;
            AlgorithmIdentifier digAlgId = this.getDigestAlgorithmID();
            String digestName = CMSSignedHelper.INSTANCE.getDigestAlgName(this.digestOID);
            String signatureName = digestName + "with" + CMSSignedHelper.INSTANCE.getEncryptionAlgName(this.encOID);
            Signature sig = CMSSignedHelper.INSTANCE.getSignatureInstance(signatureName, sigProvider);
            MessageDigest dig = CMSSignedHelper.INSTANCE.getDigestInstance(digestName, sigProvider);
            AlgorithmIdentifier encAlgId = CMSSignedDataGenerator.this.getEncAlgorithmIdentifier(this.encOID, sig);
            if (content != null) {
                content.write((OutputStream)new DigOutputStream(dig));
            }
            byte[] hash = dig.digest();
            CMSSignedDataGenerator.this.digests.put(this.digestOID, hash.clone());
            if (addDefaultAttributes) {
                Map parameters = CMSSignedDataGenerator.this.getBaseParameters(contentType, digAlgId, hash);
                signed = this.sAttr != null ? this.sAttr.getAttributes(Collections.unmodifiableMap(parameters)) : null;
            } else {
                signed = this.baseSignedTable;
            }
            sig.initSign(this.key, random);
            BufferedOutputStream sigStr = new BufferedOutputStream(new SignatureOutputStream(sig));
            ASN1Set signedAttr = null;
            if (signed != null) {
                if (contentType == null && signed.get((DERObjectIdentifier)CMSAttributes.contentType) != null) {
                    Hashtable tmpSigned = signed.toHashtable();
                    tmpSigned.remove(CMSAttributes.contentType);
                    signed = new AttributeTable(tmpSigned);
                }
                signedAttr = CMSSignedDataGenerator.this.getAttributeSet(signed);
                new DEROutputStream((OutputStream)sigStr).writeObject((Object)signedAttr);
            } else if (content != null) {
                content.write((OutputStream)sigStr);
            }
            ((OutputStream)sigStr).close();
            byte[] sigBytes = sig.sign();
            ASN1Set unsignedAttr = null;
            if (this.unsAttr != null) {
                Map parameters = CMSSignedDataGenerator.this.getBaseParameters(contentType, digAlgId, hash);
                parameters.put("encryptedDigest", sigBytes.clone());
                AttributeTable unsigned = this.unsAttr.getAttributes(Collections.unmodifiableMap(parameters));
                unsignedAttr = CMSSignedDataGenerator.this.getAttributeSet(unsigned);
            }
            return new SignerInfo(this.signerIdentifier, digAlgId, signedAttr, encAlgId, (ASN1OctetString)new DEROctetString(sigBytes), unsignedAttr);
        }
    }
}

