/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.core.ext.bc.cms;

import cn.tca.TopBasicCrypto.asn1.cms.KEKIdentifier;
import cn.tca.TopBasicCrypto.asn1.cms.KEKRecipientInfo;
import cn.tca.TopBasicCrypto.asn1.x509.AlgorithmIdentifier;
import cn.tca.TopBasicCrypto.cms.CMSException;
import cn.tca.TopBasicCrypto.cms.CMSTypedStream;
import cn.tca.TopBasicCrypto.cms.KEKRecipient;
import cn.tca.TopBasicCrypto.cms.KEKRecipientId;
import cn.tca.TopBasicCrypto.cms.Recipient;
import cn.tca.TopBasicCrypto.cms.RecipientOperator;
import cn.topca.core.ext.bc.cms.AuthAttributesProvider;
import cn.topca.core.ext.bc.cms.CMSEnvelopedHelper;
import cn.topca.core.ext.bc.cms.CMSSecureReadable;
import cn.topca.core.ext.bc.cms.CMSUtils;
import cn.topca.core.ext.bc.cms.RecipientInformation;
import cn.topca.crypto.Cipher;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import javax.crypto.NoSuchPaddingException;

public class KEKRecipientInformation
extends RecipientInformation {
    private KEKRecipientInfo info;

    KEKRecipientInformation(KEKRecipientInfo info, AlgorithmIdentifier messageAlgorithm, CMSSecureReadable secureReadable, AuthAttributesProvider additionalData) {
        super(info.getKeyEncryptionAlgorithm(), messageAlgorithm, secureReadable, additionalData);
        this.info = info;
        KEKIdentifier kekId = info.getKekid();
        this.rid = new KEKRecipientId(kekId.getKeyIdentifier().getOctets());
    }

    public CMSTypedStream getContentStream(Key key, String prov) throws CMSException, NoSuchProviderException {
        return this.getContentStream(key, CMSUtils.getProvider(prov));
    }

    public CMSTypedStream getContentStream(Key key, Provider prov) throws CMSException {
        try {
            Cipher keyCipher = CMSEnvelopedHelper.INSTANCE.createSymmetricCipher(this.keyEncAlg.getAlgorithm().getId(), prov);
            keyCipher.init(4, key);
            Key sKey = keyCipher.unwrap(this.info.getEncryptedKey().getOctets(), this.getContentAlgorithmName(), 3);
            return this.getContentFromSessionKey(sKey, prov);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CMSException("can't find algorithm.", (Exception)e);
        }
        catch (InvalidKeyException e) {
            throw new CMSException("key invalid in message.", (Exception)e);
        }
        catch (NoSuchPaddingException e) {
            throw new CMSException("required padding not supported.", (Exception)e);
        }
    }

    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException, IOException {
        return ((KEKRecipient)recipient).getRecipientOperator(this.keyEncAlg, this.messageAlgorithm, this.info.getEncryptedKey().getOctets());
    }
}

