/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.core.ext.bc.cms;

import cn.tca.TopBasicCrypto.asn1.ASN1OctetString;
import cn.tca.TopBasicCrypto.asn1.DERObjectIdentifier;
import cn.tca.TopBasicCrypto.asn1.cms.IssuerAndSerialNumber;
import cn.tca.TopBasicCrypto.asn1.cms.KeyTransRecipientInfo;
import cn.tca.TopBasicCrypto.asn1.cms.RecipientIdentifier;
import cn.tca.TopBasicCrypto.asn1.pkcs.PKCSObjectIdentifiers;
import cn.tca.TopBasicCrypto.asn1.x509.AlgorithmIdentifier;
import cn.tca.TopBasicCrypto.cms.CMSException;
import cn.tca.TopBasicCrypto.cms.KeyTransRecipient;
import cn.tca.TopBasicCrypto.cms.KeyTransRecipientId;
import cn.tca.TopBasicCrypto.cms.Recipient;
import cn.tca.TopBasicCrypto.cms.RecipientOperator;
import cn.topca.core.ext.bc.cms.AuthAttributesProvider;
import cn.topca.core.ext.bc.cms.CMSSecureReadable;
import cn.topca.core.ext.bc.cms.RecipientInformation;

public class KeyTransRecipientInformation
extends RecipientInformation {
    private KeyTransRecipientInfo info;

    KeyTransRecipientInformation(KeyTransRecipientInfo info, AlgorithmIdentifier messageAlgorithm, CMSSecureReadable secureReadable, AuthAttributesProvider additionalData) {
        super(info.getKeyEncryptionAlgorithm(), messageAlgorithm, secureReadable, additionalData);
        this.info = info;
        RecipientIdentifier r = info.getRecipientIdentifier();
        if (r.isTagged()) {
            ASN1OctetString octs = ASN1OctetString.getInstance((Object)r.getId());
            this.rid = new KeyTransRecipientId(octs.getOctets());
        } else {
            IssuerAndSerialNumber iAnds = IssuerAndSerialNumber.getInstance((Object)r.getId());
            this.rid = new KeyTransRecipientId(iAnds.getName(), iAnds.getSerialNumber().getValue());
        }
    }

    private String getExchangeEncryptionAlgorithmName(DERObjectIdentifier oid) {
        if (PKCSObjectIdentifiers.rsaEncryption.equals((Object)oid)) {
            return "RSA/ECB/PKCS1Padding";
        }
        return oid.getId();
    }

    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException {
        return ((KeyTransRecipient)recipient).getRecipientOperator(this.keyEncAlg, this.messageAlgorithm, this.info.getEncryptedKey().getOctets());
    }
}

