/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.core.ext.bc.ocsp;

import cn.tca.TopBasicCrypto.asn1.ASN1ObjectIdentifier;
import cn.tca.TopBasicCrypto.asn1.ASN1OctetString;
import cn.tca.TopBasicCrypto.asn1.DEROctetString;
import cn.tca.TopBasicCrypto.asn1.ocsp.OCSPObjectIdentifiers;
import cn.tca.TopBasicCrypto.asn1.x509.X509Extension;
import cn.tca.TopBasicCrypto.asn1.x509.X509Extensions;
import cn.tca.TopBasicCrypto.cert.X509CertificateHolder;
import cn.tca.TopBasicCrypto.cert.ocsp.CertificateID;
import cn.tca.TopBasicCrypto.cert.ocsp.OCSPException;
import cn.tca.TopBasicCrypto.cert.ocsp.OCSPReq;
import cn.tca.TopBasicCrypto.cert.ocsp.OCSPReqBuilder;
import cn.tca.TopBasicCrypto.operator.DigestCalculator;
import cn.tca.TopBasicCrypto.operator.OperatorCreationException;
import cn.topca.core.ext.bc.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import java.math.BigInteger;
import java.util.Vector;

public class OCSPOperatorUtils {
    public static OCSPReq generateOCSPRequest(X509CertificateHolder issuerCert, BigInteger serialNumber) throws OCSPException, OperatorCreationException {
        JcaDigestCalculatorProviderBuilder jcaDigestCalculatorProviderBuilder = new JcaDigestCalculatorProviderBuilder();
        DigestCalculator digestCalculator = jcaDigestCalculatorProviderBuilder.build().get(CertificateID.HASH_SHA1);
        CertificateID id = new CertificateID(digestCalculator, issuerCert, serialNumber);
        OCSPReqBuilder ocspReqBuilder = new OCSPReqBuilder();
        ocspReqBuilder.addRequest(id);
        BigInteger nonce = BigInteger.valueOf(System.currentTimeMillis());
        Vector<ASN1ObjectIdentifier> oids = new Vector<ASN1ObjectIdentifier>();
        Vector<X509Extension> values = new Vector<X509Extension>();
        oids.add(OCSPObjectIdentifiers.id_pkix_ocsp_nonce);
        values.add(new X509Extension(false, (ASN1OctetString)new DEROctetString(nonce.toByteArray())));
        ocspReqBuilder.setRequestExtensions(new X509Extensions(oids, values));
        return ocspReqBuilder.build();
    }
}

