/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.core.ext.bc.openssl;

import cn.tca.TopBasicCrypto.asn1.x509.SubjectPublicKeyInfo;
import cn.tca.TopBasicCrypto.openssl.PEMReader;
import cn.tca.TopBasicCrypto.openssl.PasswordFinder;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;

public class OpenSslUtils {
    public static PublicKey convertPublicKey(SubjectPublicKeyInfo publicKeyInfo) throws NoSuchAlgorithmException, IOException, InvalidKeySpecException {
        KeyFactory keyFactory = KeyFactory.getInstance(publicKeyInfo.getAlgorithmId().getAlgorithm().getId());
        return keyFactory.generatePublic(new X509EncodedKeySpec(publicKeyInfo.getEncoded()));
    }

    public static Certificate decodePEMCert(String pemCert) {
        try {
            PEMReader reader = new PEMReader((Reader)new StringReader(pemCert));
            return (Certificate)reader.readObject();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static PrivateKey decodePEMPrivateKey(String pemKey, final char[] password) {
        try {
            PEMReader reader = new PEMReader((Reader)new StringReader(pemKey), new PasswordFinder(){

                public char[] getPassword() {
                    return password;
                }
            });
            return ((KeyPair)reader.readObject()).getPrivate();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

