/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.core.ext.bc.operator.jcajce;

import cn.tca.TopBasicCrypto.asn1.ASN1ObjectIdentifier;
import cn.tca.TopBasicCrypto.asn1.DEREncodable;
import cn.tca.TopBasicCrypto.asn1.x509.SubjectPublicKeyInfo;
import cn.tca.TopBasicCrypto.operator.AsymmetricKeyWrapper;
import cn.tca.TopBasicCrypto.operator.GenericKey;
import cn.tca.TopBasicCrypto.operator.OperatorException;
import cn.topca.core.ext.bc.jcajce.DefaultJcaJceHelper;
import cn.topca.core.ext.bc.jcajce.NamedJcaJceHelper;
import cn.topca.core.ext.bc.jcajce.ProviderJcaJceHelper;
import cn.topca.core.ext.bc.operator.jcajce.OperatorHelper;
import cn.topca.core.ext.bc.operator.jcajce.OperatorUtils;
import cn.topca.crypto.Cipher;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.Provider;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;

public class JceAsymmetricKeyWrapper
extends AsymmetricKeyWrapper {
    private OperatorHelper helper = new OperatorHelper(new DefaultJcaJceHelper());
    private PublicKey publicKey;
    private SecureRandom random;

    public JceAsymmetricKeyWrapper(PublicKey publicKey) {
        super(SubjectPublicKeyInfo.getInstance((Object)publicKey.getEncoded()).getAlgorithmId());
        this.publicKey = publicKey;
    }

    public JceAsymmetricKeyWrapper(X509Certificate certificate) {
        this(certificate.getPublicKey());
    }

    public JceAsymmetricKeyWrapper setProvider(Provider provider) {
        this.helper = new OperatorHelper(new ProviderJcaJceHelper(provider));
        return this;
    }

    public JceAsymmetricKeyWrapper setProvider(String providerName) {
        this.helper = new OperatorHelper(new NamedJcaJceHelper(providerName));
        return this;
    }

    public JceAsymmetricKeyWrapper setSecureRandom(SecureRandom random) {
        this.random = random;
        return this;
    }

    public byte[] generateWrappedKey(GenericKey encryptionKey) throws OperatorException {
        DEREncodable algParams;
        ASN1ObjectIdentifier algorithm = this.getAlgorithmIdentifier().getAlgorithm();
        if (algorithm.getId().equals("1.2.840.10045.2.1") && (algParams = this.getAlgorithmIdentifier().getParameters()) instanceof ASN1ObjectIdentifier) {
            algorithm = (ASN1ObjectIdentifier)algParams;
        }
        Cipher keyEncryptionCipher = this.helper.createAsymmetricWrapper(algorithm);
        byte[] encryptedKeyBytes = null;
        try {
            keyEncryptionCipher.init(3, (Key)this.publicKey, this.random);
            encryptedKeyBytes = keyEncryptionCipher.wrap(OperatorUtils.getJceKey(encryptionKey));
        }
        catch (GeneralSecurityException e) {
        }
        catch (IllegalStateException e) {
        }
        catch (UnsupportedOperationException e) {
        }
        catch (ProviderException e) {
            // empty catch block
        }
        if (encryptedKeyBytes == null) {
            try {
                keyEncryptionCipher.init(1, (Key)this.publicKey, this.random);
                encryptedKeyBytes = keyEncryptionCipher.doFinal(OperatorUtils.getJceKey(encryptionKey).getEncoded());
            }
            catch (GeneralSecurityException e) {
                throw new OperatorException("unable to encrypt contents key", (Throwable)e);
            }
        }
        return encryptedKeyBytes;
    }
}

