/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.core.ext.bc.util;

import cn.tca.TopBasicCrypto.asn1.ASN1Encodable;
import cn.tca.TopBasicCrypto.asn1.x500.X500Name;
import cn.tca.TopBasicCrypto.asn1.x509.BasicConstraints;
import cn.tca.TopBasicCrypto.asn1.x509.ExtendedKeyUsage;
import cn.tca.TopBasicCrypto.asn1.x509.KeyPurposeId;
import cn.tca.TopBasicCrypto.asn1.x509.KeyUsage;
import cn.tca.TopBasicCrypto.asn1.x509.SubjectPublicKeyInfo;
import cn.tca.TopBasicCrypto.asn1.x509.X509Extension;
import cn.tca.TopBasicCrypto.cert.X509CertificateHolder;
import cn.tca.TopBasicCrypto.cert.X509v3CertificateBuilder;
import cn.tca.TopBasicCrypto.operator.ContentSigner;
import cn.tca.TopBasicCrypto.operator.OperatorCreationException;
import cn.topca.core.ext.bc.operator.jcajce.JcaContentSignerBuilder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import org.apache.commons.codec.binary.Hex;

public class KeyStoreUtils {
    private static final long ONE_YEAR = 31536000000L;
    private static final List<String> softKeyStoreAlg = new ArrayList<String>(2);

    public static String getPublicKeyAlias(KeyStore keyStore, PublicKey publicKey) throws KeyStoreException {
        Enumeration<String> aliases = keyStore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            if (!publicKey.equals(keyStore.getCertificate(alias).getPublicKey())) continue;
            return alias;
        }
        return null;
    }

    public static Certificate buildSelfSignedCert(KeyPair keyPair, String subjectDN, String provider) throws CertificateException, IOException {
        ContentSigner signer;
        byte[] publicKeyHash;
        Date notBefore = new Date();
        Date notAfter = new Date(notBefore.getTime() + 315360000000L);
        try {
            publicKeyHash = KeyStoreUtils.sha1PublicKey(keyPair.getPublic());
        }
        catch (NoSuchAlgorithmException ignore) {
            throw new CertificateException("can not build self signed certificate.");
        }
        X500Name certDN = new X500Name(subjectDN != null ? subjectDN : "CN=" + Hex.encodeHexString((byte[])publicKeyHash));
        X509v3CertificateBuilder builder = new X509v3CertificateBuilder(certDN, new BigInteger(publicKeyHash), notBefore, notAfter, certDN, SubjectPublicKeyInfo.getInstance((Object)keyPair.getPublic().getEncoded()));
        builder.addExtension(X509Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(false));
        int keyUsage = 246;
        builder.addExtension(X509Extension.keyUsage, true, (ASN1Encodable)new KeyUsage(keyUsage));
        Vector<KeyPurposeId> extendedKeyUsages = new Vector<KeyPurposeId>();
        extendedKeyUsages.add(KeyPurposeId.id_kp_serverAuth);
        extendedKeyUsages.add(KeyPurposeId.id_kp_clientAuth);
        extendedKeyUsages.add(new KeyPurposeId("1.3.6.1.4.1.311.10.3.3"));
        extendedKeyUsages.add(new KeyPurposeId("2.16.840.1.113730.4.1"));
        builder.addExtension(X509Extension.extendedKeyUsage, false, (ASN1Encodable)new ExtendedKeyUsage(extendedKeyUsages));
        String signAlg = keyPair.getPrivate().getAlgorithm().equals("SM2") ? "SM3withSM2" : "SHA1with" + keyPair.getPrivate().getAlgorithm();
        JcaContentSignerBuilder signerBuilder = new JcaContentSignerBuilder(signAlg);
        try {
            if (provider != null) {
                signerBuilder.setProvider(provider);
            }
            signer = signerBuilder.build(keyPair.getPrivate());
        }
        catch (OperatorCreationException ignore) {
            throw new Error(ignore);
        }
        X509CertificateHolder holder = builder.build(signer);
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        byte[] encoded = holder.getEncoded();
        Certificate cert = factory.generateCertificate(new ByteArrayInputStream(encoded));
        return cert;
    }

    public static byte[] sha1PublicKey(PublicKey publicKey) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
        byte[] sha1 = messageDigest.digest(publicKey.getEncoded());
        return sha1;
    }

    public static boolean isSoftKeyStore(KeyStore keyStore) {
        return KeyStoreUtils.isSoftKeyStore(keyStore.getType());
    }

    public static boolean isSoftKeyStore(String keyStoreAlg) {
        return softKeyStoreAlg.contains(keyStoreAlg);
    }

    static {
        softKeyStoreAlg.add("JKS");
        softKeyStoreAlg.add("PKCS12");
    }
}

