/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.crypto;

import cn.topca.crypto.JCEAgentUtils;
import cn.topca.security.JCAJCEUtils;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;

public class KeyGenerator {
    private final Provider provider;
    private final KeyGeneratorSpi spi;
    private final String algorithm;
    private final javax.crypto.KeyGenerator jceService;

    public KeyGenerator(javax.crypto.KeyGenerator keyGenerator) {
        this.spi = null;
        this.jceService = keyGenerator;
        this.algorithm = keyGenerator.getAlgorithm();
        this.provider = keyGenerator.getProvider();
    }

    protected KeyGenerator(KeyGeneratorSpi spi, Provider provider, String algorithm) {
        this.jceService = null;
        this.spi = spi;
        this.algorithm = algorithm;
        this.provider = provider;
    }

    public static KeyGenerator getInstance(String algorithm) throws NoSuchAlgorithmException {
        try {
            javax.crypto.KeyGenerator keyGenerator = javax.crypto.KeyGenerator.getInstance(algorithm);
            return new KeyGenerator(keyGenerator);
        }
        catch (Exception e) {
            Provider[] providers = Security.getProviders("KeyGenerator." + algorithm);
            if (providers != null && providers.length > 0) {
                return KeyGenerator.getInstance(algorithm, providers[0]);
            }
            throw new NoSuchAlgorithmException(algorithm + " KeyGenerator not available");
        }
    }

    public static KeyGenerator getInstance(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        try {
            javax.crypto.KeyGenerator keyGenerator = javax.crypto.KeyGenerator.getInstance(algorithm);
            return new KeyGenerator(keyGenerator);
        }
        catch (Exception e) {
            KeyGeneratorSpi spi = null;
            Provider.Service service = provider.getService("KeyGenerator", algorithm);
            if (service != null) {
                spi = (KeyGeneratorSpi)service.newInstance(null);
            }
            if (spi != null) {
                return new KeyGenerator(spi, provider, service.getAlgorithm());
            }
            throw new NoSuchAlgorithmException("no such " + algorithm + " for " + provider.getName());
        }
    }

    public static KeyGenerator getInstance(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        Provider p = Security.getProvider(provider);
        if (p == null) {
            throw new NoSuchProviderException(provider);
        }
        return KeyGenerator.getInstance(algorithm, p);
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final void init(SecureRandom random) {
        if (this.jceService != null) {
            this.jceService.init(random);
            return;
        }
        JCEAgentUtils.invokeSpi(this.spi, "engineInit", new Class[]{SecureRandom.class}, random);
    }

    public final void init(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        this.init(params, JCAJCEUtils.getSecureRandom());
    }

    public final void init(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (this.jceService != null) {
            this.jceService.init(params, random);
            return;
        }
        JCEAgentUtils.invokeSpi(this.spi, "engineInit", new Class[]{AlgorithmParameterSpec.class, SecureRandom.class}, params, random);
    }

    public final void init(int keysize) {
        this.init(keysize, JCAJCEUtils.getSecureRandom());
    }

    public final void init(int keysize, SecureRandom random) {
        if (this.jceService != null) {
            this.jceService.init(keysize, random);
            return;
        }
        JCEAgentUtils.invokeSpi(this.spi, "engineInit", new Class[]{Integer.TYPE, SecureRandom.class}, keysize, random);
    }

    public final SecretKey generateKey() {
        if (this.jceService != null) {
            return this.jceService.generateKey();
        }
        return (SecretKey)JCEAgentUtils.invokeSpi(this.spi, "engineGenerateKey", null, new Object[0]);
    }
}

