/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.security;

import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;

public final class JCAJCEUtils {
    private static final Object LOCK = JCAJCEUtils.class;
    private static volatile SecureRandom secureRandom;
    private static final int ARRAY_SIZE = 4096;

    private JCAJCEUtils() {
    }

    public static int getTempArraySize(int totalSize) {
        return Math.min(4096, totalSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SecureRandom getSecureRandom() {
        SecureRandom r = secureRandom;
        if (r == null) {
            Object object = LOCK;
            synchronized (object) {
                r = secureRandom;
                if (r == null) {
                    secureRandom = r = new SecureRandom();
                }
            }
        }
        return r;
    }

    public static boolean isGMAlgorithm(String algorithm) {
        return algorithm.startsWith("1.2.156.10197.1") || algorithm.toUpperCase().matches(".*SM[1-9]|SSF33");
    }

    public static boolean isValidIdentifier(String identifier) {
        if (identifier.length() < 3 || identifier.charAt(1) != '.') {
            return false;
        }
        char first = identifier.charAt(0);
        if (first < '0' || first > '2') {
            return false;
        }
        boolean periodAllowed = false;
        for (int i = identifier.length() - 1; i >= 2; --i) {
            char ch = identifier.charAt(i);
            if ('0' <= ch && ch <= '9') {
                periodAllowed = true;
                continue;
            }
            if (ch == '.') {
                if (!periodAllowed) {
                    return false;
                }
                periodAllowed = false;
                continue;
            }
            return false;
        }
        return periodAllowed;
    }

    public static void register(Provider provider, int position) {
        if (Security.getProvider(provider.getName()) == null) {
            if (position > 0) {
                Security.insertProviderAt(provider, position);
            } else {
                Security.addProvider(provider);
            }
        }
    }

    public static void register(Provider provider) {
        JCAJCEUtils.register(provider, -1);
    }
}

