/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.api.cert;

import cn.topca.api.cert.CertApiException;
import cn.topca.api.cert.DownloaderState;
import cn.topca.api.cert.TCADebugUtil;
import cn.topca.api.cert.TCAErrCode;
import cn.topca.api.cert.TCAUtil;
import cn.topca.security.x509.AlgorithmId;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Date;

class CRLDownloader
extends Thread {
    private String savePath;
    private String crlUrl;
    private X509CRL crl;
    private X509Certificate caCert;
    private int[] retryPolicyTime;
    private DownloaderState downloaderState = DownloaderState.DOWNLOADER_STATE_STOP;

    public DownloaderState getDownloaderState() {
        return this.downloaderState;
    }

    public X509CRL getCRL() {
        return this.crl;
    }

    private void setStateRunning() {
        TCADebugUtil.debugLog("setStateRuning");
        this.downloaderState = DownloaderState.DOWNLOADER_STATE_RUNNING;
    }

    private void setStateStop() {
        TCADebugUtil.debugLog("setStateStop");
        this.downloaderState = DownloaderState.DOWNLOADER_STATE_STOP;
    }

    private void setStateWaiting() {
        TCADebugUtil.debugLog("setStateWaiting");
        this.downloaderState = DownloaderState.DOWNLOADER_STATE_WAITING;
    }

    private void setStateError() {
        TCADebugUtil.debugLog("setStateError");
        this.downloaderState = DownloaderState.DOWNLOADER_STATE_ERROR;
    }

    public CRLDownloader(X509Certificate caCert, String filePath, String crlUrl, int[] retryPolicyTime) {
        this.caCert = caCert;
        this.savePath = filePath;
        this.crlUrl = crlUrl;
        this.retryPolicyTime = retryPolicyTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            try {
                while (true) {
                    long nextTime;
                    X509CRL crl;
                    if ((crl = this.runTask(this.crlUrl, this.savePath, this.retryPolicyTime)) == null) {
                        nextTime = this.retryPolicyTime[this.retryPolicyTime.length - 1] * 1000;
                        TCADebugUtil.debugLog("runTask ERROR waiting " + nextTime);
                    } else {
                        this.crl = crl;
                        nextTime = this.crl.getNextUpdate().getTime() - new Date().getTime();
                        TCADebugUtil.debugLog("runTask SUCCESS waiting " + nextTime);
                    }
                    this.setStateWaiting();
                    Thread.sleep(nextTime);
                }
            }
            catch (InterruptedException e) {
                this.setStateError();
                e.printStackTrace();
                this.setStateStop();
            }
        }
        catch (Throwable throwable) {
            this.setStateStop();
            throw throwable;
        }
    }

    private X509CRL runTask(String url, String savePath, int[] retryPolicyTime) throws InterruptedException {
        TCADebugUtil.debugLog("runTask");
        for (int itRetryPolicyTime : retryPolicyTime) {
            this.setStateRunning();
            try {
                X509CRL crl = this.downloadCRL(url);
                if (this.verifyCRL(crl, this.caCert, new Date()) && TCAUtil.writeByte2File(crl.getEncoded(), savePath)) {
                    TCADebugUtil.debugLog("runTask SUCCESS Exit");
                    return crl;
                }
            }
            catch (CertApiException e) {
                e.printStackTrace();
            }
            catch (CRLException e) {
                e.printStackTrace();
            }
            this.setStateWaiting();
            Thread.sleep(itRetryPolicyTime * 1000);
        }
        TCADebugUtil.debugLog("runTask ERROR Exit");
        return null;
    }

    private X509CRL downloadCRL(String url) throws CertApiException {
        byte[] data = TCAUtil.readURL2Byte(url);
        if (data[0] == 77 || data[0] == 45) {
            return TCAUtil.convB642CRL(new String(data));
        }
        return TCAUtil.convBin2CRL(data);
    }

    private boolean verifyCRL(X509CRL crl, X509Certificate caCert, Date date) throws CertApiException {
        if (date.before(crl.getThisUpdate()) || date.after(crl.getNextUpdate())) {
            throw new CertApiException(TCAErrCode.ERR_CRL_OUTDATE);
        }
        try {
            if (crl.getSigAlgOID().equals(AlgorithmId.SM3withSM2_oid.toString())) {
                Signature signature = Signature.getInstance("SM3withSM2", Security.getProvider("TopSM"));
                signature.initVerify(caCert.getPublicKey());
                signature.update(crl.getTBSCertList());
                signature.verify(crl.getSignature());
            } else {
                crl.verify(caCert.getPublicKey());
            }
            TCADebugUtil.debugLog("verify CRL SUCCESS");
            boolean signature = true;
            return signature;
        }
        catch (NoSuchProviderException e) {
            throw new CertApiException(TCAErrCode.ERR_BAD_PROVIDER, (Throwable)e);
        }
        catch (InvalidKeyException e) {
            throw new CertApiException(TCAErrCode.ERR_INVALID_KEY, (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CertApiException(TCAErrCode.ERR_UNKNOWN_ALG, (Throwable)e);
        }
        catch (CRLException e) {
            throw new CertApiException(TCAErrCode.ERR_CRL, (Throwable)e);
        }
        catch (SignatureException e) {
            throw new CertApiException(TCAErrCode.ERR_CERT_SIGNATRUE, (Throwable)e);
        }
        finally {
            TCADebugUtil.debugLog("verify CRL ERROR");
        }
    }
}

