/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.api.cert;

import cn.tca.TopBasicCrypto.asn1.ASN1ObjectIdentifier;
import cn.tca.TopBasicCrypto.cms.CMSAlgorithm;
import cn.tca.TopBasicCrypto.cms.CMSException;
import cn.topca.api.cert.CertApiException;
import cn.topca.api.cert.Certificate;
import cn.topca.api.cert.TCAErrCode;
import cn.topca.api.cert.TCAUtil;
import cn.topca.core.ext.bc.cms.CMSEnvelopedData;
import cn.topca.core.ext.bc.cms.CMSOperatorUtils;
import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CertSet {
    private List<Certificate> certSet = new ArrayList<Certificate>();
    private static final Map<String, Integer> _keyUsageMap = new HashMap<String, Integer>();

    public CertSet(String[] b64CertArr) throws CertApiException {
        for (String b64Cert : b64CertArr) {
            this.certSet.add(new Certificate(b64Cert));
        }
    }

    public CertSet(Certificate[] certs) {
        Collections.addAll(this.certSet, certs);
    }

    private CertSet() {
    }

    public int size() {
        return this.certSet.size();
    }

    public Certificate get(int index) {
        return this.certSet.get(index);
    }

    public CertSet forSign() throws CertApiException {
        return this.byKeyUsage(128);
    }

    public CertSet forEncrypt() throws CertApiException {
        return this.byKeyUsage(32);
    }

    public CertSet byKeyUsage(int keyUsage) throws CertApiException {
        if (keyUsage == 0) {
            return new CertSet();
        }
        ArrayList<Certificate> list = new ArrayList<Certificate>();
        for (int i = 0; i < this.certSet.size(); ++i) {
            Certificate cert = this.get(i);
            int certKeyUsage = this.keyUsageStrArr2int(cert.keyUsage());
            if ((certKeyUsage & keyUsage) != keyUsage) continue;
            list.add(cert);
        }
        return list.size() == 0 ? new CertSet() : new CertSet(list.toArray(new Certificate[list.size()]));
    }

    public CertSet byKeyUsage(String[] keyUsageStrArr) throws CertApiException {
        return this.byKeyUsage(this.keyUsageStrArr2int(keyUsageStrArr));
    }

    public CertSet byValidity(Date date) {
        ArrayList<Certificate> list = new ArrayList<Certificate>();
        for (Certificate cert : this.certSet) {
            Date notAfter = cert.notAfter();
            Date notBefore = cert.notBefore();
            if (!notBefore.before(date) || !notAfter.after(date)) continue;
            list.add(cert);
        }
        return list.size() == 0 ? new CertSet() : new CertSet(list.toArray(new Certificate[list.size()]));
    }

    public CertSet byValidity() {
        return this.byValidity(new Date());
    }

    public CertSet byIssuer(String regex) {
        ArrayList<Certificate> list = new ArrayList<Certificate>();
        for (int i = 0; i < this.certSet.size(); ++i) {
            Certificate cert = this.get(i);
            if (!cert.issuer().matches(regex)) continue;
            list.add(cert);
        }
        return list.size() == 0 ? new CertSet() : new CertSet(list.toArray(new Certificate[list.size()]));
    }

    public CertSet bySubject(String regex) {
        ArrayList<Certificate> list = new ArrayList<Certificate>();
        for (int i = 0; i < this.certSet.size(); ++i) {
            Certificate cert = this.get(i);
            if (!cert.subject().matches(regex)) continue;
            list.add(cert);
        }
        return list.size() == 0 ? new CertSet() : new CertSet(list.toArray(new Certificate[list.size()]));
    }

    public CertSet bySerialnumber(String serialNumber) {
        ArrayList<Certificate> list = new ArrayList<Certificate>();
        for (int i = 0; i < this.certSet.size(); ++i) {
            Certificate cert = this.get(i);
            if (!cert.serialNumber().equalsIgnoreCase(serialNumber)) continue;
            list.add(cert);
        }
        return list.size() == 0 ? new CertSet() : new CertSet(list.toArray(new Certificate[list.size()]));
    }

    public byte[] encryptMessage(byte[] plain) throws CertApiException {
        ASN1ObjectIdentifier encryptionAlg = CMSAlgorithm.DES_EDE3_CBC;
        java.security.cert.Certificate[] certificates = new java.security.cert.Certificate[this.certSet.size()];
        for (int i = 0; i < this.certSet.size(); ++i) {
            certificates[i] = TCAUtil.convB64Str2Cert(this.certSet.get(i).toBase64());
        }
        try {
            CMSEnvelopedData cmsEnvelopedData = CMSOperatorUtils.generateEnvelopedDatas((byte[])plain, (java.security.cert.Certificate[])certificates, (ASN1ObjectIdentifier)encryptionAlg, (boolean)false);
            return cmsEnvelopedData.getEncoded();
        }
        catch (CertificateEncodingException e) {
            throw new CertApiException(TCAErrCode.ERR_ENCODECERT, (Throwable)e);
        }
        catch (CMSException e) {
            throw new CertApiException(TCAErrCode.ERR_GENERATE_ENVELOPDATA, (Throwable)e);
        }
        catch (IOException e) {
            throw new CertApiException(TCAErrCode.ERR_STREAM, (Throwable)e);
        }
    }

    private int keyUsageStrArr2int(String[] keyUsageArr) throws CertApiException {
        int ret = 0;
        for (String s : keyUsageArr) {
            if (_keyUsageMap.get(s) != null) {
                ret |= _keyUsageMap.get(s).intValue();
                continue;
            }
            throw new CertApiException(TCAErrCode.ERR_NOTFIND_KEYUSAGE);
        }
        return ret;
    }

    static {
        _keyUsageMap.put("digitalSignature", 128);
        _keyUsageMap.put("nonRepudiation", 64);
        _keyUsageMap.put("keyEncipherment", 32);
        _keyUsageMap.put("dataEncipherment", 16);
        _keyUsageMap.put("keyAgreement", 8);
        _keyUsageMap.put("keyCertSign", 4);
        _keyUsageMap.put("cRLSign", 2);
        _keyUsageMap.put("encipherOnly", 1);
        _keyUsageMap.put("decipherOnly", 32768);
        _keyUsageMap.put("contentCommitment", 64);
    }
}

