/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.api.cert;

import cn.topca.api.cert.CertApiException;
import cn.topca.api.cert.CertSet;
import cn.topca.api.cert.Certificate;
import cn.topca.api.cert.Csr;
import cn.topca.api.cert.KeyStoreMgr;
import cn.topca.api.cert.LicenseMgr;
import cn.topca.api.cert.TCAErrCode;
import cn.topca.api.cert.TCAUtil;
import java.io.ByteArrayInputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CertStore {
    private static LicenseMgr licMgr = LicenseMgr.getInstance();
    private static KeyStoreMgr keyMgr = KeyStoreMgr.getInstance();
    private String certStoreName = null;

    private CertStore(String certStoreName) {
        this.certStoreName = certStoreName;
    }

    public static CertSet listAllCerts() throws CertApiException {
        String[] names;
        ArrayList<Certificate> retList = new ArrayList<Certificate>();
        for (String name : names = CertStore.listStore()) {
            List<Certificate> tmpList = CertStore.doListCerts(name);
            retList.addAll(tmpList);
        }
        return new CertSet(retList.toArray(new Certificate[retList.size()]));
    }

    public static String[] listStore() {
        return keyMgr.listStoreNames();
    }

    public static CertStore byName(String certStoreName) throws CertApiException {
        String[] names;
        for (String name : names = CertStore.listStore()) {
            if (!name.equalsIgnoreCase(certStoreName)) continue;
            return new CertStore(certStoreName);
        }
        throw new CertApiException(TCAErrCode.ERR_NOTFIND_CERTSTORE);
    }

    public static CertStore byCert(Certificate cert) throws CertApiException {
        String[] names;
        String certSN = cert.serialNumber();
        for (String name : names = CertStore.listStore()) {
            java.security.cert.Certificate[] certs;
            for (java.security.cert.Certificate c : certs = keyMgr.listCert(name)) {
                Certificate tmp;
                try {
                    tmp = new Certificate(c.getEncoded());
                }
                catch (CertificateEncodingException e) {
                    throw new CertApiException(TCAErrCode.ERR_ENCODECERT, (Throwable)e);
                }
                if (!tmp.serialNumber().equalsIgnoreCase(certSN)) continue;
                return new CertStore(name);
            }
        }
        throw new CertApiException(TCAErrCode.ERR_NOTFIND_CERTSTORE);
    }

    public static Certificate installCert(String b64Cert) throws CertApiException {
        byte[] certData = TCAUtil.decode(b64Cert);
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream bis = new ByteArrayInputStream(certData);
            java.security.cert.Certificate c = cf.generateCertificate(bis);
            if (keyMgr.importCert(c, true)) {
                return new Certificate(b64Cert);
            }
        }
        catch (CertificateException e) {
            throw new CertApiException(TCAErrCode.ERR_CONV_CERT, (Throwable)e);
        }
        return null;
    }

    public static Certificate installCert(String b64SignCert, String b64EncCert, String encPrivateKey) throws CertApiException {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream bis = new ByteArrayInputStream(TCAUtil.decode(b64SignCert));
            java.security.cert.Certificate signCert = cf.generateCertificate(bis);
            String name = keyMgr.findNameByCert(signCert);
            PrivateKey signPriKey = keyMgr.getPriKeyByCert(name, signCert);
            PrivateKey encPriKey = CertStore.decryptEncKey(encPrivateKey, signPriKey);
            bis = new ByteArrayInputStream(TCAUtil.decode(b64EncCert));
            java.security.cert.Certificate encCert = cf.generateCertificate(bis);
            PublicKey encPubKey = encCert.getPublicKey();
            KeyPair keyPair = new KeyPair(encPubKey, encPriKey);
            if (keyMgr.importCertAndKey(name, encCert, keyPair)) {
                return new Certificate(encCert.getEncoded());
            }
        }
        catch (CertificateException e) {
            throw new CertApiException(TCAErrCode.ERR_CONV_CERT, (Throwable)e);
        }
        return null;
    }

    public CertSet listCerts() throws CertApiException {
        List<Certificate> retList = CertStore.doListCerts(this.certStoreName);
        return new CertSet(retList.toArray(new Certificate[retList.size()]));
    }

    public Csr genCsr() throws CertApiException {
        return this.genCsr("SM2", "CN=topca");
    }

    public Csr genCsr(String keyAlg) throws CertApiException {
        return this.genCsr(keyAlg, "CN=topca");
    }

    public Csr genCsr(String keyAlg, String subject) throws CertApiException {
        String hashAlg = "SM3";
        String Alg = "SM2";
        int size = 256;
        if (keyAlg.equalsIgnoreCase("SM2")) {
            Alg = "SM2";
            hashAlg = "SM3";
            size = 256;
        } else if (keyAlg.equalsIgnoreCase("RSA1024")) {
            Alg = "RSA";
            hashAlg = "SHA1";
            size = 1024;
        } else if (keyAlg.equalsIgnoreCase("RSA2048")) {
            Alg = "RSA";
            hashAlg = "SHA1";
            size = 2048;
        }
        return new Csr(keyMgr.genCSR(this.certStoreName, subject, Alg, size, hashAlg));
    }

    public Csr genCsr(Certificate cert) throws CertApiException {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream bis = new ByteArrayInputStream(TCAUtil.decode(cert.toBase64()));
            java.security.cert.Certificate c = cf.generateCertificate(bis);
            return new Csr(keyMgr.genCSR(this.certStoreName, c));
        }
        catch (CertificateException e) {
            throw new CertApiException(TCAErrCode.ERR_CONV_CERT, (Throwable)e);
        }
    }

    private static PrivateKey decryptEncKey(String encPriKeyParams, PrivateKey signCertKey) throws CertApiException {
        SecretKeySpec symmKey;
        Cipher cipher;
        String signCertAlg;
        String[] EncPriKeyArr = encPriKeyParams.split("&");
        String encPriKey = "";
        String userSeal = "";
        String userCipher = "";
        String userIV = "";
        for (String it : EncPriKeyArr) {
            String tmp = it.substring(it.indexOf("="), it.length());
            if (it.indexOf("encPrivateKeyUser=") == 0) {
                encPriKey = tmp;
                continue;
            }
            if (it.indexOf("userSeal=") == 0) {
                userSeal = tmp;
                continue;
            }
            if (it.indexOf("userCipher") == 0) {
                userCipher = tmp;
                continue;
            }
            if (it.indexOf("userIV") != 0) continue;
            userIV = tmp;
        }
        try {
            signCertAlg = signCertKey.getAlgorithm().equalsIgnoreCase("RSA") ? "RSA/ECB/PKCS1Padding" : "SM2";
            cipher = Cipher.getInstance(signCertAlg);
            cipher.init(2, signCertKey);
            byte[] symmetricKeyBuffer = cipher.doFinal(TCAUtil.decode(userSeal));
            symmKey = new SecretKeySpec(symmetricKeyBuffer, userCipher);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CertApiException(TCAErrCode.ERR_UNKNOWN_ALG, (Throwable)e);
        }
        catch (NoSuchPaddingException e) {
            throw new CertApiException(TCAErrCode.ERR_UNKNOWN_PADDING, (Throwable)e);
        }
        catch (InvalidKeyException e) {
            throw new CertApiException(TCAErrCode.ERR_INVALID_KEY, (Throwable)e);
        }
        catch (BadPaddingException e) {
            throw new CertApiException(TCAErrCode.ERR_BAD_PADDING, (Throwable)e);
        }
        catch (IllegalBlockSizeException e) {
            throw new CertApiException(TCAErrCode.ERR_ILLEGAL_BLOCK, (Throwable)e);
        }
        try {
            String alg = userCipher.toUpperCase().equals("AES") ? userCipher + "/CBC/PKCS5Padding" : (userCipher.toUpperCase().equals("DES") ? userCipher + "/CBC/PKCS5Padding" : (userCipher.toUpperCase().equals("DESEDE") ? userCipher + "/ECB/PKCS5Padding" : userCipher));
            cipher = Cipher.getInstance(alg);
            if (alg.toUpperCase().contains("ECB")) {
                cipher.init(2, symmKey);
            } else {
                cipher.init(2, (Key)symmKey, new IvParameterSpec(TCAUtil.decode(userIV)));
            }
            byte[] enckeyData = cipher.doFinal(TCAUtil.decode(encPriKey));
            KeyFactory keyFactory = KeyFactory.getInstance(signCertAlg);
            return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(enckeyData));
        }
        catch (NoSuchAlgorithmException e) {
            throw new CertApiException(TCAErrCode.ERR_UNKNOWN_ALG, (Throwable)e);
        }
        catch (NoSuchPaddingException e) {
            throw new CertApiException(TCAErrCode.ERR_UNKNOWN_PADDING, (Throwable)e);
        }
        catch (InvalidKeyException e) {
            throw new CertApiException(TCAErrCode.ERR_INVALID_KEY, (Throwable)e);
        }
        catch (BadPaddingException e) {
            throw new CertApiException(TCAErrCode.ERR_BAD_PADDING, (Throwable)e);
        }
        catch (IllegalBlockSizeException e) {
            throw new CertApiException(TCAErrCode.ERR_ILLEGAL_BLOCK, (Throwable)e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new CertApiException(TCAErrCode.ERR_INVALID_ALGPARAMET, (Throwable)e);
        }
        catch (InvalidKeySpecException e) {
            throw new CertApiException(TCAErrCode.ERR_INVALID_KEYSPEC, (Throwable)e);
        }
    }

    private static List<Certificate> doListCerts(String certStoreName) throws CertApiException {
        java.security.cert.Certificate[] certs;
        LinkedList<Certificate> retList = new LinkedList<Certificate>();
        for (java.security.cert.Certificate cert : certs = keyMgr.listCert(certStoreName)) {
            try {
                if (!licMgr.certWithLicense(cert)) continue;
                Certificate tmp = new Certificate(cert.getEncoded());
                retList.add(tmp);
            }
            catch (CertificateEncodingException e) {
                throw new CertApiException(TCAErrCode.ERR_ENCODECERT, (Throwable)e);
            }
        }
        return retList;
    }
}

