/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.api.cert;

import cn.tca.TopBasicCrypto.asn1.pkcs.CertificationRequest;
import cn.topca.api.cert.CertApiException;
import cn.topca.api.cert.TCAErrCode;
import cn.topca.api.cert.TCAUtil;
import java.io.IOException;

public class Csr {
    private CertificationRequest csr;
    private static final String h1 = "-----BEGIN CERTIFICATE-----";
    private static final String e1 = "-----END CERTIFICATE-----";
    private static final String h2 = "-----BEGIN NEW CERTIFICATE REQUEST-----";
    private static final String e2 = "-----END NEW CERTIFICATE REQUEST-----";

    public Csr(String b64Str) throws CertApiException {
        if (b64Str.contains(h1) || b64Str.contains(h2)) {
            b64Str = b64Str.replaceAll(h1, "").replaceAll(e1, "").replaceAll(h2, "").replaceAll(e2, "").replaceAll("\r", "").replaceAll("\n", "");
        }
        this.csr = CertificationRequest.getInstance((Object)TCAUtil.decode(b64Str));
    }

    public String subject() {
        return this.csr.getCertificationRequestInfo().getSubject().toString();
    }

    public String toPem() throws CertApiException {
        try {
            String b64Str = TCAUtil.encode(this.csr.getEncoded());
            String ret = "-----BEGIN CERTIFICATE-----\n";
            for (int i = 0; i < b64Str.length() / 64; ++i) {
                ret = ret + b64Str.substring(i * 64, i * 64 + 64) + "\n";
            }
            return ret + e1;
        }
        catch (Exception e) {
            throw new CertApiException(TCAErrCode.ERR_CERT_CSRTOPEM, (Throwable)e);
        }
    }

    public String toBase64() throws CertApiException {
        try {
            return TCAUtil.encode(this.csr.getEncoded());
        }
        catch (IOException e) {
            throw new CertApiException(TCAErrCode.ERR_CERT_ENCODING, (Throwable)e);
        }
    }
}

