/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.api.cert;

import cn.tca.TopBasicCrypto.asn1.DERObjectIdentifier;
import cn.tca.TopBasicCrypto.asn1.ocsp.OCSPObjectIdentifiers;
import cn.tca.TopBasicCrypto.asn1.x509.AlgorithmIdentifier;
import cn.tca.TopBasicCrypto.asn1.x509.X509ExtensionsGenerator;
import cn.tca.TopBasicCrypto.cert.X509CertificateHolder;
import cn.tca.TopBasicCrypto.cert.ocsp.BasicOCSPResp;
import cn.tca.TopBasicCrypto.cert.ocsp.CertificateID;
import cn.tca.TopBasicCrypto.cert.ocsp.CertificateStatus;
import cn.tca.TopBasicCrypto.cert.ocsp.OCSPException;
import cn.tca.TopBasicCrypto.cert.ocsp.OCSPReqBuilder;
import cn.tca.TopBasicCrypto.cert.ocsp.OCSPResp;
import cn.tca.TopBasicCrypto.cert.ocsp.RevokedStatus;
import cn.tca.TopBasicCrypto.cert.ocsp.SingleResp;
import cn.tca.TopBasicCrypto.cert.ocsp.UnknownStatus;
import cn.tca.TopBasicCrypto.operator.ContentVerifier;
import cn.tca.TopBasicCrypto.operator.ContentVerifierProvider;
import cn.topca.api.cert.BaseVerifier;
import cn.topca.api.cert.CertApiException;
import cn.topca.api.cert.IVerifierProvider;
import cn.topca.api.cert.TCACertID;
import cn.topca.api.cert.TCAErrCode;
import cn.topca.api.cert.TCAUtil;
import cn.topca.api.cert.VerifierConfig;
import cn.topca.security.x509.AlgorithmId;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OCSPVerifyProvider
extends BaseVerifier
implements IVerifierProvider {
    private X509Certificate caCert = null;
    private boolean checkRovke = false;
    private String ocspUrl;

    OCSPVerifyProvider() {
    }

    @Override
    public boolean config(Map<String, String> config) {
        return false;
    }

    @Override
    public boolean config(VerifierConfig config) {
        this.caCert = config.getCaCert();
        this.ocspUrl = config.getOcspUrl();
        this.checkRovke = config.isCheckRevoke();
        return true;
    }

    @Override
    public boolean verify(X509Certificate cert, Date date) throws CertApiException {
        super.verifyCert(cert, this.caCert, date);
        if (!this.checkRovke) {
            return true;
        }
        byte[] nonce = this.genNonce(16);
        byte[] req = this.genReq(cert, this.caCert, nonce);
        byte[] resp = this.doRequest(req, this.ocspUrl);
        return this.handleRep(resp, nonce);
    }

    @Override
    public boolean test() {
        return false;
    }

    private byte[] genNonce(int byteLen) {
        Random r = new Random();
        byte[] ret = new byte[byteLen];
        r.nextBytes(ret);
        return ret;
    }

    private byte[] genReq(X509Certificate cert, X509Certificate caCert, byte[] nonce) throws CertApiException {
        X509ExtensionsGenerator x509ExtGenerator = new X509ExtensionsGenerator();
        x509ExtGenerator.addExtension((DERObjectIdentifier)OCSPObjectIdentifiers.id_pkix_ocsp_nonce, false, nonce);
        OCSPReqBuilder ocspReqBuilder = new OCSPReqBuilder().setRequestExtensions(x509ExtGenerator.generate());
        try {
            TCACertID certID = new TCACertID(AlgorithmId.get((String)"SHA1"), caCert.getIssuerX500Principal().getEncoded(), caCert.getPublicKey().getEncoded(), cert.getSerialNumber());
            ocspReqBuilder.addRequest(new CertificateID(certID.toASN1Object()));
            return ocspReqBuilder.build().getEncoded();
        }
        catch (NoSuchAlgorithmException e) {
            throw new CertApiException(TCAErrCode.ERR_UNKNOWN_ALG, (Throwable)e);
        }
        catch (OCSPException e) {
            throw new CertApiException(TCAErrCode.ERR_OCSP_GENREQUEST, (Throwable)e);
        }
        catch (IOException e) {
            throw new CertApiException(TCAErrCode.ERR_STREAM, (Throwable)e);
        }
    }

    private byte[] doRequest(byte[] req, String url) throws CertApiException {
        HttpURLConnection httpConn;
        try {
            URL dstUrl = new URL(url);
            httpConn = (HttpURLConnection)dstUrl.openConnection();
            httpConn.setDoOutput(true);
            httpConn.setRequestMethod("POST");
            httpConn.setRequestProperty("Content-Type", "application/ocsp-request");
            httpConn.connect();
            OutputStream os = httpConn.getOutputStream();
            os.write(req);
            os.flush();
            os.close();
        }
        catch (MalformedURLException e) {
            throw new CertApiException(TCAErrCode.ERR_BAD_URL, (Throwable)e);
        }
        catch (ProtocolException e) {
            throw new CertApiException(TCAErrCode.ERR_UNKNOWN, (Throwable)e);
        }
        catch (IOException e) {
            throw new CertApiException(TCAErrCode.ERR_STREAM, (Throwable)e);
        }
        try {
            if (httpConn.getResponseCode() != 200) {
                throw new CertApiException(TCAErrCode.ERR_UNKNOWN);
            }
            InputStream inputStream = httpConn.getInputStream();
            return TCAUtil.readIS2Byte(inputStream);
        }
        catch (IOException e) {
            throw new CertApiException(TCAErrCode.ERR_STREAM, (Throwable)e);
        }
    }

    private boolean handleRep(byte[] resp, byte[] nonce) throws CertApiException {
        OCSPResp ocspResp;
        try {
            ocspResp = new OCSPResp(resp);
        }
        catch (IOException e) {
            throw new CertApiException(TCAErrCode.ERR_STREAM, (Throwable)e);
        }
        switch (ocspResp.getStatus()) {
            case 0: {
                BasicOCSPResp response;
                try {
                    response = (BasicOCSPResp)ocspResp.getResponseObject();
                }
                catch (OCSPException e) {
                    throw new CertApiException(TCAErrCode.ERR_OCSP_GENREQUEST, (Throwable)e);
                }
                byte[] retNonce = response.getExtension(OCSPObjectIdentifiers.id_pkix_ocsp_nonce).getValue().getOctets();
                if (retNonce == null) {
                    throw new CertApiException(TCAErrCode.ERR_NOFOUND_NONCE);
                }
                if (!Arrays.equals(nonce, retNonce)) {
                    throw new CertApiException(TCAErrCode.ERR_BAD_NONCE);
                }
                if (response.getSignature() != null) {
                    ContentVerifierProvider verifyProv = this.getContentVerifyProvider(response.getCerts());
                    try {
                        response.isSignatureValid(verifyProv);
                    }
                    catch (OCSPException e) {
                        throw new CertApiException(TCAErrCode.ERR_CERT_BADSIGN, (Throwable)e);
                    }
                }
                for (SingleResp singleResp : response.getResponses()) {
                    CertificateStatus certStatus = singleResp.getCertStatus();
                    if (certStatus == null) {
                        return true;
                    }
                    if (certStatus instanceof UnknownStatus) {
                        throw new CertApiException(TCAErrCode.ERR_CERT_UNKNOWSTATU);
                    }
                    if (!(certStatus instanceof RevokedStatus)) continue;
                    throw new CertApiException(TCAErrCode.ERR_CERT_NOTYETVALID);
                }
                throw new CertApiException(TCAErrCode.ERR_CERT_UNKNOWSTATU);
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                throw new CertApiException(TCAErrCode.ERR_OCSP_BAD_GEN);
            }
        }
        throw new CertApiException(TCAErrCode.ERR_OCSP_UNKNOWSTATU);
    }

    private ContentVerifierProvider getContentVerifyProvider(final X509CertificateHolder[] certificateHolders) {
        return new ContentVerifierProvider(){

            public ContentVerifier get(AlgorithmIdentifier verifierAlgorithmIdentifier) {
                if (certificateHolders.length > 0) {
                    try {
                        return OCSPVerifyProvider.this.getContentVerifier(TCAUtil.convBin2Cert(certificateHolders[0].getEncoded()));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    catch (CertApiException e) {
                        e.printStackTrace();
                    }
                }
                return null;
            }

            public boolean hasAssociatedCertificate() {
                return certificateHolders.length > 0;
            }

            public X509CertificateHolder getAssociatedCertificate() {
                return certificateHolders.length > 0 ? certificateHolders[0] : null;
            }
        };
    }

    private ContentVerifier getContentVerifier(final X509Certificate certificate) {
        return new ContentVerifier(){
            private ByteArrayOutputStream stream = new ByteArrayOutputStream();

            public OutputStream getOutputStream() {
                return this.stream;
            }

            public boolean verify(byte[] signedData) {
                byte[] toSign = this.stream.toByteArray();
                String algorithm = certificate.getPublicKey().getAlgorithm();
                String signAlgorithm = "SHA1withRSA";
                if (algorithm.equalsIgnoreCase("SM2") || algorithm.equals(AlgorithmId.SM2_oid.toString())) {
                    signAlgorithm = "SM3withSM2";
                }
                try {
                    Signature signature = Signature.getInstance(signAlgorithm);
                    PublicKey publicKey = certificate.getPublicKey();
                    signature.initVerify(publicKey);
                    signature.update(toSign);
                    return signature.verify(signedData);
                }
                catch (NoSuchAlgorithmException e) {
                    e.printStackTrace();
                }
                catch (InvalidKeyException e) {
                    e.printStackTrace();
                }
                catch (SignatureException e) {
                    e.printStackTrace();
                }
                return false;
            }

            public AlgorithmIdentifier getAlgorithmIdentifier() {
                String algorithm = certificate.getPublicKey().getAlgorithm();
                if (algorithm.equalsIgnoreCase("SM2") || algorithm.equals(AlgorithmId.SM2_oid.toString())) {
                    return new AlgorithmIdentifier(new DERObjectIdentifier(AlgorithmId.SM3withSM2_oid.toString()));
                }
                return new AlgorithmIdentifier(new DERObjectIdentifier(AlgorithmId.sha1WithRSAEncryption_oid.toString()));
            }
        };
    }
}

