/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.api.cert;

import cn.topca.api.cert.CertApiException;
import cn.topca.api.cert.ConfigMgr;
import cn.topca.api.cert.KeyStoreConfig;
import cn.topca.api.cert.KeyStoreMgr;
import cn.topca.api.cert.LicenseMgr;
import cn.topca.api.cert.VerifierConfig;
import cn.topca.api.cert.VerifierMgr;
import cn.topca.security.sm.TopSMProvider;
import java.security.Provider;
import java.security.Security;
import java.util.List;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class TCA {
    public static final int digitalSignature = 128;
    public static final int nonRepudiation = 64;
    public static final int keyEncipherment = 32;
    public static final int dataEncipherment = 16;
    public static final int keyAgreement = 8;
    public static final int keyCertSign = 4;
    public static final int cRLSign = 2;
    public static final int encipherOnly = 1;
    public static final int decipherOnly = 32768;
    public static final int contentCommitment = 64;
    public static final String SM2 = "SM2";
    public static final String RSA1024 = "RSA1024";
    public static final String RSA2048 = "RSA2048";
    public static final String SM1 = "SM1";
    public static final String SM4 = "SM4";
    public static final String DES = "DES";
    public static final String DESEDE = "3DES";
    public static final String DES3 = "3DES";
    public static final String AES = "AES";
    public static final String SHA1 = "SHA1";
    public static final String MD5 = "MD5";
    public static final String SM3 = "SM3";
    public static final String SHA256 = "SHA256";
    public static final String serverAuth = "1.3.6.1.5.5.7.3.1";
    public static final String clientAuth = "1.3.6.1.5.5.7.3.2";
    public static final String codeSigning = "1.3.6.1.5.5.7.3.3";
    public static final String emailProtection = "1.3.6.1.5.5.7.3.4";
    public static final String ipsecEndSystem = "1.3.6.1.5.5.7.3.5";
    public static final String ipsecTunnel = "1.3.6.1.5.5.7.3.6";
    public static final String ipsecUser = "1.3.6.1.5.5.7.3.7";
    public static final String timeStamping = "1.3.6.1.5.5.7.3.8";
    public static final String OCSPSigning = "1.3.6.1.5.5.7.3.9";
    public static final String dvcs = "1.3.6.1.5.5.7.3.10";
    public static final String sbgpCertAAServerAuth = "1.3.6.1.5.5.7.3.11";
    public static final String scvpResponder = "1.3.6.1.5.5.7.3.12";
    public static final String eapOverPPP = "1.3.6.1.5.5.7.3.13";
    public static final String eapOverLAN = "1.3.6.1.5.5.7.3.14";
    public static final String scvpServer = "1.3.6.1.5.5.7.3.15";
    public static final String scvpClient = "1.3.6.1.5.5.7.3.16";
    public static final String ipsecIKE = "1.3.6.1.5.5.7.3.17";
    public static final String capwapAC = "1.3.6.1.5.5.7.3.18";
    public static final String capwapWTP = "1.3.6.1.5.5.7.3.19";
    public static final String smartcardlogon = "1.3.6.1.4.1.311.20.2.2";
    public static final String softVersion = "3.1.0.0";
    public static final String licenseVersion = "1.0.0.0";

    public static void config(String config) throws CertApiException {
        ConfigMgr configMgr = ConfigMgr.getInstance();
        configMgr.init(config);
        List<KeyStoreConfig> keyStoreConfigs = configMgr.getKeyStoreConfigList();
        KeyStoreMgr.getInstance().init(keyStoreConfigs);
        List<VerifierConfig> verifierConfigs = configMgr.getVerifierConfigList();
        VerifierMgr.getInstance().init(verifierConfigs);
        String licenseStr = ConfigMgr.getInstance().getLicenseStr();
        LicenseMgr.getInstance().init(licenseStr);
    }

    static {
        Security.addProvider((Provider)TopSMProvider.INSTANCE);
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

