/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.api.cert;

import cn.tca.TopBasicCrypto.asn1.ASN1Object;
import cn.tca.TopBasicCrypto.asn1.cms.IssuerAndSerialNumber;
import cn.tca.TopBasicCrypto.asn1.cms.SignerIdentifier;
import cn.tca.TopBasicCrypto.asn1.x500.X500Name;
import cn.tca.TopBasicCrypto.asn1.x509.TBSCertificateStructure;
import cn.tca.TopBasicCrypto.cert.X509CRLHolder;
import cn.tca.TopBasicCrypto.cert.X509CertificateHolder;
import cn.tca.TopBasicCrypto.cms.CMSException;
import cn.tca.TopBasicCrypto.cms.CMSTypedData;
import cn.tca.TopBasicCrypto.operator.ContentSigner;
import cn.tca.TopBasicCrypto.operator.DigestCalculatorProvider;
import cn.tca.TopBasicCrypto.operator.OperatorCreationException;
import cn.tca.TopBasicCrypto.util.CollectionStore;
import cn.tca.TopBasicCrypto.util.Store;
import cn.topca.api.cert.CertApiException;
import cn.topca.api.cert.TCAErrCode;
import cn.topca.core.ext.bc.cms.CMSProcessableByteArray;
import cn.topca.core.ext.bc.cms.CMSSignedData;
import cn.topca.core.ext.bc.cms.CMSSignedDataGenerator;
import cn.topca.core.ext.bc.cms.SignerInfoGenerator;
import cn.topca.core.ext.bc.operator.jcajce.JcaContentSignerBuilder;
import cn.topca.core.ext.bc.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import cn.topca.security.sm.TopSMProvider;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TCAUtil {
    private static CertificateFactory cf = null;
    private static Provider sm2Provider;
    private static Provider bcProvider;

    private TCAUtil() {
    }

    public static Provider getBcProvider() {
        return bcProvider;
    }

    public static Provider getSm2Provider() {
        return sm2Provider;
    }

    public static X509Certificate convB64Str2Cert(String b64Str) throws CertApiException {
        b64Str = b64Str.replaceAll("-----BEGIN CERTIFICATE-----", "").replaceAll("-----END CERTIFICATE-----", "").replaceAll("\r", "").replaceAll("\n", "");
        return TCAUtil.convBin2Cert(Base64.decodeBase64((String)b64Str));
    }

    public static X509Certificate convBin2Cert(byte[] certData) throws CertApiException {
        try {
            if (cf == null) {
                cf = CertificateFactory.getInstance("X.509", sm2Provider);
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(certData);
            return (X509Certificate)cf.generateCertificate(bais);
        }
        catch (CertificateException e) {
            throw new CertApiException(TCAErrCode.ERR_CONV_CERT, (Throwable)e);
        }
    }

    public static X509Certificate readFile2Cert(String certFilePath) throws CertApiException {
        byte[] binData = TCAUtil.readFile2Byte(certFilePath);
        return binData[0] == 77 || binData[0] == 45 ? TCAUtil.convB64Str2Cert(new String(binData)) : TCAUtil.convBin2Cert(binData);
    }

    public static X509CRL convB642CRL(String b64Str) throws CertApiException {
        b64Str = b64Str.replaceAll("-----BEGIN CRL-----", "").replaceAll("-----BEGIN X509 CRL-----", "").replaceAll("-----END CRL-----", "").replaceAll("-----END X509 CRL-----", "").replaceAll("\r", "").replaceAll("\n", "");
        return TCAUtil.convBin2CRL(TCAUtil.decode(b64Str));
    }

    public static X509CRL convBin2CRL(byte[] in) throws CertApiException {
        try {
            if (cf == null) {
                cf = CertificateFactory.getInstance("X.509");
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(in);
            return (X509CRL)cf.generateCRL(bais);
        }
        catch (CertificateException e) {
            throw new CertApiException(TCAErrCode.ERR_CONV_CERT, (Throwable)e);
        }
        catch (CRLException e) {
            throw new CertApiException(TCAErrCode.ERR_CRL, (Throwable)e);
        }
    }

    public static String encode(byte[] in) {
        return Base64.encodeBase64String((byte[])in);
    }

    public static byte[] decode(String in) {
        return Base64.decodeBase64((String)in);
    }

    public static byte[] readURL2Byte(String urlStr) throws CertApiException {
        try {
            URL url = new URL(urlStr);
            InputStream is = url.openStream();
            byte[] buf = new byte[1024];
            int size = is.read(buf);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            while (size != -1) {
                bos.write(buf, 0, size);
                size = is.read(buf);
            }
            return bos.toByteArray();
        }
        catch (MalformedURLException e) {
            throw new CertApiException(TCAErrCode.ERR_BAD_URL, (Throwable)e);
        }
        catch (IOException e) {
            throw new CertApiException(TCAErrCode.ERR_STREAM, (Throwable)e);
        }
    }

    public static byte[] readIS2Byte(InputStream is) throws CertApiException {
        try {
            byte[] buf = new byte[1024];
            int size = is.read(buf);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            while (size != -1) {
                bos.write(buf, 0, size);
                size = is.read(buf);
            }
            return bos.toByteArray();
        }
        catch (IOException e) {
            throw new CertApiException(TCAErrCode.ERR_STREAM, (Throwable)e);
        }
    }

    public static byte[] readFile2Byte(String certFilePath) throws CertApiException {
        try {
            FileInputStream fis = new FileInputStream(certFilePath);
            return TCAUtil.readIS2Byte(fis);
        }
        catch (FileNotFoundException e) {
            throw new CertApiException(TCAErrCode.ERR_FILE_NOTFOUND, (Throwable)e);
        }
    }

    public static boolean writeByte2File(byte[] data, String filePath) throws CertApiException {
        try {
            FileOutputStream fos = new FileOutputStream(filePath);
            fos.write(data);
            fos.flush();
            fos.close();
            return true;
        }
        catch (FileNotFoundException e) {
            throw new CertApiException(TCAErrCode.ERR_FILE_NOTFOUND, (Throwable)e);
        }
        catch (IOException e) {
            throw new CertApiException(TCAErrCode.ERR_STREAM, (Throwable)e);
        }
    }

    public static byte[] PBEEncrypt(char[] pwd, byte[] in) throws CertApiException {
        return TCAUtil.doPBE(pwd, in, true);
    }

    public static byte[] PBEDecrypt(char[] pwd, byte[] in) throws CertApiException {
        return TCAUtil.doPBE(pwd, in, false);
    }

    public static byte[] MD5(String in) throws CertApiException {
        return TCAUtil.MD5(in, "UTF8");
    }

    public static byte[] MD5(String in, String charsetName) throws CertApiException {
        try {
            return TCAUtil.MD5(in.getBytes(charsetName));
        }
        catch (UnsupportedEncodingException e) {
            throw new CertApiException(TCAErrCode.ERR_ENCODE, (Throwable)e);
        }
    }

    public static byte[] MD5(byte[] in) throws CertApiException {
        return TCAUtil.doHash("MD5", in);
    }

    public static byte[] SHA1(String in) throws CertApiException {
        return TCAUtil.SHA1(in, "UTF8");
    }

    public static byte[] SHA1(String in, String charsetName) throws CertApiException {
        try {
            return TCAUtil.SHA1(in.getBytes(charsetName));
        }
        catch (UnsupportedEncodingException e) {
            throw new CertApiException(TCAErrCode.ERR_ENCODE, (Throwable)e);
        }
    }

    public static byte[] SHA1(byte[] in) throws CertApiException {
        return TCAUtil.doHash("SHA1", in);
    }

    public static byte[] SHA256(String in) throws CertApiException {
        return TCAUtil.SHA256(in, "UTF8");
    }

    public static byte[] SHA256(String in, String charsetName) throws CertApiException {
        try {
            return TCAUtil.SHA256(in.getBytes(charsetName));
        }
        catch (UnsupportedEncodingException e) {
            throw new CertApiException(TCAErrCode.ERR_ENCODE, (Throwable)e);
        }
    }

    public static byte[] SHA256(byte[] in) throws CertApiException {
        return TCAUtil.doHash("SHA256", in);
    }

    public static byte[] SM3(String in) throws CertApiException {
        return TCAUtil.SM3(in, "UTF8");
    }

    public static byte[] SM3(String in, String charsetName) throws CertApiException {
        try {
            return TCAUtil.SM3(in.getBytes(charsetName));
        }
        catch (UnsupportedEncodingException e) {
            throw new CertApiException(TCAErrCode.ERR_ENCODE, (Throwable)e);
        }
    }

    public static byte[] SM3(byte[] in) throws CertApiException {
        return TCAUtil.doHash("SM3", in);
    }

    public static String bin2HexStr(byte[] in) {
        return Hex.encodeHexString((byte[])in);
    }

    public static String genPubKeyHash(PublicKey pubKey) throws CertApiException {
        return TCAUtil.bin2HexStr(TCAUtil.SHA1(pubKey.getEncoded()));
    }

    public static CMSSignedData doGenSignedData(byte[] plain, List<SignerInfoGenerator> signerInfoGenerators, List<X509CertificateHolder> certs, List<X509CRLHolder> crls, boolean includeContent) throws CMSException {
        CMSSignedDataGenerator cmsSignedDataGen = new CMSSignedDataGenerator();
        if (certs != null && !certs.isEmpty()) {
            cmsSignedDataGen.addCertificates((Store)new CollectionStore(certs));
        }
        if (crls != null && !crls.isEmpty()) {
            cmsSignedDataGen.addCRLs((Store)new CollectionStore(crls));
        }
        for (SignerInfoGenerator sig : signerInfoGenerators) {
            cmsSignedDataGen.addSignerInfoGenerator(sig);
        }
        CMSProcessableByteArray msgContent = new CMSProcessableByteArray(plain);
        return cmsSignedDataGen.generate((CMSTypedData)msgContent, includeContent);
    }

    public static SignerInfoGenerator genSignerInfoGenerator(X509Certificate cert, PrivateKey priKey, String hashAlg, boolean addDeftAttr, Provider provider) throws OperatorCreationException {
        IssuerAndSerialNumber id = TCAUtil.getIssuerAndSerialNumber(cert);
        SignerIdentifier signerIdentifier = new SignerIdentifier(id);
        String signAlg = hashAlg == null || hashAlg.isEmpty() ? cert.getSigAlgName() : hashAlg + "with" + cert.getPublicKey().getAlgorithm();
        JcaContentSignerBuilder contentSignerBuilder = new JcaContentSignerBuilder(signAlg);
        contentSignerBuilder.setProvider(provider);
        ContentSigner contentSigner = contentSignerBuilder.build(priKey);
        DigestCalculatorProvider digestCalculatorProvider = new JcaDigestCalculatorProviderBuilder().build();
        return new SignerInfoGenerator(signerIdentifier, contentSigner, digestCalculatorProvider, !addDeftAttr);
    }

    private static TBSCertificateStructure getTBSCertificateStructure(X509Certificate cert) {
        try {
            return TBSCertificateStructure.getInstance((Object)ASN1Object.fromByteArray((byte[])cert.getTBSCertificate()));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("can't extract TBS structure from this cert");
        }
    }

    private static IssuerAndSerialNumber getIssuerAndSerialNumber(X509Certificate cert) {
        TBSCertificateStructure tbsCert = TCAUtil.getTBSCertificateStructure(cert);
        return new IssuerAndSerialNumber(X500Name.getInstance((Object)tbsCert.getIssuer()), tbsCert.getSerialNumber().getValue());
    }

    private static byte[] doHash(String alg, byte[] in) throws CertApiException {
        try {
            MessageDigest md = MessageDigest.getInstance(alg);
            return md == null ? null : md.digest(in);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CertApiException(TCAErrCode.ERR_UNKNOWN_ALG, (Throwable)e);
        }
    }

    private static byte[] doPBE(char[] pwd, byte[] in, boolean isEnc) throws CertApiException {
        try {
            byte[] pbeSlat = "noEvilShallEscapeMySight".getBytes();
            PBEKeySpec keySpec = new PBEKeySpec(pwd);
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("PBEWITHMD5andDES");
            SecretKey key = keyFactory.generateSecret(keySpec);
            Cipher cipher = Cipher.getInstance("PBEWITHMD5andDES");
            if (isEnc) {
                cipher.init(1, (Key)key, new PBEParameterSpec(pbeSlat, pbeSlat.length));
            } else {
                cipher.init(2, (Key)key, new PBEParameterSpec(pbeSlat, pbeSlat.length));
            }
            return cipher.doFinal(in);
        }
        catch (Exception e) {
            int errorCode = isEnc ? TCAErrCode.ERR_PBEENC : TCAErrCode.ERR_PBEDEC;
            throw new CertApiException(errorCode, (Throwable)e);
        }
    }

    static {
        if (Security.getProvider("TopSM") == null) {
            Security.addProvider((Provider)TopSMProvider.INSTANCE);
        }
        if (Security.getProperty("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        sm2Provider = Security.getProvider("TopSM");
        bcProvider = Security.getProvider("BC");
    }
}

