/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.api.cert;

import cn.topca.api.cert.BaseVerifier;
import cn.topca.api.cert.BasicVerifyProvider;
import cn.topca.api.cert.CRLVerifyProvider;
import cn.topca.api.cert.CertApiException;
import cn.topca.api.cert.IVerifierProvider;
import cn.topca.api.cert.OCSPVerifyProvider;
import cn.topca.api.cert.TCAErrCode;
import cn.topca.api.cert.VerifierConfig;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class VerifierMgr {
    private static final VerifierMgr VERIFIER_MGR_INSTANCE = new VerifierMgr();
    private List<VerifierConfig> configList = new ArrayList<VerifierConfig>();
    private Map<String, IVerifierProvider> providerMap = new HashMap<String, IVerifierProvider>();

    private VerifierMgr() {
    }

    public static synchronized VerifierMgr getInstance() {
        return VERIFIER_MGR_INSTANCE;
    }

    void init(List<VerifierConfig> configList) throws CertApiException {
        if (configList.isEmpty()) {
            this.configList.clear();
            this.providerMap.clear();
            return;
        }
        HashMap<String, IVerifierProvider> tmpProviderMap = new HashMap<String, IVerifierProvider>();
        for (VerifierConfig config : configList) {
            BaseVerifier provider;
            switch (config.getType()) {
                case 1: 
                case 2: {
                    provider = new CRLVerifyProvider();
                    break;
                }
                case 3: {
                    provider = new OCSPVerifyProvider();
                    break;
                }
                case 0: {
                    provider = new BasicVerifyProvider();
                    break;
                }
                default: {
                    throw new CertApiException(TCAErrCode.ERR_UNKNOWN_VERIFYTYPE);
                }
            }
            provider.config(config);
            tmpProviderMap.put(config.getName(), (IVerifierProvider)((Object)provider));
        }
        this.providerMap = tmpProviderMap;
    }

    public boolean verify(X509Certificate cert, Date date) throws CertApiException {
        IVerifierProvider provider = this.providerMap.get(cert.getIssuerX500Principal().toString());
        if (provider == null) {
            throw new CertApiException(TCAErrCode.ERR_NOFOUND_TRUSTCA);
        }
        return provider.verify(cert, date);
    }
}

