/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.security.bc.cms.jcajce;

import cn.tca.TopBasicCrypto.asn1.ASN1ObjectIdentifier;
import cn.tca.TopBasicCrypto.asn1.x509.AlgorithmIdentifier;
import cn.tca.TopBasicCrypto.cms.CMSException;
import cn.tca.TopBasicCrypto.jcajce.DefaultJcaJceHelper;
import cn.tca.TopBasicCrypto.jcajce.JcaJceHelper;
import cn.tca.TopBasicCrypto.jcajce.NamedJcaJceHelper;
import cn.tca.TopBasicCrypto.jcajce.ProviderJcaJceHelper;
import cn.tca.TopBasicCrypto.operator.GenericKey;
import cn.tca.TopBasicCrypto.operator.OutputEncryptor;
import cn.topca.security.bc.cms.jcajce.EnvelopedDataHelper;
import cn.topca.security.sm.CipherAgent;
import cn.topca.security.sm.CipherOutputStreamAgent;
import cn.topca.security.sm.KeyGeneratorAgent;
import java.io.OutputStream;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import javax.crypto.SecretKey;

public class JceCMSContentEncryptorBuilder {
    private final ASN1ObjectIdentifier encryptionOID;
    private final int keySize;
    private EnvelopedDataHelper helper = new EnvelopedDataHelper((JcaJceHelper)new DefaultJcaJceHelper());
    private SecureRandom random;

    public JceCMSContentEncryptorBuilder(ASN1ObjectIdentifier encryptionOID) {
        this(encryptionOID, -1);
    }

    public JceCMSContentEncryptorBuilder(ASN1ObjectIdentifier encryptionOID, int keySize) {
        this.encryptionOID = encryptionOID;
        this.keySize = keySize;
    }

    public JceCMSContentEncryptorBuilder setProvider(Provider provider) {
        this.helper = new EnvelopedDataHelper((JcaJceHelper)new ProviderJcaJceHelper(provider));
        return this;
    }

    public JceCMSContentEncryptorBuilder setProvider(String providerName) {
        this.helper = new EnvelopedDataHelper((JcaJceHelper)new NamedJcaJceHelper(providerName));
        return this;
    }

    public JceCMSContentEncryptorBuilder setSecureRandom(SecureRandom random) {
        this.random = random;
        return this;
    }

    public OutputEncryptor build() throws CMSException {
        return new CMSOutputEncryptor(this.encryptionOID, this.keySize, this.random);
    }

    private class CMSOutputEncryptor
    implements OutputEncryptor {
        private SecretKey encKey;
        private AlgorithmIdentifier algorithmIdentifier;
        private CipherAgent cipher;

        CMSOutputEncryptor(ASN1ObjectIdentifier encryptionOID, int keySize, SecureRandom random) throws CMSException {
            KeyGeneratorAgent keyGen = JceCMSContentEncryptorBuilder.this.helper.createKeyGenerator(encryptionOID);
            if (random == null) {
                random = new SecureRandom();
            }
            if (keySize < 0) {
                keyGen.init(random);
            } else {
                keyGen.init(keySize, random);
            }
            this.cipher = JceCMSContentEncryptorBuilder.this.helper.createCipher(encryptionOID);
            this.encKey = keyGen.generateKey();
            AlgorithmParameters params = JceCMSContentEncryptorBuilder.this.helper.generateParameters(encryptionOID, this.encKey, random);
            try {
                this.cipher.init(1, (Key)this.encKey, params, random);
            }
            catch (GeneralSecurityException e) {
                throw new CMSException("unable to initialize cipher: " + e.getMessage(), (Exception)e);
            }
            if (params == null) {
                params = this.cipher.getParameters();
            }
            this.algorithmIdentifier = JceCMSContentEncryptorBuilder.this.helper.getAlgorithmIdentifier(encryptionOID, params);
        }

        public AlgorithmIdentifier getAlgorithmIdentifier() {
            return this.algorithmIdentifier;
        }

        public OutputStream getOutputStream(OutputStream dOut) {
            return new CipherOutputStreamAgent(dOut, this.cipher);
        }

        public GenericKey getKey() {
            return new GenericKey((Object)this.encKey);
        }
    }
}

