/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.security.pkcs;

import cn.tca.TopBasicCrypto.util.encoders.Hex;
import cn.topca.security.util.DerOutputStream;
import cn.topca.security.util.DerValue;
import cn.topca.security.x509.AlgorithmId;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyRep;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;

public class PKCS8Key
implements PrivateKey {
    private static final long serialVersionUID = -3836890099307167124L;
    protected AlgorithmId algid;
    protected byte[] key;
    protected byte[] encodedKey;
    public static final BigInteger version = BigInteger.ZERO;

    public static PKCS8Key parse(DerValue paramDerValue) throws IOException {
        PrivateKey localPrivateKey = PKCS8Key.parseKey(paramDerValue);
        if (localPrivateKey instanceof PKCS8Key) {
            return (PKCS8Key)localPrivateKey;
        }
        throw new IOException("Provider did not return PKCS8Key");
    }

    public static PrivateKey parseKey(DerValue paramDerValue) throws IOException {
        PrivateKey localPrivateKey;
        if (paramDerValue.tag != 48) {
            throw new IOException("corrupt private key");
        }
        BigInteger localBigInteger = paramDerValue.data.getBigInteger();
        if (!version.equals(localBigInteger)) {
            throw new IOException("version mismatch: (supported: " + version.toString(16) + ", parsed: " + localBigInteger.toString(16));
        }
        AlgorithmId localAlgorithmId = AlgorithmId.parse(paramDerValue.data.getDerValue());
        try {
            localPrivateKey = PKCS8Key.buildPKCS8Key(localAlgorithmId, paramDerValue.data.getOctetString());
        }
        catch (InvalidKeyException localInvalidKeyException) {
            throw new IOException("corrupt private key");
        }
        if (paramDerValue.data.available() != 0) {
            throw new IOException("excess private key");
        }
        return localPrivateKey;
    }

    protected void parseKeyBits() throws IOException, InvalidKeyException {
        this.encode();
    }

    static PrivateKey buildPKCS8Key(AlgorithmId paramAlgorithmId, byte[] paramArrayOfByte) throws IOException, InvalidKeyException {
        DerOutputStream localDerOutputStream = new DerOutputStream();
        PKCS8Key.encode(localDerOutputStream, paramAlgorithmId, paramArrayOfByte);
        PKCS8EncodedKeySpec localPKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(localDerOutputStream.toByteArray());
        try {
            KeyFactory localKeyFactory = KeyFactory.getInstance(paramAlgorithmId.getName());
            return localKeyFactory.generatePrivate(localPKCS8EncodedKeySpec);
        }
        catch (NoSuchAlgorithmException localNoSuchAlgorithmException) {
        }
        catch (InvalidKeySpecException localInvalidKeySpecException) {
            // empty catch block
        }
        PKCS8Key localPKCS8Key = new PKCS8Key();
        localPKCS8Key.algid = paramAlgorithmId;
        localPKCS8Key.key = paramArrayOfByte;
        return localPKCS8Key;
    }

    public String getAlgorithm() {
        return this.algid.getName();
    }

    public AlgorithmId getAlgorithmId() {
        return this.algid;
    }

    public final void encode(DerOutputStream paramDerOutputStream) throws IOException {
        PKCS8Key.encode(paramDerOutputStream, this.algid, this.key);
    }

    public synchronized byte[] getEncoded() {
        byte[] arrayOfByte = null;
        try {
            arrayOfByte = this.encode();
        }
        catch (InvalidKeyException invalidKeyException) {
            // empty catch block
        }
        return arrayOfByte;
    }

    public String getFormat() {
        return "PKCS#8";
    }

    public byte[] encode() throws InvalidKeyException {
        if (this.encodedKey == null) {
            try {
                DerOutputStream localDerOutputStream = new DerOutputStream();
                this.encode(localDerOutputStream);
                this.encodedKey = localDerOutputStream.toByteArray();
            }
            catch (IOException localIOException) {
                throw new InvalidKeyException("IOException : " + localIOException.getMessage());
            }
        }
        return (byte[])this.encodedKey.clone();
    }

    public String toString() {
        return "algorithm = " + this.algid.toString() + ", unparsed keybits = \n" + new String(Hex.encode((byte[])this.key));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void decode(InputStream in) throws InvalidKeyException {
        try {
            DerValue der = new DerValue(in);
            if (der.tag != 48) {
                throw new InvalidKeyException("invalid key format");
            }
            BigInteger _version = der.data.getBigInteger();
            if (!_version.equals(version)) {
                throw new IOException("version mismatch: (supported: " + version.toString(16) + ", parsed: " + _version.toString(16));
            }
            this.algid = AlgorithmId.parse(der.data.getDerValue());
            this.key = der.data.getOctetString();
            this.parseKeyBits();
            if (der.data.available() != 0) return;
        }
        catch (IOException localIOException) {
            throw new InvalidKeyException("IOException : " + localIOException.getMessage());
        }
    }

    public void decode(byte[] encoded) throws InvalidKeyException {
        this.decode(new ByteArrayInputStream(encoded));
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new KeyRep(KeyRep.Type.PRIVATE, this.getAlgorithm(), this.getFormat(), this.getEncoded());
    }

    private void readObject(ObjectInputStream in) throws IOException {
        try {
            this.decode(in);
        }
        catch (InvalidKeyException localInvalidKeyException) {
            localInvalidKeyException.printStackTrace();
            throw new IOException("deserialized key is invalid: " + localInvalidKeyException.getMessage());
        }
    }

    static void encode(DerOutputStream out, AlgorithmId algId, byte[] encoded) throws IOException {
        DerOutputStream _out = new DerOutputStream();
        _out.putInteger(version);
        algId.encode(_out);
        _out.putOctetString(encoded);
        out.write((byte)48, _out);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Key) {
            byte[] arrayOfByte2;
            byte[] encoded = this.encodedKey != null ? this.encodedKey : this.getEncoded();
            if (encoded.length != (arrayOfByte2 = ((Key)obj).getEncoded()).length) {
                return false;
            }
            for (int i = 0; i < encoded.length; ++i) {
                if (encoded[i] == arrayOfByte2[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int i = 0;
        byte[] encoded = this.getEncoded();
        for (int j = 1; j < encoded.length; ++j) {
            i += encoded[j] * j;
        }
        return i;
    }
}

