/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.security.sm;

import cn.topca.security.sm.CipherAgent;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherOutputStream;
import javax.crypto.IllegalBlockSizeException;

public class CipherOutputStreamAgent
extends OutputStream {
    private final OutputStream out;
    private final CipherAgent agent;
    private final CipherOutputStream cout;
    private final ByteArrayOutputStream buffer;

    public CipherOutputStreamAgent(OutputStream out, CipherAgent agent) {
        this.out = out;
        this.agent = agent;
        if (agent.getCipher() != null) {
            this.cout = new CipherOutputStream(out, agent.getCipher());
            this.buffer = null;
        } else {
            this.cout = null;
            this.buffer = new ByteArrayOutputStream(agent.getBlockSize());
        }
    }

    public synchronized void write(int b) throws IOException {
        if (this.cout != null) {
            this.cout.write(b);
            return;
        }
        this.buffer.write(b);
        if (this.buffer.size() == this.agent.getBlockSize()) {
            this.out.write(this.agent.update(this.buffer.toByteArray()));
            this.buffer.reset();
        }
    }

    public synchronized void flush() throws IOException {
        try {
            this.out.write(this.agent.doFinal(this.buffer.toByteArray()));
            this.out.flush();
        }
        catch (IllegalBlockSizeException e) {
            e.printStackTrace();
        }
        catch (BadPaddingException e) {
            e.printStackTrace();
        }
    }
}

