/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.security.sm;

import cn.topca.security.ConstructKeys;
import cn.topca.security.ec.NamedCurve;
import cn.topca.security.sm.SM2Core;
import cn.topca.security.sm.SM2EncData;
import cn.topca.security.sm.SM2KeyFactory;
import cn.topca.security.sm.SM2Padding;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.interfaces.ECKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;

public class SM2Cipher
extends CipherSpi {
    private static final byte[] B0 = new byte[0];
    private static final String PAD_NONE = "NoPadding";
    private String paddingType = "NOPADDING";
    private SM2Padding padding;
    private ECPublicKey publicKey;
    private ECPrivateKey privateKey;
    private MessageDigest c3Gen;
    private boolean digestReset;
    private ByteArrayOutputStream buffer;

    public SM2Cipher() {
        try {
            this.c3Gen = MessageDigest.getInstance("SM3");
        }
        catch (NoSuchAlgorithmException e) {
            throw new ProviderException(e);
        }
        this.digestReset = true;
    }

    protected byte[] engineDoFinal(byte[] in, int inOfs, int inLen) throws IllegalBlockSizeException, BadPaddingException {
        this._update(in, inOfs, inLen);
        return this._doFinal();
    }

    protected int engineDoFinal(byte[] in, int inOfs, int inLen, byte[] out, int outOfs) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        this._update(in, inOfs, inLen);
        int outputSize = this.buffer.size();
        if (outputSize > out.length - outOfs) {
            throw new ShortBufferException("Need " + outputSize + " bytes for output");
        }
        byte[] result = this._doFinal();
        int n = result.length;
        System.arraycopy(result, 0, out, outOfs, n);
        return n;
    }

    protected int engineGetBlockSize() {
        return 0;
    }

    protected byte[] engineGetIV() {
        return null;
    }

    protected int engineGetOutputSize(int inputLen) {
        return inputLen;
    }

    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        try {
            this._init(opmode, key, random, null);
        }
        catch (InvalidAlgorithmParameterException iape) {
            InvalidKeyException ike = new InvalidKeyException("Wrong parameters");
            ike.initCause(iape);
            throw ike;
        }
    }

    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this._init(opmode, key, random, params);
    }

    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (params == null) {
            this._init(opmode, key, random, null);
        } else {
            try {
                NamedCurve spec = params.getParameterSpec(NamedCurve.class);
                this._init(opmode, key, random, spec);
            }
            catch (InvalidParameterSpecException ipse) {
                InvalidAlgorithmParameterException iape = new InvalidAlgorithmParameterException("Wrong parameter");
                iape.initCause(ipse);
                throw iape;
            }
        }
    }

    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
        if (!mode.equalsIgnoreCase("ECB")) {
            throw new NoSuchAlgorithmException("Unsupported mode " + mode);
        }
    }

    protected void engineSetPadding(String paddingName) throws NoSuchPaddingException {
        if (!paddingName.equalsIgnoreCase(PAD_NONE)) {
            throw new NoSuchPaddingException("Padding " + paddingName + " not supported");
        }
        this.paddingType = PAD_NONE;
    }

    protected byte[] engineUpdate(byte[] in, int inOfs, int inLen) {
        this._update(in, inOfs, inLen);
        return B0;
    }

    protected int engineUpdate(byte[] in, int inOfs, int inLen, byte[] out, int outOfs) throws ShortBufferException {
        this._update(in, inOfs, inLen);
        return 0;
    }

    protected byte[] engineWrap(Key key) throws InvalidKeyException, IllegalBlockSizeException {
        byte[] encoded = key.getEncoded();
        if (encoded == null || encoded.length == 0) {
            throw new InvalidKeyException("Could not obtain encoded key");
        }
        this._update(encoded, 0, encoded.length);
        try {
            return this._doFinal();
        }
        catch (BadPaddingException e) {
            throw new InvalidKeyException("Wrapping failed", e);
        }
    }

    protected Key engineUnwrap(byte[] wrappedKey, String algorithm, int type) throws InvalidKeyException, NoSuchAlgorithmException {
        this._update(wrappedKey, 0, wrappedKey.length);
        try {
            byte[] encoded = this._doFinal();
            return ConstructKeys.constructKey(encoded, algorithm, type);
        }
        catch (BadPaddingException e) {
            throw new InvalidKeyException("Unwrapping failed", e);
        }
        catch (IllegalBlockSizeException e) {
            throw new InvalidKeyException("Unwrapping failed", e);
        }
    }

    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        ECKey ecKey = SM2KeyFactory.toSM2Key(key);
        return ecKey.getParams().getCurve().getField().getFieldSize();
    }

    private void _init(int opmode, Key key, SecureRandom random, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this._resetDigest();
        ECKey sm2Key = SM2KeyFactory.toSM2Key(key);
        switch (opmode) {
            case 1: 
            case 3: {
                this.publicKey = (ECPublicKey)sm2Key;
                this.privateKey = null;
                break;
            }
            case 2: 
            case 4: {
                this.privateKey = (ECPrivateKey)sm2Key;
                this.publicKey = null;
                break;
            }
            default: {
                throw new InvalidKeyException("Unknown mode: " + opmode);
            }
        }
        if (this.paddingType.equalsIgnoreCase(PAD_NONE)) {
            this.padding = SM2Padding.getInstance(0, random);
        }
        this.buffer = new ByteArrayOutputStream();
    }

    private void _update(byte[] in, int inOfs, int inLen) {
        this.buffer.write(in, inOfs, inLen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] _doFinal() throws BadPaddingException, IllegalBlockSizeException {
        try {
            byte[] data;
            if (this.publicKey != null) {
                byte[] data2 = this.padding.pad(this.buffer.toByteArray());
                byte[] byArray = this._encrypt(data2, this.publicKey);
                return byArray;
            }
            try {
                data = this._decrypt(this.buffer.toByteArray(), this.privateKey);
            }
            catch (IOException e) {
                throw new BadPaddingException(e.getMessage());
            }
            byte[] byArray = this.padding.unpad(data);
            return byArray;
        }
        finally {
            this._resetDigest();
        }
    }

    private byte[] _encrypt(byte[] data, ECPublicKey publicKey) {
        SM2Core sm2 = new SM2Core(publicKey);
        SM2EncData encData = new SM2EncData();
        encData.setC1Point(sm2.c1Point());
        encData.setC2Data(sm2.c2Data(data));
        encData.setC3Hash(sm2.c3Hash(data));
        return encData.getEncoded();
    }

    private byte[] _decrypt(byte[] data, ECPrivateKey privateKey) throws IOException, BadPaddingException {
        byte[] origin;
        SM2EncData encData = new SM2EncData(data);
        SM2Core sm2 = new SM2Core(encData.getC1Point(), privateKey);
        byte[] hash = sm2.c3Hash(origin = sm2.c2Data(encData.getC2Data()));
        if (Arrays.equals(hash, encData.getC3Hash())) {
            return origin;
        }
        throw new BadPaddingException("Invalid data, verify hash fail.");
    }

    private void _resetDigest() {
        if (!this.digestReset) {
            this.c3Gen.reset();
            this.digestReset = true;
        }
    }
}

