/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.security.sm;

import cn.topca.security.ec.ECParameters;
import cn.topca.security.ec.ECUtil;
import cn.topca.security.ec.NamedCurve;
import cn.topca.security.sm.SM2PrivateKey;
import cn.topca.security.sm.SM2PublicKey;
import cn.topca.security.util.DerInputStream;
import cn.topca.security.util.DerOutputStream;
import cn.topca.security.util.DerValue;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.SignatureException;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import org.apache.commons.codec.binary.Hex;

class SM2Sign {
    char[] dis = "0FFFFF81E971FA3F09107ABF77931463FC0710BFB8962EFEAE3D5654B073BB0C".toCharArray();
    String K;
    protected static final ECParameterSpec sm2Curve = NamedCurve.getECParameterSpec("SM2");
    boolean isTesting = false;
    public SM2PrivateKey privateKey;
    public SM2PublicKey publicKey;

    SM2Sign() {
    }

    protected byte[] engineSign() throws Exception {
        byte[] digest = Hex.decodeHex((char[])this.dis);
        if (this.isTesting) {
            String check = "B524F552CD82B8B028476E005C377FB19A87E6FC682D48BB5D42E3D9B9EFFE76";
        }
        byte[] signedData = null;
        BigInteger k = null;
        ECPoint kg = null;
        BigInteger r = null;
        BigInteger s = null;
        ByteArrayOutputStream out = null;
        try {
            while (true) {
                BigInteger e;
                if ((r = (e = new BigInteger(1, digest)).add((kg = ECUtil.getECPoint(sm2Curve, k = this.isTesting ? ECUtil.getRandomMultiple(sm2Curve) : new BigInteger(this.K, 16))).getAffineX()).mod(sm2Curve.getOrder())).equals(BigInteger.ZERO) || r.add(k).equals(sm2Curve.getOrder())) {
                    continue;
                }
                if (this.isTesting) {
                    // empty if block
                }
                BigInteger a = BigInteger.ONE.add(this.privateKey.getS());
                a = a.modInverse(sm2Curve.getOrder());
                BigInteger b = r.multiply(this.privateKey.getS());
                s = a.multiply(b = k.subtract(b).mod(sm2Curve.getOrder())).mod(sm2Curve.getOrder());
                if (!s.equals(BigInteger.ZERO)) break;
            }
            if (this.isTesting) {
                String check = "6CB28D99385C175C94F94E934817663FC176D925DD72B727260DBAAE1FB2F96F";
                check = "110FCDA57615705D5E7B9324AC4B856D23E6D9188B2AE47759514657CE25D112";
                check = "1C65D68A4A08601DF24B431E0CAB4EBE084772B3817E85811A8510B2DF7ECA1A";
                check = "40F1EC59F793D9F49E09DCEF49130D4194F79FB1EED2CAA55BACDB49C4E755D1";
                check = "6FC6DAC32C5D5CF10C77DFB20F7C2EB667A457872FB09EC56327A67EC7DEEBE7";
            }
            out = new DerOutputStream();
            ((DerOutputStream)out).write((byte)2, ECParameters.trimZeroes(r.toByteArray()));
            ((DerOutputStream)out).write((byte)2, ECParameters.trimZeroes(s.toByteArray()));
            signedData = out.toByteArray();
            out.close();
            if (!"old".equalsIgnoreCase(System.getProperty("cn.topca.sm2"))) {
                out = new DerOutputStream();
                ((DerOutputStream)out).write((byte)48, signedData);
                signedData = out.toByteArray();
            }
        }
        catch (IOException e) {
            throw new SignatureException(e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return signedData;
    }

    protected boolean engineVerify(byte[] sigBytes) throws Exception {
        BigInteger s;
        BigInteger r;
        byte[] md;
        boolean result;
        block6: {
            result = false;
            md = Hex.decodeHex((char[])this.dis);
            r = null;
            s = null;
            try {
                DerInputStream dis = new DerInputStream(sigBytes);
                try {
                    DerValue[] values = dis.getSequence(2);
                    r = values[0].getPositiveBigInteger();
                    s = values[1].getPositiveBigInteger();
                }
                catch (Exception e) {
                    dis.reset();
                    r = dis.getPositiveBigInteger();
                    s = dis.getPositiveBigInteger();
                }
            }
            catch (Exception e) {
                int n = sigBytes.length >> 1;
                if (sigBytes.length != 64) break block6;
                byte[] temp1 = new byte[n];
                byte[] temp2 = new byte[n];
                System.arraycopy(sigBytes, 0, temp1, 0, n);
                System.arraycopy(sigBytes, n, temp2, 0, n);
                r = new BigInteger(1, temp1);
                s = new BigInteger(1, temp2);
            }
        }
        if (r == null || s == null) {
            throw new SignatureException("Parsing signature failed! " + Hex.encodeHexString((byte[])sigBytes));
        }
        BigInteger e = new BigInteger(1, md);
        BigInteger t = r.add(s).mod(sm2Curve.getOrder());
        if (t.equals(BigInteger.ZERO)) {
            return false;
        }
        cn.tca.TopBasicCrypto.math.ec.ECPoint sg = ECUtil.getBC_ECGeneratorPoint(sm2Curve).multiply(s);
        cn.tca.TopBasicCrypto.math.ec.ECPoint tp = ECUtil.convertToBC_ECPoint(sm2Curve.getCurve(), this.publicKey.getW()).multiply(t);
        cn.tca.TopBasicCrypto.math.ec.ECPoint point = sg.add(tp);
        BigInteger R = e.add(point.getX().toBigInteger()).mod(sm2Curve.getOrder());
        result = r.equals(R);
        return result;
    }
}

