/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.security.sm;

import cn.topca.security.ec.ECParameters;
import cn.topca.security.ec.ECUtil;
import cn.topca.security.sm.SM2Core;
import cn.topca.security.sm.SM2GenParameterSpec;
import cn.topca.security.sm.SM2KeyFactory;
import cn.topca.security.sm.SM2PrivateKey;
import cn.topca.security.sm.SM2PublicKey;
import cn.topca.security.sm.SM2UserID;
import cn.topca.security.util.DerInputStream;
import cn.topca.security.util.DerOutputStream;
import cn.topca.security.util.DerValue;
import cn.topca.security.util.ObjectIdentifier;
import cn.topca.security.x509.AlgorithmId;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.ECKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import org.apache.commons.codec.binary.Hex;

public class SM2Signature
extends SignatureSpi
implements Cloneable {
    private ECParameterSpec sm2Curve = null;
    private final MessageDigest md;
    private boolean digestReset;
    private ECPrivateKey privateKey;
    private ECPublicKey publicKey;
    private SM2GenParameterSpec spec;
    private boolean isTesting = false;
    private static final byte[] USER_ID = "1234567812345678".getBytes();
    public static final String P_USER_ID = "UserID";
    public static final String P_PUBLICKEY = "PublicKey";

    protected SM2Signature(String digestAlgName, ObjectIdentifier digestOID) {
        try {
            this.md = MessageDigest.getInstance(digestAlgName);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ProviderException(e);
        }
        this.digestReset = true;
    }

    protected void engineSetParameter(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        if (!this.digestReset) {
            throw new UnsupportedOperationException("Can not set parameter after update()");
        }
        if (params instanceof SM2GenParameterSpec) {
            this.spec = (SM2GenParameterSpec)params;
            if (!this.spec.readyForGenerateZ()) {
                throw new InvalidAlgorithmParameterException("Invalid SM2GenParameterSpce.");
            }
        } else {
            throw new InvalidAlgorithmParameterException("Must be SM2GenParameterSpec.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initCommon(ECKey key, SecureRandom secureRandom) throws InvalidKeyException {
        ECParameterSpec params;
        this.resetDigest();
        if (this.appRandom == null) {
            this.appRandom = secureRandom;
        }
        if ((params = key.getParams()) != null && !params.equals(SM2Core.sm2Curve)) {
            if (!params.toString().matches(".*SM2.*")) throw new InvalidKeyException("need SM2 key, but " + key);
            this.sm2Curve = params;
        } else {
            this.sm2Curve = SM2Core.sm2Curve;
        }
        this.spec = null;
    }

    private void resetDigest() {
        if (!this.digestReset) {
            this.md.reset();
            this.digestReset = true;
        }
    }

    private byte[] getDigestValue() {
        this.digestReset = true;
        return this.md.digest();
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        ECPublicKey _t = (ECPublicKey)SM2KeyFactory.toSM2Key(publicKey);
        this.privateKey = null;
        this.publicKey = _t;
        this.initCommon(this.publicKey, null);
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        ECPoint w;
        ECPrivateKey _t;
        this.privateKey = _t = (ECPrivateKey)SM2KeyFactory.toSM2Key(privateKey);
        if (_t instanceof SM2PrivateKey) {
            w = ((SM2PrivateKey)_t).getW();
        } else {
            if (this.sm2Curve == null) {
                this.sm2Curve = SM2Core.sm2Curve;
            }
            w = ECUtil.getECPoint(this.sm2Curve, _t.getS());
        }
        try {
            this.publicKey = new SM2PublicKey(w, _t.getParams());
        }
        catch (InvalidParameterSpecException e) {
            e.printStackTrace();
        }
        this.initCommon(this.privateKey, null);
    }

    protected void engineUpdate(byte b) throws SignatureException {
        this.updateZ();
        this.md.update(b);
        this.digestReset = false;
    }

    protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
        this.updateZ();
        this.md.update(b, off, len);
        this.digestReset = false;
    }

    protected byte[] engineSign() throws SignatureException {
        byte[] digest = this.getDigestValue();
        if (this.isTesting) {
            String check = "B524F552CD82B8B028476E005C377FB19A87E6FC682D48BB5D42E3D9B9EFFE76";
        }
        byte[] signedData = null;
        BigInteger k = null;
        ECPoint kg = null;
        BigInteger r = null;
        BigInteger s = null;
        ByteArrayOutputStream out = null;
        try {
            while (true) {
                BigInteger e;
                if ((r = (e = new BigInteger(1, digest)).add((kg = ECUtil.getECPoint(this.sm2Curve, k = !this.isTesting ? ECUtil.getRandomMultiple(this.sm2Curve) : new BigInteger("6CB28D99385C175C94F94E934817663FC176D925DD72B727260DBAAE1FB2F96F", 16))).getAffineX()).mod(this.sm2Curve.getOrder())).equals(BigInteger.ZERO) || r.add(k).equals(this.sm2Curve.getOrder())) {
                    continue;
                }
                if (this.isTesting) {
                    // empty if block
                }
                BigInteger a = BigInteger.ONE.add(this.privateKey.getS());
                a = a.modInverse(this.sm2Curve.getOrder());
                BigInteger b = r.multiply(this.privateKey.getS());
                s = a.multiply(b = k.subtract(b).mod(this.sm2Curve.getOrder())).mod(this.sm2Curve.getOrder());
                if (!s.equals(BigInteger.ZERO)) break;
            }
            if (this.isTesting) {
                String check = "6CB28D99385C175C94F94E934817663FC176D925DD72B727260DBAAE1FB2F96F";
                check = "110FCDA57615705D5E7B9324AC4B856D23E6D9188B2AE47759514657CE25D112";
                check = "1C65D68A4A08601DF24B431E0CAB4EBE084772B3817E85811A8510B2DF7ECA1A";
                check = "40F1EC59F793D9F49E09DCEF49130D4194F79FB1EED2CAA55BACDB49C4E755D1";
                check = "6FC6DAC32C5D5CF10C77DFB20F7C2EB667A457872FB09EC56327A67EC7DEEBE7";
            }
            out = new DerOutputStream();
            ((DerOutputStream)out).write((byte)2, ECParameters.trimZeroes(r.toByteArray()));
            ((DerOutputStream)out).write((byte)2, ECParameters.trimZeroes(s.toByteArray()));
            signedData = out.toByteArray();
            out.close();
            if (!"old".equalsIgnoreCase(System.getProperty("cn.topca.sm2"))) {
                out = new DerOutputStream();
                ((DerOutputStream)out).write((byte)48, signedData);
                signedData = out.toByteArray();
            }
        }
        catch (IOException e) {
            throw new SignatureException(e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return signedData;
    }

    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        BigInteger s;
        BigInteger r;
        byte[] md;
        boolean result;
        block7: {
            result = false;
            md = this.md.digest();
            r = null;
            s = null;
            try {
                DerInputStream dis = new DerInputStream(sigBytes);
                try {
                    DerValue[] values = dis.getSequence(2);
                    r = values[0].getPositiveBigInteger();
                    s = values[1].getPositiveBigInteger();
                }
                catch (Exception e) {
                    dis.reset();
                    r = dis.getPositiveBigInteger();
                    s = dis.getPositiveBigInteger();
                }
            }
            catch (Exception e) {
                int n = sigBytes.length >> 1;
                if (sigBytes.length != 64) break block7;
                byte[] temp1 = new byte[n];
                byte[] temp2 = new byte[n];
                System.arraycopy(sigBytes, 0, temp1, 0, n);
                System.arraycopy(sigBytes, n, temp2, 0, n);
                r = new BigInteger(1, temp1);
                s = new BigInteger(1, temp2);
            }
        }
        if (r == null || s == null) {
            throw new SignatureException("Parsing signature failed! " + Hex.encodeHexString((byte[])sigBytes));
        }
        BigInteger e = new BigInteger(1, md);
        BigInteger t = r.add(s).mod(this.sm2Curve.getOrder());
        if (t.equals(BigInteger.ZERO)) {
            return false;
        }
        cn.tca.TopBasicCrypto.math.ec.ECPoint sg = ECUtil.getBC_ECGeneratorPoint(this.sm2Curve).multiply(s);
        cn.tca.TopBasicCrypto.math.ec.ECPoint tp = ECUtil.convertToBC_ECPoint(this.sm2Curve.getCurve(), this.publicKey.getW()).multiply(t);
        cn.tca.TopBasicCrypto.math.ec.ECPoint point = sg.add(tp);
        BigInteger R = e.add(point.getX().toBigInteger()).mod(this.sm2Curve.getOrder());
        if (this.isTesting) {
            String check = "B524F552CD82B8B028476E005C377FB19A87E6FC682D48BB5D42E3D9B9EFFE76";
            check = "2B75F07ED7ECE7CCC1C8986B991F441AD324D6D619FE06DD63ED32E0C997C801";
            check = "7DEACE5FD121BC385A3C6317249F413D28C17291A60DFD83B835A45392D22B0A";
            check = "2E49D5E5279E5FA91E71FD8F693A64A3C4A9461115A4FC9D79F34EDC8BDDEBD0";
            check = "1657FA75BF2ADCDC3C1F6CF05AB7B45E04D3ACBE8E4085CFA669CB2564F17A9F";
            check = "19F0115F21E16D2F5C3A485F8575A128BBCDDF80296A62F6AC2EB842DD058E50";
            check = "110FCDA57615705D5E7B9324AC4B856D23E6D9188B2AE47759514657CE25D112";
            check = "1C65D68A4A08601DF24B431E0CAB4EBE084772B3817E85811A8510B2DF7ECA1A";
            check = "40F1EC59F793D9F49E09DCEF49130D4194F79FB1EED2CAA55BACDB49C4E755D1";
        }
        result = r.equals(R);
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void engineSetParameter(String key, Object value) throws InvalidParameterException {
        if (!this.digestReset) {
            throw new UnsupportedOperationException("Can not set UserID or PublicKey parameter after update()");
        }
        if (this.spec == null) {
            this.spec = new SM2GenParameterSpec();
        }
        if (P_PUBLICKEY.equalsIgnoreCase(key)) {
            if (!(value instanceof ECPublicKey)) throw new InvalidParameterException("Invalid value for PublicKey.");
            try {
                this.spec.setPublicKey((ECPublicKey)value);
                return;
            }
            catch (InvalidKeyException e) {
                throw new InvalidParameterException(e.getMessage());
            }
        } else {
            SM2UserID userID;
            if (!P_USER_ID.equalsIgnoreCase(key)) throw new InvalidParameterException("Unknown parameter key " + key + ".");
            if (value instanceof byte[]) {
                userID = new SM2UserID((byte[])value);
            } else {
                if (!(value instanceof SM2UserID)) throw new InvalidParameterException("Invalid value for UserID.");
                userID = (SM2UserID)value;
            }
            this.spec.setUserID(userID);
        }
    }

    protected Object engineGetParameter(String key) throws InvalidParameterException {
        if (P_USER_ID.equalsIgnoreCase(key)) {
            return this.spec.getUserID();
        }
        if (P_PUBLICKEY.equalsIgnoreCase(key)) {
            return this.spec.getPublicKey();
        }
        throw new InvalidParameterException("Unknown parameter key " + key + ".");
    }

    private void updateZ() {
        if (this.digestReset && this.spec == null && !"old".equalsIgnoreCase(System.getProperty("cn.topca.sm2"))) {
            try {
                this.spec = new SM2GenParameterSpec(new SM2UserID(USER_ID), this.publicKey);
            }
            catch (InvalidKeyException e) {
                e.printStackTrace();
            }
        }
        if (this.spec != null && this.spec.readyForGenerateZ()) {
            byte[] z = this.spec.generateZ();
            this.md.update(z);
            this.spec = null;
            this.digestReset = false;
        }
    }

    protected static void testSign() throws InvalidKeyException, InvalidParameterSpecException, SignatureException, InvalidAlgorithmParameterException {
        SM2Signature sign = new SM2Signature("SM3", null);
        sign.isTesting = true;
        sign.engineInitSign(SM2PrivateKey.getTestKey());
        sign.engineSetParameter(SM2GenParameterSpec.getTestGenParameterSpec().test());
        String M = "message digest";
        sign.engineUpdate(M.getBytes(), 0, M.length());
        sign.engineSign();
    }

    protected static boolean testVerify() throws InvalidKeyException, InvalidParameterSpecException, InvalidAlgorithmParameterException, SignatureException {
        SM2Signature sign = new SM2Signature("SM3", null);
        sign.isTesting = true;
        sign.engineInitVerify(SM2PublicKey.getTestKey());
        sign.engineSetParameter(SM2GenParameterSpec.getTestGenParameterSpec().test());
        String M = "message digest";
        sign.engineUpdate(M.getBytes(), 0, M.length());
        return sign.engineVerify(cn.tca.TopBasicCrypto.util.encoders.Hex.decode((String)"40F1EC59F793D9F49E09DCEF49130D4194F79FB1EED2CAA55BACDB49C4E755D16FC6DAC32C5D5CF10C77DFB20F7C2EB667A457872FB09EC56327A67EC7DEEBE7"));
    }

    protected static void testVerify4Check() throws InvalidKeyException, InvalidParameterSpecException, InvalidAlgorithmParameterException, SignatureException {
        String[] checkUserId = new String[]{"5E733FA6FEBB285D4F0E10A165B621F2734C", "493C6B9EF3607498FDB4F672A60BA6E2106E", "C7A8AA37121B9F1B831C0BDAF60F9236C8C9", "403FF2882148575F066C2E457C0346144870", "973701AAC8D41C69B420F7C90744C9E98170"};
        String[] checkZ = new String[]{"FBED7C2D2EE8F83827B90B677B1E44DA9D4ED456C5FF5A2534D96157619475BC", "BAD57091656DC31763FC90598236E7FF44C97771E41047F2BE82BAF92A94A508", "F6B66BFE10AF6CBE5123D67F31754FD5F2EF816A90237759F1BDE7F141D6E15C", "7DAC0BB42D22983B09CA2EE6B3715928CC2682D306AEBE77DBB1A2C4074CC6B9", "83E724803A3A55C5AD60FA910CD3E40B8DE4B94D4D92B36EB6E6DABC05329E75"};
        String[] checkM = new String[]{"48398280C8A7B078B7C9B310E43952E0146566ADBE41A06D9A90B9DC7E8BD214", "C290E4D1E9F73EF7444B397BFB8B382A975576FBE64E124C0016E19E6D8738EF", "82B94EA04CA00D0A9C18ED22ED128C0BA436475FA12EF95872EE28D26FB03432", "8A7132007128C92CB98EF6364B254EE38A521F041D54DEF84E7429111A7CDBF7", "1D8E3136A649E81D86324AF6811C1C76A3BA6B3A86A128C47F03EDEF01D71F35"};
        String[] checkPublicKey = new String[]{"044C66A2E97D2FA9ABF98354596B1DD4F879F90B2A50A69F72EEC98403BD31A130A3BA5D3F29A299A2E35EEB45AF11D234D48F5A726D818D0CEFE8A6723B6490C6", "041C21D9E036012E9300698118FC747959A21B855F72F0024208599027F69BD24EC2C3C870162750786A9C999A7B7FCEEF0831EDDECD7987D10B96FDC9DE312202", "048BCBF071357CEC5DAFC563653F1C8EE43C0546F9EFFF20DBCDB91CB4BBC6B470F34001E9688B00DF0E009E68A2F6BC3FE72A396176FAC51415EA845FF4947A68", "043C58397506CAF51F74E2471955C2258E5E22B5A16E909B97920191498AC9E7427A7B1093DB84473308CF7B911FB8E65323CE2C133F46C6BB6CBD60EFE422D84F", "04FE22BD0757B4929DC45ED76289DE17BDBB6D14DC194E45B80D19DDBCCEB6B35DD28D9DB858D38D035A23257320108BD2CD216D185A84AB0CF9AA0D6778DE00B3"};
        String[] checkRS = new String[]{"16F2376B5FE608ACC6E9E484BC73F8AFCCB4E01E64326987AF77655EA6BDF338828867B97B6D7F962B0C8F20E8A5F48A9558CDE5208CF03BA141BAE7E67BB612", "F699D05D2424EB8C90578BBAC68AEFEDD69F72ADFC5204AAF5E7F2F56BB970818168D24F39468BB23A530B110817C22EA27C8E402B47CED1523B9041A938B850", "2883CAB5660B81208D19D7D5158101B4EBCDB14688D17CBD4BEBCC9AEC3FC576ADADA3B9B2944F14C4A3FC7FBB22DA79C8F8AA778D68724BD93E539A2FDFE300", "DFCE3A9680204CC0F0DA07FE34276C30D87F55594981578FEC2BE903988ED929AA752B047C0B9840246BB95EB97F2495582572878EB4EB39D38A88FBADD3A0B7", "DB1D57A58947A2DBF8061177A8EFC7B3C122E1F090991B4880E8E3500A66DAD4C0EB751EAF47C91A3706D8F6C1ECC9939AD87C4F654868BD05D0B6D7341E236D"};
        for (int i = 0; i < checkRS.length; ++i) {
            SM2Signature sign = new SM2Signature("SM3", null);
            SM2PublicKey publicKey = new SM2PublicKey(cn.tca.TopBasicCrypto.util.encoders.Hex.decode((String)checkPublicKey[i]));
            sign.engineInitVerify(publicKey);
            SM2GenParameterSpec params = new SM2GenParameterSpec(new SM2UserID(cn.tca.TopBasicCrypto.util.encoders.Hex.decode((String)checkUserId[i])), publicKey);
            sign.engineSetParameter(params);
            boolean check = Arrays.equals(params.generateZ(), cn.tca.TopBasicCrypto.util.encoders.Hex.decode((String)checkZ[i]));
            byte[] M = cn.tca.TopBasicCrypto.util.encoders.Hex.decode((String)checkM[i]);
            sign.engineUpdate(M, 0, M.length);
            check = sign.engineVerify(cn.tca.TopBasicCrypto.util.encoders.Hex.decode((String)checkRS[i]));
        }
    }

    public static final class SHA256withSM2
    extends SM2Signature {
        public SHA256withSM2() {
            super("SHA-256", AlgorithmId.SHA256_oid);
        }
    }

    public static final class SHA1withSM2
    extends SM2Signature {
        public SHA1withSM2() {
            super("SHA1", AlgorithmId.SHA_oid);
        }
    }

    public static final class SM3withSM2
    extends SM2Signature {
        public SM3withSM2() {
            super("SM3", AlgorithmId.SM3_oid);
        }
    }
}

